/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.RowStoreAVLHybrid;

public class RowStoreAVLHybridExtended
extends RowStoreAVLHybrid {
    Session session;

    public RowStoreAVLHybridExtended(Session session, TableBase tableBase, boolean bl) {
        super(session, tableBase, bl);
        this.session = session;
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean bl) {
        return super.getNewCachedObject(session, object, bl);
    }

    @Override
    public synchronized void add(Session session, CachedObject cachedObject, boolean bl) {
        super.add(session, cachedObject, bl);
        if (bl) {
            RowAction.addInsertAction(session, (Table)this.table, (Row)cachedObject);
        }
    }

    @Override
    public void indexRow(Session session, Row row) {
        NodeAVL nodeAVL = ((RowAVL)row).getNode(0);
        int n = 0;
        while (nodeAVL != null) {
            ++n;
            nodeAVL = nodeAVL.nNext;
        }
        if (this.isCached ^ !row.isMemory() || n != this.indexList.length) {
            row = (Row)this.getNewCachedObject(session, row.getData(), true);
        }
        super.indexRow(session, row);
    }

    @Override
    public void delete(Session session, Row row) {
        NodeAVL nodeAVL = ((RowAVL)row).getNode(0);
        int n = 0;
        while (nodeAVL != null) {
            ++n;
            nodeAVL = nodeAVL.nNext;
        }
        if (this.isCached ^ !row.isMemory() || n != this.indexList.length) {
            row = ((Table)this.table).getDeleteRowFromLog(session, row.getData());
        }
        if (row != null) {
            super.delete(session, row);
        }
    }

    @Override
    public CachedObject getAccessor(Index index) {
        return super.getAccessor(index);
    }

    @Override
    public synchronized void resetAccessorKeys(Session session, Index[] indexArray) {
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = indexArray;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        if (this.isCached) {
            this.resetAccessorKeysForCached(indexArray);
            return;
        }
        super.resetAccessorKeys(session, indexArray);
    }

    private void resetAccessorKeysForCached(Index[] indexArray) {
        TableBase tableBase = this.table.duplicate();
        tableBase.persistenceId = this.table.persistenceId;
        tableBase.setIndexes(indexArray);
        RowStoreAVLHybridExtended rowStoreAVLHybridExtended = new RowStoreAVLHybridExtended(this.session, tableBase, true);
        rowStoreAVLHybridExtended.changeToDiskTable(this.session);
        RowIterator rowIterator = this.rowIterator();
        while (rowIterator.hasNext()) {
            Row row = rowIterator.getNextRow();
            Row row2 = (Row)((RowStoreAVLHybrid)rowStoreAVLHybridExtended).getNewCachedObject(this.session, row.getData(), false);
            ((RowStoreAVLHybrid)rowStoreAVLHybridExtended).indexRow(this.session, row2);
        }
        this.indexList = indexArray;
        this.accessorList = rowStoreAVLHybridExtended.accessorList;
    }
}

