/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.cdtvariables;

import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.cdtvariables.ICdtVariablesContributor;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.cdtvariables.CdtVariableManager;
import org.eclipse.cdt.internal.core.cdtvariables.CoreMacroSupplierBase;
import org.eclipse.cdt.internal.core.cdtvariables.DefaultVariableContextInfo;
import org.eclipse.cdt.utils.cdtvariables.ICdtVariableSupplier;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableManager;

public class BuildSystemVariableSupplier
extends CoreMacroSupplierBase {
    private static BuildSystemVariableSupplier fInstance;

    private BuildSystemVariableSupplier() {
    }

    public static BuildSystemVariableSupplier getInstance() {
        if (fInstance == null) {
            fInstance = new BuildSystemVariableSupplier();
        }
        return fInstance;
    }

    protected ICdtVariable getMacro(String name, int type, Object data) {
        ICConfigurationDescription des = (ICConfigurationDescription)data;
        ICdtVariablesContributor cr = des.getBuildVariablesContributor();
        if (cr != null) {
            return cr.getVariable(name, new ExtensionMacroProvider(type, data));
        }
        return null;
    }

    protected ICdtVariable[] getMacros(int type, Object data) {
        ICConfigurationDescription des = (ICConfigurationDescription)data;
        ICdtVariablesContributor cr = des.getBuildVariablesContributor();
        if (cr != null) {
            return cr.getVariables(new ExtensionMacroProvider(type, data));
        }
        return new ICdtVariable[0];
    }

    private class ExtensionMacroProvider
    extends CdtVariableManager {
        private IVariableContextInfo fStartInfo;
        private int fContextType;
        private Object fContextData;
        private boolean fStartInitialized;

        public ExtensionMacroProvider(int contextType, Object contextData) {
            this.fContextType = contextType;
            this.fContextData = contextData;
        }

        public IVariableContextInfo getMacroContextInfo(int contextType, Object contextData) {
            IVariableContextInfo startInfo = this.getStartInfo();
            if (contextType == this.fContextType && contextData == this.fContextData) {
                return startInfo;
            }
            IVariableContextInfo info = super.getMacroContextInfo(contextType, contextData);
            if (info == null) {
                return null;
            }
            if (SupplierBasedCdtVariableManager.checkParentContextRelation(startInfo, info)) {
                return info;
            }
            return null;
        }

        protected IVariableContextInfo getStartInfo() {
            if (this.fStartInfo == null && !this.fStartInitialized) {
                IVariableContextInfo info = super.getMacroContextInfo(this.fContextType, this.fContextData);
                if (info != null) {
                    ICdtVariableSupplier[] suppliers = info.getSuppliers();
                    this.fStartInfo = (suppliers = this.filterValidSuppliers(suppliers)) != null ? new DefaultVariableContextInfo(this.fContextType, this.fContextData, suppliers) : info.getNext();
                    this.fStartInitialized = true;
                }
                this.fStartInitialized = true;
            }
            return this.fStartInfo;
        }

        protected ICdtVariableSupplier[] filterValidSuppliers(ICdtVariableSupplier[] suppliers) {
            if (suppliers == null) {
                return null;
            }
            int i = 0;
            int j = 0;
            i = 0;
            while (i < suppliers.length) {
                if (suppliers[i] == this) break;
                ++i;
            }
            if (i >= suppliers.length) {
                return null;
            }
            int startNum = i + 1;
            ICdtVariableSupplier[] validSuppliers = new ICdtVariableSupplier[suppliers.length - startNum];
            i = startNum;
            j = 0;
            while (i < suppliers.length) {
                validSuppliers[j] = suppliers[i];
                ++i;
                ++j;
            }
            return validSuppliers;
        }
    }
}

