/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ILanguageDescriptor;
import org.eclipse.cdt.internal.core.CExtensionDescriptor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class LanguageDescriptor
extends CExtensionDescriptor
implements ILanguageDescriptor {
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ELEMENT_CONTENT_TYPE = "contentType";
    private static final String NAMESPACE_SEPARATOR = ".";
    private ILanguage fLanguage;
    private String[] fContentTypeIds;
    private String fId;
    private IContentType[] fContentTypes;

    public LanguageDescriptor(IConfigurationElement el) {
        super(el);
    }

    public ILanguage getLanguage() {
        if (this.fLanguage == null) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    CCorePlugin.log(exception);
                }

                public void run() throws Exception {
                    LanguageDescriptor.this.fLanguage = (ILanguage)LanguageDescriptor.this.getConfigurationElement().createExecutableExtension(LanguageDescriptor.ATTRIBUTE_CLASS);
                }
            });
        }
        return this.fLanguage;
    }

    public String[] getContentTypeIds() {
        if (this.fContentTypeIds == null) {
            this.fContentTypeIds = this.calculateCintentTypeIds();
        }
        return this.fContentTypeIds;
    }

    private String[] calculateCintentTypeIds() {
        IConfigurationElement el = this.getConfigurationElement();
        IConfigurationElement[] children = el.getChildren();
        String[] ids = new String[children.length];
        int num = 0;
        if (children.length > 0) {
            int i = 0;
            while (i < children.length) {
                String tmp;
                if (ELEMENT_CONTENT_TYPE.equals(children[i].getName()) && (tmp = children[i].getAttribute("id")) != null) {
                    ids[num++] = tmp;
                }
                ++i;
            }
            if (num < children.length) {
                String[] t = new String[num];
                System.arraycopy(ids, 0, t, 0, num);
                ids = t;
            }
        }
        return ids;
    }

    public String getId() {
        if (this.fId == null) {
            this.fId = String.valueOf(this.getConfigurationElement().getNamespaceIdentifier()) + NAMESPACE_SEPARATOR + super.getId();
        }
        return this.fId;
    }

    public IContentType[] getContentTypes() {
        if (this.fContentTypes == null) {
            this.fContentTypes = this.calculateContentTypes(this.getContentTypeIds());
        }
        return this.fContentTypes;
    }

    private IContentType[] calculateContentTypes(String[] ids) {
        IContentType[] cTypes = new IContentType[ids.length];
        if (ids.length > 0) {
            int num = 0;
            IContentTypeManager manager = Platform.getContentTypeManager();
            int k = 0;
            while (k < ids.length) {
                IContentType langContType = manager.getContentType(ids[k]);
                if (langContType != null) {
                    cTypes[num++] = langContType;
                }
                ++k;
            }
            if (num < ids.length) {
                IContentType[] tmp = new IContentType[num];
                System.arraycopy(cTypes, 0, tmp, 0, num);
                cTypes = tmp;
            }
        }
        return cTypes;
    }
}

