/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.popupMenu;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonAttribute;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class DAPopupMenuItemButtonRenderer
extends DACustomButtonRenderer {
    protected static final int MARGIN = 2;
    protected static final int TEXT_MARGIN = 5;
    protected static final int DEFAULT_ITEM_HEIGHT = 24;
    protected static final int DEFAULT_ICON_SIZE = 16;
    protected static final int DEFAULT_FONT_SIZE = 9;
    protected static final int ICON_MARGIN = 3;

    @Override
    public void draw(GC gc, Canvas canvas, int state, DACustomButtonAttribute attr) {
        Rectangle rect = canvas.getClientArea();
        this.drawButton(gc, rect, state, attr);
        this.drawIcon(gc, rect, state, attr);
        this.drawButtonImage(gc, rect, attr, state);
    }

    @Override
    protected void drawButton(GC gc, Rectangle rect, int state, DACustomButtonAttribute attr) {
        gc.setBackground(attr.getColor(state));
        gc.fillRectangle(rect);
        Rectangle r = new Rectangle(0, 0, rect.width - 1, rect.height - 1);
        this.drawButtonText(gc, r, attr, state);
    }

    @Override
    protected void drawButtonText(GC gc, Rectangle rect, DACustomButtonAttribute attr, int state) {
        String text = null;
        Font font = null;
        Point p = null;
        Rectangle textRect = new Rectangle(rect.x + 3 + 16, rect.y, rect.width, rect.height);
        text = attr.getText();
        if (text != null) {
            font = attr.getFont();
            if (font == null) {
                font = new Font((Device)Display.getCurrent(), "Arial", this.computeFontSize(textRect), 0);
                attr.setFont(font);
            }
            gc.setFont(font);
            int x = 0;
            int y = 0;
            int offset = 6;
            p = gc.textExtent(text, 8);
            x = textRect.x;
            y = textRect.height / 2 - p.y / 2;
            if (attr.getFontColor(state) != null) {
                gc.setForeground(attr.getFontColor(state));
            } else {
                gc.setForeground(ColorResources.BLACK);
            }
            if (state == 1) {
                ++x;
                ++y;
            }
            gc.drawString(text, x + offset, y, true);
        } else {
            Color old = gc.getForeground();
            gc.setForeground(ColorResources.POPUP_MENU_SEPARATOR2);
            gc.drawLine(0, rect.height, rect.width, rect.height);
            gc.setForeground(old);
        }
    }

    protected void drawIcon(GC gc, Rectangle parentRect, int state, DACustomButtonAttribute attr) {
        Image icon = attr.getIcon();
        if (icon == null) {
            return;
        }
        Rectangle iconBounds = icon.getBounds();
        if (state == 3) {
            int old = gc.getAlpha();
            gc.setAlpha(70);
            gc.drawImage(icon, 0, 0, iconBounds.width, iconBounds.height, parentRect.x + 2, parentRect.height / 2 - 8, 16, 16);
            gc.setAlpha(old);
        } else {
            gc.drawImage(icon, 0, 0, iconBounds.width, iconBounds.height, parentRect.x + 2, parentRect.height / 2 - 8, 16, 16);
        }
    }

    @Override
    protected void drawButtonImage(GC gc, Rectangle rect, DACustomButtonAttribute attr, int state) {
        Image img;
        if (attr != null && (img = attr.getButtonImage(state)) != null) {
            Rectangle imgBounds = img.getBounds();
            gc.drawImage(img, rect.width - imgBounds.width - 2, rect.height / 2 - imgBounds.height / 2);
        }
    }

    @Override
    public int computeFontSize(Rectangle rect) {
        return 9;
    }
}

