/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TreeInput;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.ui.memory.data.MemoryDataManager;
import org.tizen.dynamicanalyzer.ui.memory.data.ProcessMemoryDBTable;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATreeComposite;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;

public class MemoryDetailsTable
extends DATreeComposite {
    private int keyindex = 0;
    private Long StartTime = 0L;
    private Long EndTime = 0L;
    private Long Current = -1L;

    public MemoryDetailsTable(Composite parent, int style, int tableStyle) {
        super(parent, style, tableStyle);
        this.setTableName(MemoryPageLabels.MEMORY_DETAILS_VIEW_TITLE);
        this.setTree(true);
        this.setSortTypes(new int[8]);
        this.setColumnAlignment(new int[]{16384, 131072, 131072, 131072, 131072, 131072, 131072, 131072});
        this.setColumns(new String[]{MemoryPageLabels.MEMORY_DETAILS_VIEW_ITEM, MemoryPageLabels.MEMORY_DETAILS_VIEW_CURRENT, MemoryPageLabels.MEMORY_DETAILS_VIEW_START, MemoryPageLabels.MEMORY_DETAILS_VIEW_END, MemoryPageLabels.MEMORY_DETAILS_VIEW_DELTA, MemoryPageLabels.MEMORY_DETAILS_VIEW_MIN, MemoryPageLabels.MEMORY_DETAILS_VIEW_MAX, ""});
        int[] columnSizes = new int[]{210, 80, 85, 85, 85, 85, 85, 15};
        this.setColumnSize(columnSizes);
        this.setColumnVisibility(new boolean[]{true, true, true, true, true, true, true, true});
        this.setTableToolTipEnable(false);
    }

    public void setSelectionRange(Long start, Long end, Long current) {
        this.StartTime = start;
        this.EndTime = end;
        this.Current = current;
    }

    @Override
    public List<TreeInput> makeTreeInput() {
        int i;
        ArrayList<TreeInput> output = new ArrayList<TreeInput>();
        if (Global.getProject() == null) {
            return output;
        }
        TreeInput systemMemdata = this.makeSystemMemory();
        if (systemMemdata != null) {
            output.add(systemMemdata);
        }
        ArrayList<Integer> pidlist = new ArrayList<Integer>();
        this.keyindex = 0;
        int[] pids = Global.getProject().getProcessIDs();
        int targetPID = Toolbar.INSTANCE.getSelectedPid();
        if (targetPID > 0) {
            pidlist.add(targetPID);
        } else {
            i = 0;
            while (i < pids.length) {
                pidlist.add(pids[i]);
                ++i;
            }
        }
        i = 0;
        while (i < pidlist.size()) {
            try {
                TreeInput processMemdata = this.makeprocessMemory((Integer)pidlist.get(i));
                if (processMemdata != null) {
                    output.add(processMemdata);
                }
            }
            catch (Exception exception) {
                Logger.error((Object)"Process memory is invaild.");
            }
            try {
                TreeInput heapdata = this.makeHeapData((Integer)pidlist.get(i));
                if (heapdata != null) {
                    output.add(heapdata);
                }
            }
            catch (Exception exception) {
                Logger.error((Object)"Heap memory is invaild.");
            }
            ++i;
        }
        return output;
    }

    private TreeInput makeSystemMemory() {
        List<Long> memorylist = MemoryDataManager.getInstance().getSystemMemoryMinMaxFromDB(this.StartTime, this.EndTime);
        Long currentmemory = 0L;
        String parentString = "System Memory (Used)";
        if (memorylist.size() == 0 || !SettingDataManager.INSTANCE.isFlatFeatureSelected(FlatFeature.SYSTEM_MEMORY)) {
            return null;
        }
        if (this.Current != -1L) {
            currentmemory = MemoryDataManager.getInstance().getSystemMemoriesFromDB(this.Current);
        }
        List<Long> sorteddata = this.SortMemoryData(memorylist);
        DATableDataFormat tableData = new DATableDataFormat(this.keyindex++);
        tableData.setObject(parentString);
        TreeInput output = new TreeInput();
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Object> data = new ArrayList<Object>();
        text.add(parentString);
        data.add(parentString);
        text.add(Formatter.toByteFormat(currentmemory));
        data.add(currentmemory);
        int i = 1;
        while (i < sorteddata.size()) {
            text.add(Formatter.toByteFormat(sorteddata.get(i)));
            data.add(sorteddata.get(i));
            ++i;
        }
        output.setText(text);
        tableData.getData().addAll(data);
        output.setData(tableData);
        output.setParent(parentString);
        return output;
    }

    private TreeInput makeprocessMemory(int targetID) {
        if (Global.getProject().getMempsAvailable()) {
            return this.NewMemoryData(targetID);
        }
        return this.OldMemoryData(targetID);
    }

    private TreeInput NewMemoryData(int targetID) {
        DATableDataFormat tableData = new DATableDataFormat(this.keyindex++);
        String parentString = String.format("Process #%s (Total)", targetID);
        tableData.setObject(parentString);
        TreeInput output = new TreeInput();
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Number> data = new ArrayList<Number>();
        String tablename = ProcessMemoryDBTable.getTablename();
        String timeString = ProcessMemoryDBTable.COLUMN.SAMPLING_TIME.name;
        String columnNamePSS = ProcessMemoryDBTable.COLUMN.MEMORY_PSS.name;
        String columnNameTHREED = ProcessMemoryDBTable.COLUMN.MEMORY_THREED.name;
        String columnNameGEM = ProcessMemoryDBTable.COLUMN.MEMORY_GEM.name;
        List<Long> processPSS = MemoryDataManager.getInstance().getColumnLongFromDB(tablename, columnNamePSS, timeString, targetID, this.StartTime, this.EndTime);
        if (processPSS.size() == 0) {
            return null;
        }
        List<Long> processTHREED = MemoryDataManager.getInstance().getColumnLongFromDB(tablename, columnNameTHREED, timeString, targetID, this.StartTime, this.EndTime);
        List<Long> processGEM = MemoryDataManager.getInstance().getColumnLongFromDB(tablename, columnNameGEM, timeString, targetID, this.StartTime, this.EndTime);
        List<Long> sorteddataPSS = this.SortMemoryData(processPSS);
        List<Long> sorteddataThreeD = this.SortMemoryData(processTHREED);
        List<Long> sorteddataGem = this.SortMemoryData(processGEM);
        long currentPSS = 0L;
        long currentThreed = 0L;
        long currentGem = 0L;
        if (this.Current != -1L) {
            currentPSS = MemoryDataManager.getInstance().getCurrentColumnLongFromDB(tablename, columnNamePSS, timeString, targetID, this.Current);
            currentThreed = MemoryDataManager.getInstance().getCurrentColumnLongFromDB(tablename, columnNameTHREED, timeString, targetID, this.Current);
            currentGem = MemoryDataManager.getInstance().getCurrentColumnLongFromDB(tablename, columnNameGEM, timeString, targetID, this.Current);
            sorteddataPSS.set(0, currentPSS);
            sorteddataThreeD.set(0, currentThreed);
            sorteddataGem.set(0, currentGem);
        }
        text.add(parentString);
        data.add(targetID);
        int i = 0;
        while (i < sorteddataPSS.size()) {
            long total = sorteddataPSS.get(i) + sorteddataThreeD.get(i) + sorteddataGem.get(i);
            text.add(Formatter.toByteFormat(total));
            data.add(total);
            ++i;
        }
        output.setText(text);
        tableData.getData().addAll(data);
        output.setData(tableData);
        output.setParent(parentString);
        HashMap<String, List<Long>> childrenDataMap = new HashMap<String, List<Long>>();
        childrenDataMap.put(TimelineChartLabels.PROCESS_MEMORY_CHART_PSS, sorteddataPSS);
        childrenDataMap.put(TimelineChartLabels.PROCESS_MEMORY_CHART_THREED, sorteddataThreeD);
        childrenDataMap.put(TimelineChartLabels.PROCESS_MEMORY_CHART_GEM, sorteddataGem);
        for (Map.Entry entry : childrenDataMap.entrySet()) {
            this.makeChildTree((List)entry.getValue(), output, (String)entry.getKey(), parentString);
        }
        return output;
    }

    private TreeInput OldMemoryData(int targetID) {
        DATableDataFormat tableData = new DATableDataFormat(this.keyindex++);
        String parentString = String.format("PSS (PID #%d)", targetID);
        tableData.setObject(parentString);
        TreeInput output = new TreeInput();
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Number> data = new ArrayList<Number>();
        String tablename = ProcessMemoryDBTable.getTablename();
        String timeString = ProcessMemoryDBTable.COLUMN.SAMPLING_TIME.name;
        String columnNamePSS = ProcessMemoryDBTable.COLUMN.MEMORY_PSS.name;
        String columnNameRSS = ProcessMemoryDBTable.COLUMN.MEMORY_RESIDENT.name;
        String columnNameVSS = ProcessMemoryDBTable.COLUMN.MEMORY_VIRTUAL.name;
        List<Long> processPSS = MemoryDataManager.getInstance().getColumnLongFromDB(tablename, columnNamePSS, timeString, targetID, this.StartTime, this.EndTime);
        if (processPSS.size() == 0) {
            return null;
        }
        List<Long> sorteddataPSS = this.SortMemoryData(processPSS);
        long currentPSS = 0L;
        if (this.Current != -1L) {
            currentPSS = MemoryDataManager.getInstance().getCurrentColumnLongFromDB(tablename, columnNamePSS, timeString, targetID, this.Current);
            sorteddataPSS.set(0, currentPSS);
        }
        text.add(parentString);
        data.add(targetID);
        int i = 0;
        while (i < sorteddataPSS.size()) {
            text.add(Formatter.toByteFormat(sorteddataPSS.get(i)));
            data.add(sorteddataPSS.get(i));
            ++i;
        }
        output.setText(text);
        tableData.getData().addAll(data);
        output.setData(tableData);
        output.setParent(parentString);
        List<Long> processRSS = MemoryDataManager.getInstance().getColumnLongFromDB(tablename, columnNameRSS, timeString, targetID, this.StartTime, this.EndTime);
        List<Long> processVSS = MemoryDataManager.getInstance().getColumnLongFromDB(tablename, columnNameVSS, timeString, targetID, this.StartTime, this.EndTime);
        List<Long> sorteddataRSS = this.SortMemoryData(processRSS);
        List<Long> sorteddataVSS = this.SortMemoryData(processVSS);
        long currentRSS = 0L;
        long currentVSS = 0L;
        if (this.Current != -1L) {
            currentRSS = MemoryDataManager.getInstance().getCurrentColumnLongFromDB(tablename, columnNameRSS, timeString, targetID, this.Current);
            currentVSS = MemoryDataManager.getInstance().getCurrentColumnLongFromDB(tablename, columnNameVSS, timeString, targetID, this.Current);
            sorteddataRSS.set(0, currentRSS);
            sorteddataVSS.set(0, currentVSS);
        }
        HashMap<String, List<Long>> childrenDataMap = new HashMap<String, List<Long>>();
        childrenDataMap.put(TimelineChartLabels.PROCESS_MEMORY_CHART_RSS, sorteddataRSS);
        childrenDataMap.put(TimelineChartLabels.PROCESS_MEMORY_CHART_VSS, sorteddataVSS);
        for (Map.Entry entry : childrenDataMap.entrySet()) {
            this.makeChildTree((List)entry.getValue(), output, (String)entry.getKey(), parentString);
        }
        return output;
    }

    private TreeInput makeHeapData(int targetID) {
        String parentString = "Heap (Total)";
        DATableDataFormat tableData = new DATableDataFormat(this.keyindex++);
        tableData.setObject(parentString);
        TreeInput output = new TreeInput();
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Number> data = new ArrayList<Number>();
        List<List<Object>> processDataList = MemoryDataManager.getInstance().getTargetProcessDataFromDB(this.StartTime, this.EndTime, targetID);
        if (processDataList.size() == 0) {
            return null;
        }
        Map<String, List<Long>> sortedheapdata = this.sortHeapData(processDataList, this.Current);
        for (Map.Entry<String, List<Long>> entry : sortedheapdata.entrySet()) {
            if (entry.getKey() == "AllHeapSize") {
                List<Long> parentsdata = entry.getValue();
                text.add(parentString);
                data.add(targetID);
                int i = 0;
                while (i < parentsdata.size()) {
                    text.add(Formatter.toByteFormat(parentsdata.get(i)));
                    data.add(parentsdata.get(i));
                    ++i;
                }
                output.setText(text);
                tableData.getData().addAll(data);
                output.setData(tableData);
                output.setParent(parentString);
                continue;
            }
            this.makeChildTree(entry.getValue(), output, entry.getKey(), parentString);
        }
        return output;
    }

    private void makeChildTree(List<Long> childdata, TreeInput parent, String childName, String parentName) {
        DATableDataFormat tableData = new DATableDataFormat(this.keyindex++);
        tableData.setObject(childName);
        TreeInput output = new TreeInput();
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Object> data = new ArrayList<Object>();
        text.add(childName);
        data.add(childName);
        int i = 0;
        while (i < childdata.size()) {
            text.add(Formatter.toByteFormat(childdata.get(i)));
            data.add(childdata.get(i));
            ++i;
        }
        output.setText(text);
        tableData.getData().addAll(data);
        output.setData(tableData);
        parent.getChildren().add(output);
        output.setParent(parentName);
    }

    private List<Long> SortMemoryData(List<Long> memorylist) {
        ArrayList<Long> output = new ArrayList<Long>();
        Long start = memorylist.get(0);
        Long end = memorylist.get(memorylist.size() - 1);
        Long min = memorylist.get(0);
        Long max = memorylist.get(0);
        int i = 1;
        while (i < memorylist.size()) {
            if (min > memorylist.get(i)) {
                min = memorylist.get(i);
            } else if (max < memorylist.get(i)) {
                max = memorylist.get(i);
            }
            ++i;
        }
        output.add(0L);
        output.add(start);
        output.add(end);
        output.add(end - start);
        output.add(min);
        output.add(max);
        return output;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, List<Long>> sortHeapData(List<List<Object>> processDataList, long current) {
        void var8_8;
        HashMap<String, List<Long>> output = new HashMap<String, List<Long>>();
        HashMap heapdata = new HashMap();
        HashMap<Integer, Long> currentvalue = new HashMap<Integer, Long>();
        Project project = Global.getProject();
        boolean bl = false;
        while (var8_8 < processDataList.size()) {
            List<Object> processData = processDataList.get((int)var8_8);
            Object binaryIDList = MemoryDetailsTable.cast(processData.get(ProcessMemoryDBTable.COLUMN.HEAP_ALLOCATION_BINARY_ID.index));
            Object allocByteList = MemoryDetailsTable.cast(processData.get(ProcessMemoryDBTable.COLUMN.HEAP_ALLOCATION_BYTE.index));
            int i = 0;
            while (i < binaryIDList.size()) {
                Integer binaryID = (Integer)binaryIDList.get(i);
                Long allocByte = (Long)allocByteList.get(i);
                if (!heapdata.containsKey(binaryID)) {
                    heapdata.put(binaryID, new ArrayList());
                    ((List)heapdata.get(binaryID)).add(allocByte);
                    currentvalue.put(binaryID, 0L);
                    if (current != 0L && (Long)processData.get(0) <= current) {
                        currentvalue.put(binaryID, allocByte);
                    }
                } else {
                    ((List)heapdata.get(binaryID)).add(allocByte);
                    if (current != 0L && (Long)processData.get(0) <= current) {
                        currentvalue.put(binaryID, allocByte);
                    }
                }
                ++i;
            }
            ++var8_8;
        }
        for (Map.Entry entry : heapdata.entrySet()) {
            BinaryInfo binaryInfo;
            int binaryId = (Integer)entry.getKey();
            String libname = binaryId == -10 ? MemoryPageLabels.MEMORY_MAIN_EXCUTABLE : ((binaryInfo = project.getDeviceStatusInfo().getBinaryInfo(binaryId)) == null ? "Unknown" : binaryInfo.getTargetBinaryPath());
            output.put(libname, this.SortMemoryData((List)entry.getValue()));
            ((List)output.get(libname)).set(0, (Long)currentvalue.get(binaryId));
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        int i = 0;
        while (i < 6) {
            arrayList.add(0L);
            ++i;
        }
        for (Map.Entry entry : output.entrySet()) {
            int i2 = 0;
            while (i2 < ((List)entry.getValue()).size()) {
                Long sumsize = (Long)arrayList.get(i2) + (Long)((List)entry.getValue()).get(i2);
                arrayList.set(i2, sumsize);
                ++i2;
            }
        }
        output.put("AllHeapSize", arrayList);
        return output;
    }

    private static <T extends List<?>> T cast(Object obj) {
        return (T)((List)obj);
    }

    public void removeSelection() {
        this.table.removeAll();
        this.updateTable();
    }

    @Override
    public void clear() {
        this.table.removeAll();
        this.getSelectionIndex().clear();
        this.getSelections().clear();
        this.StartTime = 0L;
        this.EndTime = 0L;
        this.Current = -1L;
    }
}

