/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.symbols;

import java.util.Iterator;

public interface IRangeList
extends Iterable<Entry> {
    public long getLowAddress();

    public long getHighAddress();

    @Override
    public Iterator<Entry> iterator();

    public boolean isInRange(long var1);

    public static class Entry
    implements Comparable<Entry> {
        public final long low;
        public final long high;

        public Entry(long low, long high) {
            this.low = low;
            this.high = high;
        }

        public String toString() {
            return "[" + Long.toHexString(this.low) + "-" + Long.toHexString(this.high) + ")";
        }

        @Override
        public int compareTo(Entry o) {
            if (this.low < o.low) {
                return -1;
            }
            if (this.low > o.low && this.high >= o.high) {
                return 1;
            }
            if (this.low == o.low && this.high > o.high) {
                return 1;
            }
            return 0;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (int)(this.high ^ this.high >>> 32);
            result = 31 * result + (int)(this.low ^ this.low >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.high != other.high) {
                return false;
            }
            return this.low == other.low;
        }
    }
}

