/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.profiling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.SummaryLabels;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.ProfileData;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionSampleDBTable;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfileDataMaker;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingChildData;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingChildDataDBTable;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingData;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingDataDBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class FunctionUsageProfiler
extends PageDataManager {
    public static long SAMPLE_TIME = 10L;
    public static final String APPLICATION = SummaryLabels.FUNCTION_USAGE_PROFILER_APPLICATION;
    public static final String DEPENDENT_LIB = SummaryLabels.FUNCTION_USAGE_PROFILER_DEPENDENT_LIB;
    public static final String APPLICATION_KEY = "profiling_app_bin_key";
    public static final String DEPENDENT_LIB_KEY = "profiling_dependent_lib_key";
    public static final String UNKNOWN = "";
    private static FunctionUsageProfiler instance = new FunctionUsageProfiler();
    private boolean isSetSamplePeriod = false;
    private ProfilingDataDBTable profilingDataTable = null;
    private ProfilingChildDataDBTable profilingChildDataTable = null;
    private FunctionSampleDBTable functionSampleTable = null;
    private Map<Integer, ProfileDataMaker> profileDataMakerMap = new HashMap<Integer, ProfileDataMaker>();
    private long lastSampleSeq = -1L;
    private Object sampleSeqLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastSampleSeq(long seq) {
        Object object = this.sampleSeqLock;
        synchronized (object) {
            this.lastSampleSeq = seq;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastSampleSeq() {
        Object object = this.sampleSeqLock;
        synchronized (object) {
            return this.lastSampleSeq;
        }
    }

    private FunctionUsageProfiler() {
        this.profilingDataTable = new ProfilingDataDBTable();
        this.profilingChildDataTable = new ProfilingChildDataDBTable();
        this.functionSampleTable = new FunctionSampleDBTable();
    }

    public ProfilingDataDBTable getProfilingDataTable() {
        return this.profilingDataTable;
    }

    public ProfilingChildDataDBTable getProfilingChildDataTable() {
        return this.profilingChildDataTable;
    }

    public FunctionSampleDBTable getFunctionSampleTable() {
        return this.functionSampleTable;
    }

    public List<Integer> getPidsOfProfileDataMakerMap() {
        ArrayList<Integer> pids = new ArrayList<Integer>();
        pids.addAll(this.profileDataMakerMap.keySet());
        return pids;
    }

    public ProfileDataMaker getProfileDataMakerByPid(int pid) {
        ProfileDataMaker profileDataMaker = this.profileDataMakerMap.get(pid);
        if (profileDataMaker == null) {
            profileDataMaker = new ProfileDataMaker();
            profileDataMaker.setPid(pid);
            this.profileDataMakerMap.put(pid, profileDataMaker);
        }
        return profileDataMaker;
    }

    public static FunctionUsageProfiler getInstance() {
        return instance;
    }

    public void clear() {
        this.lastSampleSeq = -1L;
        this.isSetSamplePeriod = false;
        for (int pid : this.getPidsOfProfileDataMakerMap()) {
            ProfileDataMaker profiler = this.getProfileDataMakerByPid(pid);
            profiler.clear();
        }
        this.profileDataMakerMap.clear();
        ProfilingData.clear();
    }

    public void saveProfilingData() {
        List<Integer> pids = this.getPidsOfProfileDataMakerMap();
        int size = pids.size();
        int i = 0;
        while (i < size) {
            ProfileDataMaker profiler = this.getProfileDataMakerByPid(pids.get(i));
            Map<Integer, ProfilingData> profilingDataMap = profiler.getProfilingDataMap();
            ArrayList<ProfilingData> pDataList = new ArrayList<ProfilingData>();
            pDataList.addAll(profilingDataMap.values());
            ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
            int count = pDataList.size();
            int j = 0;
            while (j < count) {
                ArrayList<Number> insertRowData = new ArrayList<Number>();
                ProfilingData pData = (ProfilingData)pDataList.get(j);
                try {
                    insertRowData.add(new Integer(pData.getProfilingDataID()));
                    String key = pData.getKey();
                    int type = key.equals(APPLICATION_KEY) ? 0 : (key.equals(DEPENDENT_LIB_KEY) ? 1 : (pData.isParent() ? 3 : 2));
                    insertRowData.add(new Byte((byte)type));
                    if (pData.isParent()) {
                        insertRowData.add(new Integer(pData.getFunctionId()));
                        BinaryInfo binInfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(pData.getName());
                        insertRowData.add(new Integer(binInfo.getID()));
                    } else {
                        insertRowData.add(new Integer(pData.getFunctionId()));
                        insertRowData.add(new Integer(-1));
                    }
                    insertRowData.add(new Integer(pids.get(i)));
                    insertRowData.add(new Integer(pData.getSelfExCount()));
                    insertRowData.add(new Integer(pData.getInCount()));
                    insertRowData.add(new Integer(pData.getCallCount()));
                    insertRowData.add(new Long(pData.getElapsedTime()));
                    insertRowData.add(new Long(pData.getExclusiveElapsedTime()));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Logger.exception((Throwable)e);
                }
                insertData.add(insertRowData);
                ++j;
            }
            if (insertData.size() > 0) {
                this.profilingDataTable.insertData(insertData);
            }
            ++i;
        }
    }

    public void saveProfilingChildData() {
        List<Integer> pids = this.getPidsOfProfileDataMakerMap();
        int size = pids.size();
        int i = 0;
        while (i < size) {
            ProfileDataMaker profiler = this.getProfileDataMakerByPid(pids.get(i));
            Map<String, ProfilingChildData> profilingDataMap = profiler.getChildListMap();
            ArrayList<ProfilingChildData> pDataList = new ArrayList<ProfilingChildData>();
            pDataList.addAll(profilingDataMap.values());
            ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
            int count = pDataList.size();
            int j = 0;
            while (j < count) {
                ProfilingChildData data = (ProfilingChildData)pDataList.get(j);
                List<Integer> childList = data.getChildren();
                try {
                    ArrayList<Object> insertRowData = new ArrayList<Object>();
                    insertRowData.add(Integer.valueOf(data.getProfilingDataID()));
                    insertRowData.add(new Integer(data.getPid()));
                    insertRowData.add(childList);
                    insertData.add(insertRowData);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Logger.exception((Throwable)e);
                }
                ++j;
            }
            if (insertData.size() > 0) {
                this.profilingChildDataTable.insertData(insertData);
            }
            ++i;
        }
    }

    @Override
    protected void makeData(LogPackage pack) {
        Logs logs;
        if (!this.isSetSamplePeriod) {
            SAMPLE_TIME = SettingDataManager.INSTANCE.getPreferenceValue(FlatPreferences.FUNCTION_SAMPLING_RATE);
        }
        if (SAMPLE_TIME > 0L && (logs = pack.getLogs(4)) != null && logs.getRawLogs().size() != 0) {
            ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
            List<LogData> sample = logs.getLogs();
            int size = sample.size();
            int i = 0;
            while (i < size) {
                ArrayList<Number> insertRowData = new ArrayList<Number>();
                ProfileData sampleLog = (ProfileData)sample.get(i);
                FunctionUsageProfiler.getInstance().getProfileDataMakerByPid(sample.get(i).getPid()).prepareFunctionUsageProfileData(sampleLog);
                try {
                    insertRowData.add(new Long(sampleLog.getSeq()));
                    insertRowData.add(new Long(sampleLog.getTime()));
                    insertRowData.add(new Integer(sampleLog.getPid()));
                    insertRowData.add(new Integer(sampleLog.getTid()));
                    insertRowData.add(new Long(sampleLog.getPcAddr()));
                    Integer cpuNum = new Integer(sampleLog.getCpuNum());
                    insertRowData.add(new Byte(cpuNum.byteValue()));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Logger.exception((Throwable)e);
                }
                insertData.add(insertRowData);
                ++i;
            }
            if (insertData.size() > 0) {
                this.functionSampleTable.insertData(insertData);
            }
        }
    }

    public void doSaveProfilingData() {
        this.saveProfilingData();
        this.saveProfilingChildData();
    }
}

