/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.uievent;

import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.nebula.widgets.grid.internal.DefaultCellRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;

public class UIEventListDialogTableCellRenderer
extends DefaultCellRenderer {
    private int leftMargin = 4;
    private int rightMargin = 4;
    private int textTopMargin = 1;
    private int insideMargin = 3;

    public void paint(GC gc, Object value) {
        int len;
        GridItem item = (GridItem)value;
        gc.setFont(item.getFont(this.getColumn()));
        boolean drawAsSelected = this.isSelected();
        boolean drawBackground = true;
        if (this.isCellSelected()) {
            drawAsSelected = true;
        }
        if (drawAsSelected) {
            gc.setForeground(ColorResources.TABLE_CONTENTS_SELECTED_START);
            gc.setBackground(ColorResources.TABLE_CONTENTS_SELECTED_START);
        } else if (item.getParent().isEnabled()) {
            Color bg = item.getBackground();
            if (bg != null) {
                gc.setBackground(bg);
            } else {
                drawBackground = false;
            }
        } else {
            gc.setBackground(this.getDisplay().getSystemColor(22));
        }
        if (drawBackground && drawAsSelected) {
            gc.fillGradientRectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height, true);
        } else if (drawBackground) {
            gc.fillRectangle(this.getBounds().x, this.getBounds().y + 1, this.getBounds().width, this.getBounds().height);
        }
        int x = this.leftMargin;
        Image image = item.getImage(this.getColumn());
        if (image != null) {
            Rectangle bounds = this.getBounds();
            Rectangle imageBounds = image.getBounds();
            int y = bounds.y;
            gc.drawImage(image, bounds.x + x, y += (bounds.height - imageBounds.height) / 2);
            x += imageBounds.width + this.insideMargin;
        }
        int width = this.getBounds().width - x - this.rightMargin;
        String text = item.getText(this.getColumn());
        if (this.getAlignment() == 131072) {
            len = gc.stringExtent((String)text).x;
            if (len < width) {
                x += width - len;
            }
        } else if (this.getAlignment() == 0x1000000 && (len = gc.stringExtent((String)text).x) < width) {
            x += (width - len) / 2;
        }
        if (drawAsSelected) {
            gc.setForeground(ColorResources.TABLE_CONTENTS_SELECTED_FONT_COLOR);
        } else {
            Color fontColor = item.getForeground();
            if (fontColor != null) {
                gc.setForeground(fontColor);
            } else {
                gc.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
            }
        }
        gc.setFont(FontResources.TABLE_CELL_FONT);
        gc.drawText(text, this.getBounds().x + x, this.getBounds().y + this.textTopMargin, true);
        if (item.getParent().getLinesVisible()) {
            gc.setForeground(ColorResources.TABLE_LINE);
            gc.drawLine(this.getBounds().x, this.getBounds().y + this.getBounds().height, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height);
            gc.drawLine(this.getBounds().x + this.getBounds().width - 1, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height);
        }
        if (this.isCellFocus()) {
            Rectangle focusRect = new Rectangle(this.getBounds().x - 1, this.getBounds().y - 1, this.getBounds().width, this.getBounds().height + 1);
            gc.setForeground(ColorResources.RED);
            gc.drawRectangle(focusRect);
            if (this.isFocus()) {
                ++focusRect.x;
                focusRect.width -= 2;
                ++focusRect.y;
                focusRect.height -= 2;
                gc.drawRectangle(focusRect);
            }
        }
    }
}

