/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.screenshot;

import java.io.IOException;
import org.tizen.dynamicanalyzer.ui.info.screenshot.SocketClient;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ecs.Ecs;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ecs.EcsIds;
import org.tizen.dynamicanalyzer.util.Logger;

public class MessageSender {
    private static MessageSender m_inst;

    public static MessageSender getInstance() {
        if (m_inst == null) {
            m_inst = new MessageSender();
        }
        return m_inst;
    }

    private boolean sendMaster(Ecs.Master master) {
        int serialize_size = master.getSerializedSize();
        try {
            SocketClient.getInstance().getOutputStream().writeInt(serialize_size);
            master.writeTo(SocketClient.getInstance().getOutputStream());
            SocketClient.getInstance().getOutputStream().flush();
        }
        catch (IOException e) {
            Logger.warning((Object)e.getMessage());
            return false;
        }
        return true;
    }

    public boolean sendMonitorReq(String data) {
        Ecs.Master.Builder masterBuilder = Ecs.Master.newBuilder();
        masterBuilder.setType(EcsIds.Master_Type.MONITOR_REQ);
        Ecs.MonitorReq.Builder monitorBuilder = Ecs.MonitorReq.newBuilder();
        monitorBuilder.setCommand(data);
        masterBuilder.setMonitorReq(monitorBuilder);
        Ecs.Master master = masterBuilder.build();
        return this.sendMaster(master);
    }

    public void sendKeepAliveAns() {
        Ecs.Master.Builder masterBuilder = Ecs.Master.newBuilder();
        masterBuilder.setType(EcsIds.Master_Type.KEEPALIVE_ANS);
        Ecs.KeepAliveAns.Builder kaBuilder = Ecs.KeepAliveAns.newBuilder();
        kaBuilder.setTimeStr("self");
        masterBuilder.setKeepaliveAns(kaBuilder);
        Ecs.Master master = masterBuilder.build();
        this.sendMaster(master);
    }
}

