/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.popupMenu;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuListener;

public class DAPopupMenuItem {
    public static final int NONE = 0;
    public static final int SEPARATOR = 1;
    public static final int CASCADE = 2;
    private DAPopupMenu parent;
    private DAPopupMenu child;
    private DACustomButton control;
    private String text;
    private int type;
    private Image icon;
    private boolean enabled = true;
    private List<DAPopupMenuListener> listeners;
    private double doubleData;

    public DAPopupMenuItem(DAPopupMenu menu, int type) {
        this.setParent(menu);
        this.setType(type);
        if (menu != null) {
            menu.addChild(this);
        }
    }

    public DAPopupMenuItem(DAPopupMenu menu) {
        this(menu, 0);
    }

    public DAPopupMenu getParent() {
        return this.parent;
    }

    public void setParent(DAPopupMenu parent) {
        this.parent = parent;
    }

    public DAPopupMenu getChild() {
        return this.child;
    }

    public void setChild(DAPopupMenu child) {
        this.child = child;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String name) {
        this.text = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    protected void setControl(DACustomButton control) {
        this.control = control;
    }

    protected DACustomButton getControl() {
        return this.control;
    }

    protected DAPopupMenu open() {
        if (this.child == null) {
            return null;
        }
        if (this.control == null) {
            return null;
        }
        this.parent.setChildMenu(this.child);
        Rectangle parentRt = this.control.getParent().getBounds();
        Rectangle rt = this.control.getBounds();
        this.child.open(null, parentRt.x + parentRt.width + rt.x, parentRt.y + rt.y);
        return this.child;
    }

    protected void closeParent() {
        if (this.parent != null) {
            this.parent.closeParent();
        }
    }

    protected boolean isInCursorInMenu(Point pt) {
        if (this.parent != null) {
            return this.parent.isInCursorOnMenu(pt);
        }
        return false;
    }

    protected void closeParentsChildMenu() {
        if (this.parent == null) {
            return;
        }
        DAPopupMenu child = this.parent.getChildMenu();
        if (child == null) {
            return;
        }
        child.closeChild();
        this.parent.setChildMenu(null);
    }

    public void addListener(DAPopupMenuListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<DAPopupMenuListener>();
        }
        this.listeners.add(listener);
    }

    public List<DAPopupMenuListener> getListeners() {
        return this.listeners;
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setIcon(Image icon) {
        this.icon = icon;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public double getDoubleData() {
        return this.doubleData;
    }

    public void setDoubleData(double data) {
        this.doubleData = data;
    }
}

