/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.dwarf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.cdt.debug.edc.symbols.IRangeList;

public class RangeList
implements IRangeList {
    private List<Long> ranges = new ArrayList<Long>();
    private long low = Long.MAX_VALUE;
    private long high = Long.MIN_VALUE;

    public String toString() {
        return "[0x" + Long.toHexString(this.getLowAddress()) + " to 0x" + Long.toHexString(this.getHighAddress()) + ")";
    }

    public void addRange(long start, long end) {
        if (!this.ranges.isEmpty() && this.ranges.get(this.ranges.size() - 1) == start) {
            this.ranges.set(this.ranges.size() - 1, end);
            if (end > this.high) {
                this.high = end;
            }
            return;
        }
        this.ranges.add(start);
        this.ranges.add(end);
        if (start < this.low) {
            this.low = start;
        }
        if (end > this.high) {
            this.high = end;
        }
    }

    @Override
    public long getLowAddress() {
        if (this.ranges.isEmpty()) {
            return 0L;
        }
        return this.low;
    }

    @Override
    public long getHighAddress() {
        if (this.ranges.isEmpty()) {
            return 0L;
        }
        return this.high;
    }

    @Override
    public Iterator<IRangeList.Entry> iterator() {
        return new Iterator<IRangeList.Entry>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < RangeList.this.ranges.size();
            }

            @Override
            public IRangeList.Entry next() {
                if (this.index >= RangeList.this.ranges.size()) {
                    throw new NoSuchElementException();
                }
                this.index += 2;
                return new IRangeList.Entry((Long)RangeList.this.ranges.get(this.index - 2), (Long)RangeList.this.ranges.get(this.index - 1));
            }

            @Override
            public void remove() {
            }
        };
    }

    public void addLowRange(long addr) {
        if (this.low > addr) {
            this.low = addr;
            if (!this.ranges.isEmpty()) {
                this.ranges.set(0, this.low);
            }
        }
    }

    public void addHighRange(long addr) {
        if (this.high < addr) {
            this.high = addr;
            if (!this.ranges.isEmpty()) {
                this.ranges.set(this.ranges.size() - 1, addr);
            }
        }
    }

    @Override
    public boolean isInRange(long addr) {
        for (IRangeList.Entry entry : this) {
            if (entry.low < addr || addr >= entry.high) continue;
            return true;
        }
        return false;
    }
}

