/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.ui.memory.table.MemoryStatisticsTable;
import org.tizen.dynamicanalyzer.widgets.timeline.MarkerManager;

public class ExpandableMemoryRangeComposite
extends ExpandableComposite {
    private int rangeIdx = 0;
    private static final int expandableStyle = 16386;
    private static final int TOP_MARGIN_HEIGHT = 5;
    private MemoryStatisticsTable memoryTable;

    public ExpandableMemoryRangeComposite(Composite parent, int style) {
        super(parent, style, 16386);
        this.setForeground(ColorResources.TABLE_HEADER_FONT_COLOR);
        this.setFont(FontResources.TABLE_HEADER_FONT);
        this.memoryTable = new MemoryStatisticsTable((Composite)this, 0, 67842);
        this.memoryTable.setDefaultExpansionState(false);
        this.marginHeight = 5;
        this.setClient((Control)this.memoryTable);
        this.setLayout((Layout)new FillLayout(512));
    }

    private void updateText() {
        String leftBorder = this.rangeIdx == 0 ? "Start" : "M" + (this.rangeIdx - 1);
        String rightBorder = this.rangeIdx == MarkerManager.INSTANCE.getMarkerCount() ? "End" : "M" + this.rangeIdx;
        String text = String.format("Range [%s - %s]", leftBorder, rightBorder);
        this.memoryTable.setTableName(text);
        this.setText(text);
    }

    public MemoryStatisticsTable getMemoryTable() {
        return this.memoryTable;
    }

    public void setIndex(int idx) {
        this.rangeIdx = idx;
        this.updateText();
    }

    public void updateRange() {
        this.updateText();
        this.updateTable();
    }

    private void updateTable() {
        this.memoryTable.updateTable();
    }
}

