/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.data.util;

import org.tizen.dynamicanalyzer.ui.memory.data.MemAllocDBTable;
import org.tizen.dynamicanalyzer.ui.memory.data.MemFreeDBTable;
import org.tizen.dynamicanalyzer.ui.memory.data.util.Query;
import org.tizen.dynamicanalyzer.ui.memory.data.util.QuerySerializer;

public class StatisticsQuerySerializer
implements QuerySerializer {
    @Override
    public String toSqlString(Query q) {
        StringBuilder queryFormat = new StringBuilder();
        queryFormat.append(String.format("SELECT %1$s, %2$s, CAST (COUNT(*) AS BIGINT), CAST (COUNT(%3$s) AS BIGINT), CAST (COUNT(CASE WHEN %3$s IS NULL THEN 1 ELSE NULL END) AS BIGINT), CAST (SUM(%4$s) AS BIGINT), CAST (SUM(CASE WHEN %3$s IS NULL THEN %4$s ELSE 0 END) AS BIGINT) ", new Object[]{MemAllocDBTable.COLUMN.PID.name, MemAllocDBTable.COLUMN.CALLER_LIBRARY_ID.name, MemFreeDBTable.COLUMN.FREE_TIME.name, MemAllocDBTable.COLUMN.ALLOCATED_MEMORY_SIZE}));
        queryFormat.append(String.format("FROM (SELECT DISTINCT %1$s, %2$s, %3$s, %4$s,(SELECT TOP 1 DISTINCT %9$s FROM %10$s as freeT WHERE allocT.%1$s = freeT.%6$s AND   allocT.%2$s = freeT.%7$s AND   allocT.%5$s = freeT.%8$s AND   allocT.%4$s <= freeT.%9$s", MemAllocDBTable.COLUMN.PID.name, MemAllocDBTable.COLUMN.CALLER_LIBRARY_ID.name, MemAllocDBTable.COLUMN.ALLOCATED_MEMORY_SIZE.name, MemAllocDBTable.COLUMN.ALLOCATED_TIME.name, MemAllocDBTable.COLUMN.ALLOCATED_ADDRESS.name, MemFreeDBTable.COLUMN.PID.name, MemFreeDBTable.COLUMN.CALLER_LIBRARY_ID.name, MemFreeDBTable.COLUMN.ALLOCATED_ADDRESS.name, MemFreeDBTable.COLUMN.FREE_TIME.name, "MEM_FREE_DB"));
        if (q.endTime > 0L) {
            queryFormat.append(String.format(" AND %s <= %s", new Object[]{MemFreeDBTable.COLUMN.FREE_TIME, q.endTime}));
        }
        queryFormat.append(String.format(" ORDER BY %1$s ASC) AS %1$s FROM %2$s as allocT ", new Object[]{MemFreeDBTable.COLUMN.FREE_TIME, "MEM_ALLOC_DB"}));
        queryFormat.append(String.format("WHERE %s in %s", MemAllocDBTable.COLUMN.PID.name, q.pidString));
        if (q.startTime > 0L || q.endTime > 0L) {
            queryFormat.append(String.format(" AND %s BETWEEN %s AND %s", new Object[]{MemAllocDBTable.COLUMN.ALLOCATED_TIME, q.startTime, q.endTime}));
        }
        queryFormat.append(String.format(") GROUP BY %s, %s", MemAllocDBTable.COLUMN.PID.name, MemAllocDBTable.COLUMN.CALLER_LIBRARY_ID.name));
        return queryFormat.toString();
    }
}

