/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar;

import java.util.ArrayList;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.ui.toolbar.RemoteDeviceDialog;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;

public class RemoteDeviceManager
implements Runnable {
    private static final String CMD_SDB_CONNECT = "connect";
    private static final String CMD_SDB_DEVICE = "devices";
    private static final String CONNECTED_STR1 = "connected";
    private static final String CONNECTED_STR2 = "already";
    private static final long SLEEPTIME = 50L;
    private static final long MAX_WAITTIME = 5000L;
    private RemoteDeviceDialog parentDialog = null;

    public RemoteDeviceManager(RemoteDeviceDialog dialog) {
        this.parentDialog = dialog;
    }

    @Override
    public void run() {
        boolean bret = false;
        String address = this.parentDialog.getAddress();
        if (address != null) {
            String[] cmdCnt = new String[]{PathManager.SDB_PATH, CMD_SDB_CONNECT, address};
            ArrayList outputlines = new ArrayList();
            if (CommonUtil.executeCommand((String[])cmdCnt, outputlines, null) && !outputlines.isEmpty()) {
                for (String line : outputlines) {
                    if (!line.startsWith(CONNECTED_STR1) && !line.contains(CONNECTED_STR2)) continue;
                    bret = true;
                    break;
                }
            }
            if (bret) {
                bret = false;
                String[] cmdDev = new String[]{PathManager.SDB_PATH, CMD_SDB_DEVICE};
                long starttime = System.currentTimeMillis();
                do {
                    outputlines.clear();
                    if (CommonUtil.executeCommand((String[])cmdDev, outputlines, null) && !outputlines.isEmpty()) {
                        for (String line : outputlines) {
                            if (!line.startsWith(address) || !line.contains("device")) continue;
                            bret = true;
                            break;
                        }
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        Logger.exception((Throwable)e);
                        break;
                    }
                } while (System.currentTimeMillis() < starttime + 5000L);
            }
        }
        final boolean fret = bret;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                RemoteDeviceManager.this.parentDialog.setConnectionResult(fret);
            }
        });
    }
}

