/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAmbiguousTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNameBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPASTTemplateId
extends CPPASTNameBase
implements ICPPASTTemplateId,
IASTAmbiguityParent {
    private IASTName templateName;
    private IASTNode[] templateArguments = null;

    public CPPASTTemplateId() {
    }

    public CPPASTTemplateId(IASTName templateName) {
        this.setTemplateName(templateName);
    }

    public CPPASTTemplateId copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CPPASTTemplateId copy(IASTNode.CopyStyle style) {
        CPPASTTemplateId copy = new CPPASTTemplateId(this.templateName == null ? null : this.templateName.copy(style));
        IASTNode[] iASTNodeArray = this.getTemplateArguments();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode arg = iASTNodeArray[n2];
            copy.internalAddTemplateArgument(arg == null ? null : arg.copy(style));
            ++n2;
        }
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public char[] getSimpleID() {
        return this.templateName.getSimpleID();
    }

    public char[] getLookupKey() {
        return this.templateName.getLookupKey();
    }

    public IASTName getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(IASTName name) {
        this.assertNotFrozen();
        assert (!(name instanceof ICPPASTQualifiedName) && !(name instanceof ICPPASTTemplateId));
        this.templateName = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(TEMPLATE_NAME);
        }
    }

    private void internalAddTemplateArgument(IASTNode node) {
        this.assertNotFrozen();
        this.templateArguments = (IASTNode[])ArrayUtil.append(IASTNode.class, this.templateArguments, node);
        if (node != null) {
            node.setParent(this);
            node.setPropertyInParent(TEMPLATE_ID_ARGUMENT);
        }
    }

    public void addTemplateArgument(IASTTypeId typeId) {
        this.internalAddTemplateArgument(typeId);
    }

    public void addTemplateArgument(IASTExpression expression) {
        this.internalAddTemplateArgument(expression);
    }

    public void addTemplateArgument(ICPPASTAmbiguousTemplateArgument ata) {
        this.internalAddTemplateArgument(ata);
    }

    public IASTNode[] getTemplateArguments() {
        if (this.templateArguments == null) {
            return ICPPASTTemplateId.EMPTY_ARG_ARRAY;
        }
        return (IASTNode[])ArrayUtil.trim(IASTNode.class, this.templateArguments);
    }

    protected IBinding createIntermediateBinding() {
        return CPPTemplates.createBinding(this);
    }

    public char[] toCharArray() {
        IASTNode[] args;
        assert (sAllowNameComputation);
        StringBuilder buf = new StringBuilder();
        buf.append(this.getTemplateName().toCharArray());
        buf.append('<');
        boolean needComma = false;
        boolean cleanupWhitespace = false;
        IASTNode[] iASTNodeArray = args = this.getTemplateArguments();
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode arg = iASTNodeArray[n2];
            if (needComma) {
                buf.append(", ");
            }
            needComma = true;
            if (arg instanceof IASTExpression) {
                IValue value = Value.create((IASTExpression)arg, 25);
                if (value != Value.UNKNOWN && !Value.isDependentValue(value)) {
                    buf.append(value.getSignature());
                } else {
                    buf.append(arg.getRawSignature());
                    cleanupWhitespace = true;
                }
            } else if (arg instanceof IASTTypeId) {
                IType type = CPPVisitor.createType((IASTTypeId)arg);
                if (type instanceof ISemanticProblem) {
                    buf.append(arg.getRawSignature());
                } else {
                    ASTTypeUtil.appendType(type, false, buf);
                }
            }
            if (cleanupWhitespace) {
                WHITESPACE_SEQ.matcher(buf).replaceAll(" ");
            }
            ++n2;
        }
        buf.append('>');
        int len = buf.length();
        char[] result = new char[len];
        buf.getChars(0, len, result, 0);
        return result;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitNames) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.templateName != null && !this.templateName.accept(action)) {
            return false;
        }
        IASTNode[] nodes = this.getTemplateArguments();
        int i = 0;
        while (i < nodes.length) {
            if (!nodes[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitNames) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public boolean isDeclaration() {
        return false;
    }

    public boolean isReference() {
        return true;
    }

    public int getRoleForName(IASTName n) {
        if (n == this.templateName) {
            return 1;
        }
        return 3;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (this.templateArguments == null) {
            return;
        }
        int i = 0;
        while (i < this.templateArguments.length) {
            if (child == this.templateArguments[i]) {
                other.setPropertyInParent(child.getPropertyInParent());
                other.setParent(child.getParent());
                this.templateArguments[i] = other;
            }
            ++i;
        }
    }
}

