/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.rds.ui.preference.RdsPreferencePage;
import org.tizen.common.util.ProjectUtil;
import org.tizen.sdblib.IDevice;

public abstract class FastDeployListener
implements IResourceChangeListener {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String EMPTY_STRING = "";
    protected IProject project;
    protected List<IResourceDelta> deltaList = new ArrayList<IResourceDelta>();
    protected static HashMap<String, Boolean> disabledMap = new HashMap();

    public boolean deploy() throws CoreException {
        return true;
    }

    public boolean isInstalled() {
        return true;
    }

    public boolean isSupportType() {
        return true;
    }

    public IDevice getDevice() {
        return null;
    }

    public boolean isExecutable() {
        if (this.project == null) {
            return false;
        }
        if (!FastDeployListener.isEnabled(this.project)) {
            return false;
        }
        if (!this.isSupportType()) {
            return false;
        }
        if (!RdsPreferencePage.isRdsMode(this.project)) {
            return false;
        }
        if (this.verifyProjectError()) {
            return false;
        }
        if (this.getDevice() == null) {
            return false;
        }
        return this.isInstalled();
    }

    public boolean isAcceptableEvent(IResourceChangeEvent event) {
        return true;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] children = event.getDelta().getAffectedChildren();
        if (children.length == 0) {
            return;
        }
        this.project = ProjectUtil.getProject(children[0].getFullPath());
        if (!this.isExecutable()) {
            return;
        }
        if (!this.isAcceptableEvent(event)) {
            return;
        }
        try {
            this.deploy();
        }
        catch (Exception e) {
            this.logger.error("[FastDeploy] An exception occurs during launch in FastDeploy mode.", (Throwable)e);
            return;
        }
    }

    public boolean verifyProjectError() {
        return false;
    }

    public static void enableFastDeployListener(IProject project) {
        disabledMap.remove(project.getLocation().toString());
    }

    public static void disableFastDeployListener(IProject project) {
        disabledMap.put(project.getLocation().toString(), true);
    }

    public static boolean isEnabled(IProject project) {
        return disabledMap.get(project.getLocation().toString()) == null;
    }
}

