/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.collection.Indexable;

public class IndexedHashMap<K, V extends Indexable> {
    private List<V> dataList = new ArrayList<V>();
    private Map<K, V> dataMap = new HashMap();

    public V put(K key, V value) {
        Indexable old = (Indexable)this.dataMap.put(key, value);
        if (old != null) {
            int index = old.getIndex();
            value.setIndex(index);
            this.dataList.set(index, value);
        } else {
            int index = this.dataList.size();
            value.setIndex(index);
            this.dataList.add(value);
        }
        return (V)old;
    }

    public V getByKey(K key) {
        return (V)((Indexable)this.dataMap.get(key));
    }

    public V getByIndex(int index) {
        if (index >= 0 && index < this.dataList.size()) {
            return (V)((Indexable)this.dataList.get(index));
        }
        return null;
    }

    public boolean containsKey(K key) {
        return this.dataMap.containsKey(key);
    }

    public boolean containsIndex(int index) {
        return index < this.dataList.size();
    }

    public int size() {
        return this.dataList.size();
    }

    public boolean isEmpty() {
        return this.dataList.size() == 0;
    }

    public void clear() {
        this.dataList.clear();
        this.dataMap.clear();
    }

    public List<V> getDataArray() {
        return Collections.unmodifiableList(this.dataList);
    }

    public boolean buildFrom(List<K> keylist, List<V> valuelist, int maxindex) {
        if (keylist == null || valuelist == null || keylist.size() != valuelist.size() || maxindex + 1 < keylist.size()) {
            return false;
        }
        this.clear();
        int i = 0;
        while (i < maxindex + 1) {
            this.dataList.add(null);
            ++i;
        }
        int size = keylist.size();
        int i2 = 0;
        while (i2 < size) {
            Indexable val = (Indexable)valuelist.get(i2);
            int index = val.getIndex();
            this.dataMap.put(keylist.get(i2), val);
            this.dataList.set(index, val);
            ++i2;
        }
        return true;
    }
}

