/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.project;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.ProcessAdditionalInfo;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.project.data.MemoryMapDBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class ProcessInformation {
    private static final String QUERY_DISTINCT_TIME = "select distinct " + MemoryMapDBTable.COLUMN.CAPTIME.name + " from %s where " + MemoryMapDBTable.COLUMN.PID.name + "=%d";
    private final Object processNameRequestLock = new Object();
    private int pid = -1;
    private int ppid = -1;
    private long startTime = -1L;
    private String processName = null;
    private String processNameByRequest = null;
    private AtomicInteger functionEntryLogCount = new AtomicInteger(0);
    private boolean mainOrNot = false;
    private boolean dropLog = false;
    private NavigableMap<Long, ProcessMemoryMap> processMemSnapshots = new TreeMap<Long, ProcessMemoryMap>();
    private Map<Long, Integer> funcIDMap = new ConcurrentHashMap<Long, Integer>();
    private Thread getNameThread = null;

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public int getPpid() {
        return this.ppid;
    }

    public void setPpid(int ppid) {
        this.ppid = ppid;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProcessName() {
        Object object = this.processNameRequestLock;
        synchronized (object) {
            if (this.processNameByRequest == null && this.getNameThread == null) {
                this.getNameThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        String name;
                        ProcessAdditionalInfo pinfo;
                        ArrayList<Integer> pids = new ArrayList<Integer>();
                        pids.add(ProcessInformation.this.pid);
                        HashMap<Integer, ProcessAdditionalInfo> infoMap = new HashMap<Integer, ProcessAdditionalInfo>();
                        DAResult result = new DAResult(DAResult.ErrorCode.ERR_PROCESS_ADD_INFO_GET_FAIL);
                        try {
                            result = DACommunicator.getProcessAdditionalInfo(pids, infoMap);
                        }
                        catch (InterruptedException interruptedException) {
                            Logger.warning((Object)"Interrupted during getting process additional info");
                        }
                        catch (UnsupportedProtocolException unsupportedProtocolException) {
                            Logger.warning((Object)"Message of getting process additional info is not supported by communicator");
                        }
                        if (result.isSuccess() && (pinfo = (ProcessAdditionalInfo)infoMap.get(ProcessInformation.this.pid)) != null && (name = pinfo.getProcessName()) != null && !name.isEmpty()) {
                            int index = name.lastIndexOf("/");
                            if (index > 0) {
                                ProcessInformation.this.processNameByRequest = name.substring(index + 1);
                            } else {
                                ProcessInformation.this.processNameByRequest = name.toString();
                            }
                        }
                        ProcessInformation.this.getNameThread = null;
                    }
                }, "Get process name thread");
                this.getNameThread.start();
            }
        }
        if (this.processNameByRequest != null && !this.processNameByRequest.isEmpty()) {
            return this.processNameByRequest;
        }
        return this.processName;
    }

    public void setProcessName(String name) {
        this.processName = name;
    }

    public int getFunctionEntryLogCount() {
        return this.functionEntryLogCount.intValue();
    }

    public void setFunctionEntryLogCount(int functionEntryLogCount) {
        this.functionEntryLogCount.set(functionEntryLogCount);
    }

    public void addFunctionEntryLogCount() {
        this.functionEntryLogCount.incrementAndGet();
    }

    public boolean isMainOrNot() {
        return this.mainOrNot;
    }

    public void setMainOrNot(boolean mainOrNot) {
        this.mainOrNot = mainOrNot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessMemoryMap(ProcessMemoryMap pmap) {
        long captime = pmap.getCapturedTime();
        NavigableMap<Long, ProcessMemoryMap> navigableMap = this.processMemSnapshots;
        synchronized (navigableMap) {
            this.processMemSnapshots.put(captime, pmap);
        }
    }

    public ProcessMemoryMap getLastProcessMemoryMap() {
        if (this.processMemSnapshots.isEmpty()) {
            return null;
        }
        return this.processMemSnapshots.lastEntry().getValue();
    }

    public ProcessMemoryMap getProcessMemoryMap(long time) {
        Map.Entry<Long, ProcessMemoryMap> fentry = this.processMemSnapshots.floorEntry(time);
        if (fentry == null) {
            return null;
        }
        return fentry.getValue();
    }

    public void setDropLog(boolean droplog) {
        this.dropLog = droplog;
    }

    public boolean isDropLog() {
        return this.dropLog;
    }

    public int getFunctionID(long address) {
        Integer ret = this.funcIDMap.get(address);
        if (ret == null) {
            return -1;
        }
        return ret;
    }

    public void putFunctionID(long address, int funcID) {
        this.funcIDMap.put(address, funcID);
    }

    public void saveMemoryMap(DBTable table) {
        for (Map.Entry entry : this.processMemSnapshots.entrySet()) {
            ((ProcessMemoryMap)entry.getValue()).saveMemoryMap(table);
        }
    }

    public void openMemoryMap(DBTable table) {
        this.processMemSnapshots.clear();
        String query = String.format(QUERY_DISTINCT_TIME, table.getTableName(), this.getPid());
        ResultSet rs = SqlConnectionManager.executeQueryRS(query);
        if (rs != null) {
            try {
                while (rs.next()) {
                    long time = rs.getLong(1);
                    ProcessMemoryMap pmap = new ProcessMemoryMap(this.getPid(), time);
                    pmap.openMemoryMap(table);
                    this.processMemSnapshots.put(time, pmap);
                }
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
            }
            SqlConnectionManager.releaseResultSet(rs);
        }
    }
}

