/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.project.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class FunctionNameDBTable
extends DBTable {
    private static final String TABLENAME = "FUNCTION_INFO";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public FunctionNameDBTable() {
        this.addColumn(new DBColumn(COLUMN.FUNCTIONID.name, "PRIMARY KEY", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.FUNCTIONNAME.name, "NOT NULL", "VARCHAR", 1024));
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(COLUMN.FUNCTIONID.index + 1, (Integer)rowData.get(COLUMN.FUNCTIONID.index));
                String functionStr = this.clipString((String)rowData.get(COLUMN.FUNCTIONNAME.index), 1024, rowData.get(COLUMN.FUNCTIONID.index).toString());
                prep.setString(COLUMN.FUNCTIONNAME.index + 1, functionStr);
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getInt(1));
            row.add(rs.getString(2));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        FUNCTIONID(0, "FUNCTION_ID"),
        FUNCTIONNAME(1, "FUNCTION_NAME");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

