/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.project.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class ProcessInfoDBTable
extends DBTable {
    public static final String TABLENAME = "PROCESS_INFORMATION";

    public ProcessInfoDBTable() {
        this.addColumn(new DBColumn(COLUMN.PID.name, "PRIMARY KEY", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.PPID.name, "", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.STARTTIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.CALLCOUNT.name, "", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.MAINTAG.name, "", "BOOLEAN"));
        this.addColumn(new DBColumn(COLUMN.PROCNAME.name, "", "VARCHAR", 1024));
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(COLUMN.PID.index + 1, (Integer)rowData.get(COLUMN.PID.index));
                prep.setInt(COLUMN.PPID.index + 1, (Integer)rowData.get(COLUMN.PPID.index));
                prep.setLong(COLUMN.STARTTIME.index + 1, (Long)rowData.get(COLUMN.STARTTIME.index));
                prep.setInt(COLUMN.CALLCOUNT.index + 1, (Integer)rowData.get(COLUMN.CALLCOUNT.index));
                prep.setBoolean(COLUMN.MAINTAG.index + 1, (Boolean)rowData.get(COLUMN.MAINTAG.index));
                String retstr = this.clipString((String)rowData.get(COLUMN.PROCNAME.index), 1024, rowData.get(COLUMN.PID.index).toString());
                prep.setString(COLUMN.PROCNAME.index + 1, retstr);
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getInt(1));
            row.add(rs.getInt(2));
            row.add(rs.getLong(3));
            row.add(rs.getInt(4));
            row.add(rs.getBoolean(5));
            row.add(rs.getString(6));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        PID(0, "PID"),
        PPID(1, "PPID"),
        STARTTIME(2, "START_TIME"),
        CALLCOUNT(3, "FUNCTION_CALL_COUNT"),
        MAINTAG(4, "MAIN_TAG"),
        PROCNAME(5, "PROCESS_NAME");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

