/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class ElmEntryProperties
extends HierarchyUIObjectProperties {
    private String entry;
    private boolean scrollable;
    private boolean inputPanelShowOnDemand;
    private boolean contextMenuDisabled;
    private String cnpMode;
    private boolean editable;
    private String anchorHoverStyle;
    private boolean singleLine;
    private boolean password;
    private boolean autoSave;
    private boolean predictionAllow;
    private boolean inputPanelEnabled;
    private int cursorPos;
    private boolean cursorIsFormat;
    private String cursorContent;
    private String selection;
    private boolean cursorIsVisibleFormat;

    public ElmEntryProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.entry = parser.getString();
        this.scrollable = parser.getBoolean();
        this.inputPanelShowOnDemand = parser.getBoolean();
        this.contextMenuDisabled = parser.getBoolean();
        this.cnpMode = this.getCnpModeMessage(parser.getChar());
        this.editable = parser.getBoolean();
        this.anchorHoverStyle = parser.getString();
        this.singleLine = parser.getBoolean();
        this.password = parser.getBoolean();
        this.autoSave = parser.getBoolean();
        this.predictionAllow = parser.getBoolean();
        this.inputPanelEnabled = parser.getBoolean();
        this.cursorPos = parser.getInt();
        this.cursorIsFormat = parser.getBoolean();
        this.cursorContent = parser.getString();
        this.selection = parser.getString();
        this.cursorIsVisibleFormat = parser.getBoolean();
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("entry", this.entry));
        properties.add(new PropertyValue("scrollable", Boolean.toString(this.scrollable)));
        properties.add(new PropertyValue("inputPanelShowOnDemand", Boolean.toString(this.inputPanelShowOnDemand)));
        properties.add(new PropertyValue("contextMenuDisabled", Boolean.toString(this.contextMenuDisabled)));
        properties.add(new PropertyValue("cnpMode", this.cnpMode));
        properties.add(new PropertyValue("editable", Boolean.toString(this.editable)));
        properties.add(new PropertyValue("anchorHoverStyle", this.anchorHoverStyle));
        properties.add(new PropertyValue("singleLine", Boolean.toString(this.singleLine)));
        properties.add(new PropertyValue("password", Boolean.toString(this.password)));
        properties.add(new PropertyValue("autoSave", Boolean.toString(this.autoSave)));
        properties.add(new PropertyValue("predictionAllow", Boolean.toString(this.predictionAllow)));
        properties.add(new PropertyValue("inputPanelEnabled", Boolean.toString(this.inputPanelEnabled)));
        properties.add(new PropertyValue("cursorPos", Integer.toString(this.cursorPos)));
        properties.add(new PropertyValue("cursorIsFormat", Boolean.toString(this.cursorIsFormat)));
        properties.add(new PropertyValue("cursorContent", this.cursorContent));
        properties.add(new PropertyValue("selection", this.selection));
        properties.add(new PropertyValue("cursorIsVisibleFormat", Boolean.toString(this.cursorIsVisibleFormat)));
        return properties;
    }

    private String getCnpModeMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_CNP_MODE_MARKUP";
            }
            case 1: {
                return "ELM_CNP_MODE_NO_IMAGE";
            }
            case 2: {
                return "ELM_CNP_MODE_PLAINTEXT";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }
}

