/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.file;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.nl.FilePageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.file.model.FileAccess;
import org.tizen.dynamicanalyzer.ui.file.model.FileAccessor;
import org.tizen.dynamicanalyzer.ui.file.model.FileStatus;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class FileChart {
    List<FileChart> child = new ArrayList<FileChart>();
    private DAChartBoardItem item;
    private DAChart chart;
    private String chartName;
    private DAChartSeries statusSeries;
    private DAChartSeries lockSeries;
    private DAChartSeries accessSeries;
    private String filePath = null;
    private int fileId = -1;
    private FileAccessor fileAccessor = null;
    private int chartIndex = -1;
    private boolean isTarget = false;

    public FileChart(String filePath, int fileId) {
        this.filePath = filePath;
        this.fileId = fileId;
    }

    public FileChart(FileAccessor fileAccessor, int chartIndex, boolean isTarget) {
        this.fileAccessor = fileAccessor;
        this.chartIndex = chartIndex;
        this.isTarget = isTarget;
    }

    public void setItem(DAChartBoardItem item) {
        this.item = item;
        this.chart = item.getChart();
        this.lockSeries = this.chart.getSeries(FilePageLabels.FILE_CHART_LOCK);
        this.accessSeries = this.chart.getSeries(FilePageLabels.FILE_CHART_ACCESS);
        this.statusSeries = this.chart.getSeries(FilePageLabels.FILE_CHART_SERIES);
    }

    public void clearSeries() {
        if (this.isParentChart()) {
            this.statusSeries.clear();
        } else {
            this.lockSeries.clear();
            this.accessSeries.clear();
        }
    }

    public void updateAccessSeries(List<FileAccess> accessList) {
        int i = 0;
        while (i < accessList.size()) {
            FileAccess data = accessList.get(i);
            if (data.getAccessorId() == this.fileAccessor.getAccessorId()) {
                double startTime = (double)data.getStartTime() / 1000000.0;
                double endTime = (double)data.getEndTime() / 1000000.0;
                switch (data.getApiType()) {
                    case 2: {
                        if (data.isWarning()) {
                            this.accessSeries.addSeriesItem(new DAChartSeriesItem(startTime, 0.0, ColorResources.FILE_ACCESS_CONCURRENT_READ, ColorResources.FILE_ACCESS_CONCURRENT_READ, false, data.getTooltip()));
                            if (!(endTime > 0.0)) break;
                            this.accessSeries.addSeriesItem(new DAChartSeriesItem(endTime, 1.0, ColorResources.FILE_ACCESS_CONCURRENT_READ, ColorResources.FILE_ACCESS_CONCURRENT_READ, false, data.getTooltip()));
                            break;
                        }
                        this.accessSeries.addSeriesItem(new DAChartSeriesItem(startTime, 0.0, ColorResources.FILE_ACCESS_READ, ColorResources.FILE_ACCESS_READ, false, data.getTooltip()));
                        if (!(endTime > 0.0)) break;
                        this.accessSeries.addSeriesItem(new DAChartSeriesItem(endTime, 1.0, ColorResources.FILE_ACCESS_READ, ColorResources.FILE_ACCESS_READ, false, data.getTooltip()));
                        break;
                    }
                    case 4: {
                        if (data.isWarning()) {
                            this.accessSeries.addSeriesItem(new DAChartSeriesItem(startTime, 0.0, ColorResources.FILE_ACCESS_CONCURRENT_WRITE, ColorResources.FILE_ACCESS_CONCURRENT_WRITE, false, data.getTooltip()));
                            if (!(endTime > 0.0)) break;
                            this.accessSeries.addSeriesItem(new DAChartSeriesItem(endTime, 1.0, ColorResources.FILE_ACCESS_CONCURRENT_WRITE, ColorResources.FILE_ACCESS_CONCURRENT_WRITE, false, data.getTooltip()));
                            break;
                        }
                        this.accessSeries.addSeriesItem(new DAChartSeriesItem(startTime, 0.0, ColorResources.FILE_ACCESS_WRITE, ColorResources.FILE_ACCESS_WRITE, false, data.getTooltip()));
                        if (!(endTime > 0.0)) break;
                        this.accessSeries.addSeriesItem(new DAChartSeriesItem(endTime, 1.0, ColorResources.FILE_ACCESS_WRITE, ColorResources.FILE_ACCESS_WRITE, false, data.getTooltip()));
                        break;
                    }
                    case 14: {
                        this.lockSeries.addSeriesItem(new DAChartSeriesItem(startTime, 0.0, ColorResources.FILE_LOCK, ColorResources.FILE_LOCK, false, data.getTooltip()));
                        if (!(endTime > 0.0)) break;
                        this.lockSeries.addSeriesItem(new DAChartSeriesItem(endTime, 1.0, ColorResources.FILE_LOCK, ColorResources.FILE_LOCK, false, data.getTooltip()));
                        break;
                    }
                    case 16: {
                        this.lockSeries.addSeriesItem(new DAChartSeriesItem(startTime, 2.0, ColorResources.FILE_UNLOCK, ColorResources.FILE_UNLOCK, data.getTooltip()));
                        break;
                    }
                    case 17: {
                        this.lockSeries.addSeriesItem(new DAChartSeriesItem(startTime, 2.0, ColorResources.FILE_UNLOCK, ColorResources.FILE_UNLOCK, data.getTooltip()));
                        break;
                    }
                    case 18: {
                        this.accessSeries.addSeriesItem(new DAChartSeriesItem(startTime, 2.0, ColorResources.FILE_API_FAILED, ColorResources.FILE_API_FAILED, data.getTooltip()));
                    }
                }
            }
            ++i;
        }
        this.chart.redraw();
    }

    public void updateStatusSeries(List<FileStatus> statusList) {
        int openNum = 0;
        int closeNum = 0;
        int i = 0;
        while (i < statusList.size()) {
            FileStatus data = statusList.get(i);
            if (data.getFileId() == this.fileId) {
                double time = Formatter.longTimeToDoubleTime(data.getEventTime());
                switch (data.getApiType()) {
                    case 0: {
                        if (openNum > 0) {
                            ++openNum;
                            this.statusSeries.addSeriesItem(new DAChartSeriesItem(time, 0.0, ColorResources.FILE_DUPLICATE_OPENED, ColorResources.FILE_DUPLICATE_OPENED, FilePageLabels.FILE_CHART_TOOLTIP_MULTI_OPEN));
                            break;
                        }
                        ++openNum;
                        this.statusSeries.addSeriesItem(new DAChartSeriesItem(time, 0.0, ColorResources.FILE_OPENED, ColorResources.FILE_OPENED, FilePageLabels.FILE_CHART_TOOLTIP_OPEN));
                        break;
                    }
                    case 1: {
                        if (openNum == ++closeNum) {
                            this.statusSeries.addSeriesItem(new DAChartSeriesItem(time, 1.0, ColorResources.FILE_OPENED, ColorResources.FILE_OPENED, FilePageLabels.FILE_CHART_TOOLTIP_OPEN));
                            openNum = 0;
                            closeNum = 0;
                            break;
                        }
                        this.statusSeries.addSeriesItem(new DAChartSeriesItem(time, 1.0, ColorResources.FILE_DUPLICATE_OPENED, ColorResources.FILE_OPENED, FilePageLabels.FILE_CHART_TOOLTIP_MULTI_OPEN));
                    }
                }
            }
            ++i;
        }
        this.chart.redraw();
    }

    public boolean isParentChart() {
        return this.child.size() > 0;
    }

    public FileChart getChildChart(FileAccessor accessor) {
        int size = this.child.size();
        int i = 0;
        while (i < size) {
            FileChart row = this.child.get(i);
            if (row.getFileAccessor().equals(accessor)) {
                return row;
            }
            ++i;
        }
        return null;
    }

    public DAChartBoardItem getItem() {
        return this.item;
    }

    public int getLastChildChartIndex() {
        return this.child.size() - 1;
    }

    public List<FileChart> getChild() {
        return this.child;
    }

    public void addChild(FileChart child) {
        this.child.add(child);
    }

    public String getChartName() {
        return this.chartName;
    }

    public void setChartName(String chartName) {
        this.chartName = chartName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileName() {
        String[] splitPath = this.filePath.split("\\/");
        String fileName = new String(splitPath[splitPath.length - 1]);
        return fileName;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setTarget(boolean isTarget) {
        this.isTarget = isTarget;
    }

    public boolean isTarget() {
        return this.isTarget;
    }

    public int getChartIndex() {
        return this.chartIndex;
    }

    public void setChartIndex(int index) {
        this.chartIndex = index;
    }

    public int getFileId() {
        return this.fileId;
    }

    public void setFileId(int fileId) {
        this.fileId = fileId;
    }

    public void setFileAccessor(FileAccessor fileAccessor) {
        this.fileAccessor = fileAccessor;
    }

    public FileAccessor getFileAccessor() {
        return this.fileAccessor;
    }

    public DAChart getChart() {
        return this.chart;
    }
}

