/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.UIHierarchyData;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObject;
import org.tizen.dynamicanalyzer.ui.hierarchy.NodeSearchType;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.HierarchyTreeView;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.tool.HierarchyZoomManager;
import org.tizen.dynamicanalyzer.util.Logger;

public class HierarchyDataManager
extends PageDataManager {
    private static HierarchyDataManager instance = null;
    private List<HierarchyUIObject> rootUIObjects = new ArrayList<HierarchyUIObject>();

    private HierarchyDataManager() {
    }

    public static synchronized HierarchyDataManager getInstance() {
        if (instance == null) {
            instance = new HierarchyDataManager();
        }
        return instance;
    }

    @Override
    protected void makeData(LogPackage pack) {
        List<LogData> logList;
        Logs logs = pack.getLogs(33);
        List<LogData> list = logList = logs == null ? null : logs.getRawLogs();
        if (logList != null && logList.size() == 1) {
            this.rootUIObjects.clear();
            boolean isSuccess = ((UIHierarchyData)logList.get(0)).lazyParse(this.rootUIObjects);
            HierarchyTreeView treeView = HierarchyZoomManager.INSTANCE.getTreeView();
            treeView.stopProgress(isSuccess);
        }
    }

    @Override
    public void openData(Map<String, String> dataMap) {
        final HierarchyTreeView treeView = HierarchyZoomManager.INSTANCE.getTreeView();
        if (Global.getProject() != null && treeView != null && !treeView.isDisposed()) {
            UIHierarchyData hierarchyData = new UIHierarchyData();
            hierarchyData.setProtocolVersion(Protocol.getVersion(Global.getProject().getProtocolVersion()));
            boolean isSuccess = hierarchyData.extractUIHierarchyInfo(this.rootUIObjects);
            if (isSuccess) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        treeView.restructTree();
                    }
                });
            } else {
                Logger.debug((Object)"Failed to extract ui hierarchy info file!!");
            }
        }
    }

    public List<HierarchyUIObject> getRootUIObjects() {
        return this.rootUIObjects;
    }

    public List<HierarchyUIObject> searchUIObject(NodeSearchType searchType, String keyword) {
        ArrayList<HierarchyUIObject> searchedList = new ArrayList<HierarchyUIObject>();
        if (!keyword.trim().isEmpty()) {
            int i = 0;
            while (i < this.rootUIObjects.size()) {
                HierarchyUIObject rootUIObject = this.rootUIObjects.get(i);
                this.searchUIObject(searchType, keyword, rootUIObject, searchedList);
                ++i;
            }
        }
        return searchedList;
    }

    private void searchUIObject(NodeSearchType searchType, String keyword, HierarchyUIObject targetUIObject, List<HierarchyUIObject> searchedList) {
        String targetWord = this.getTargetSearchWord(searchType, targetUIObject);
        if (targetWord != null && targetWord.toLowerCase().contains(keyword.toLowerCase())) {
            searchedList.add(targetUIObject);
        }
        Iterator<HierarchyUIObject> iter = targetUIObject.getChildrenIterator();
        while (iter.hasNext()) {
            this.searchUIObject(searchType, keyword, iter.next(), searchedList);
        }
    }

    private String getTargetSearchWord(NodeSearchType searchType, HierarchyUIObject targetUIObject) {
        switch (searchType) {
            case TYPE: {
                return targetUIObject.getTypeName();
            }
            case NAME: {
                return targetUIObject.getName();
            }
            case TEXT: {
                return targetUIObject.getText();
            }
        }
        Logger.error((Object)("Unsupported Search type : " + searchType.getCode()));
        return null;
    }

    private void calculateRenderSpeedGrade(PriorityQueue<HierarchyUIObject> queue) {
        int size = queue.size();
        HierarchyUIObject cursor = null;
        int i = 0;
        while (i < size) {
            cursor = queue.poll();
            if (i < size / 2) {
                cursor.setRenderSpeedGrade(HierarchyUIObject.RENDER_SPEED_GRADE.FASTER);
            } else if (size / 2 <= i && i < size - 1) {
                cursor.setRenderSpeedGrade(HierarchyUIObject.RENDER_SPEED_GRADE.SLOWER);
            } else {
                cursor.setRenderSpeedGrade(HierarchyUIObject.RENDER_SPEED_GRADE.SLOWEST);
            }
            ++i;
        }
    }

    public void clear() {
        this.rootUIObjects.clear();
    }
}

