/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.ProcessAdditionalInfo;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.SystemData;
import org.tizen.dynamicanalyzer.ui.info.process.ProcessData;
import org.tizen.dynamicanalyzer.util.Logger;

public class ProcessDataManager
extends PageDataManager {
    private static ProcessDataManager instance = null;
    public static final String REQUEST_PROCESS = "<getting process name...>";
    public static final String UNKNOWN_PROCESS = "<unknown process name>";
    private List<ProcessData> processListForView = new ArrayList<ProcessData>();
    private ConcurrentMap<Integer, String> processNameByPIDMap = new ConcurrentHashMap<Integer, String>();

    public static synchronized ProcessDataManager getInstance() {
        if (instance == null) {
            instance = new ProcessDataManager();
        }
        return instance;
    }

    public void clear() {
        this.processListForView.clear();
        this.processNameByPIDMap.clear();
    }

    @Override
    protected void clearAfterStop() {
        this.processListForView.clear();
    }

    @Override
    protected void makeData(LogPackage pack) {
        List<LogData> systemLogList;
        Logs systemLogs = pack.getLogs(5);
        List<LogData> list = systemLogList = systemLogs == null ? null : systemLogs.getRawLogs();
        if (systemLogList == null || systemLogList.size() == 0) {
            return;
        }
        ArrayList<ProcessData> currentProcessList = new ArrayList<ProcessData>();
        ArrayList<Integer> requestPIDList = new ArrayList<Integer>();
        SystemData log = (SystemData)systemLogList.get(systemLogList.size() - 1);
        if (log.getOtherProcessLoad() == null) {
            return;
        }
        String[] processLoadDatas = log.getOtherProcessLoad().split(",");
        int i = 0;
        while (i < processLoadDatas.length) {
            String strPID = processLoadDatas[i].trim();
            if (strPID != null && !strPID.trim().isEmpty()) {
                Integer pID = new Integer(strPID);
                String strCpuLoad = processLoadDatas[++i];
                String processName = this.getProcessName(pID);
                if (processName.equals(REQUEST_PROCESS)) {
                    requestPIDList.add(pID);
                }
                currentProcessList.add(new ProcessData(processName, pID, strCpuLoad));
            }
            ++i;
        }
        this.removeMAPByCmpList(currentProcessList, this.processNameByPIDMap);
        this.processListForView = currentProcessList;
        if (requestPIDList.size() > 0) {
            this.startRequestThread(requestPIDList);
        }
    }

    private String getProcessName(int pID) {
        if (this.processNameByPIDMap.containsKey(pID)) {
            return (String)this.processNameByPIDMap.get(pID);
        }
        this.processNameByPIDMap.put(pID, REQUEST_PROCESS);
        return REQUEST_PROCESS;
    }

    public void startRequestThread(final List<Integer> requestPIdList) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ProcessDataManager.this.requestProcessName(requestPIdList, ProcessDataManager.this.processNameByPIDMap);
            }
        }, ProcessDataManager.class.getName());
        thread.start();
    }

    private void removeMAPByCmpList(List<ProcessData> newProcessesList, Map<Integer, String> processNameMap) {
        ArrayList<Integer> removeList = new ArrayList<Integer>();
        for (Map.Entry<Integer, String> entry : processNameMap.entrySet()) {
            Integer pID = entry.getKey();
            boolean isExist = false;
            for (ProcessData pIDList : newProcessesList) {
                if (pIDList.getPID() != pID.intValue()) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            removeList.add(pID);
        }
        for (Integer pID : removeList) {
            processNameMap.remove(pID);
        }
    }

    private void requestProcessName(List<Integer> inputList, Map<Integer, String> outputMap) {
        HashMap<Integer, ProcessAdditionalInfo> infoMap = new HashMap<Integer, ProcessAdditionalInfo>();
        DAResult result = new DAResult(DAResult.ErrorCode.ERR_PROCESS_ADD_INFO_GET_FAIL);
        try {
            result = DACommunicator.getProcessAdditionalInfo(inputList, infoMap);
        }
        catch (InterruptedException interruptedException) {
            Logger.warning((Object)"Interrupted during getting process additional info");
        }
        catch (UnsupportedProtocolException unsupportedProtocolException) {
            Logger.warning((Object)"Message of getting process additional info is not supported by communicator");
        }
        if (result.isSuccess()) {
            for (Map.Entry entry : infoMap.entrySet()) {
                Integer pID = (Integer)entry.getKey();
                String name = ((ProcessAdditionalInfo)entry.getValue()).getProcessName();
                String processNameByRequest = UNKNOWN_PROCESS;
                if (name != null && !name.isEmpty()) {
                    int index = name.lastIndexOf("/");
                    processNameByRequest = index > 0 ? name.substring(index + 1) : name.toString();
                }
                if (!outputMap.containsKey(pID) || !outputMap.get(pID).equals(REQUEST_PROCESS)) continue;
                outputMap.put(pID, processNameByRequest);
            }
        }
    }

    public List<ProcessData> getProcessData() {
        return this.processListForView;
    }
}

