/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.screenshot;

import com.google.protobuf.CodedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import org.tizen.dynamicanalyzer.ui.info.screenshot.MessageQueue;
import org.tizen.dynamicanalyzer.ui.info.screenshot.SocketClient;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ecs.Ecs;
import org.tizen.dynamicanalyzer.util.Logger;

public class SocketReceive
implements Runnable {
    @Override
    public void run() {
        SocketClient client = SocketClient.getInstance();
        Logger.info((Object)"Socket Receive runs.");
        DataInputStream in = client.getInputStream();
        int size = 0;
        try {
            while ((size = in.readInt()) > 0) {
                if (client.getSocket().isClosed() || !client.isRunning()) {
                    Logger.debug((Object)"closed || not running.");
                    break;
                }
                this.read_data(size, in);
            }
        }
        catch (EOFException eOFException) {
            client.disconnect();
        }
        catch (IOException iOException) {
            client.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read_data(int size, DataInputStream in) throws IOException {
        CodedInputStream codedIn = null;
        int available = in.available();
        if (size <= available) {
            byte[] buff = new byte[size];
            int read = in.read(buff);
            if (read > size) {
                return;
            }
            codedIn = CodedInputStream.newInstance((byte[])buff);
        } else {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            byte[] bSize = ByteBuffer.allocate(4).putInt(size).array();
            String message = String.valueOf(new String(bSize, 0, 4)) + reader.readLine();
            Logger.debug((Object)("message len: " + message.length() + ", message:" + message));
        }
        if (codedIn != null) {
            Ecs.Master msg = Ecs.Master.parseFrom(codedIn);
            MessageQueue messageQueue = MessageQueue.getInstance();
            synchronized (messageQueue) {
                MessageQueue.getInstance().QueueMsg(msg);
            }
        }
    }
}

