/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.chart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.common.ChartPopupMenu;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;

public class MemoryChart {
    public DAChart chart;
    protected DAChartBoardItem chartBoardItem;
    protected int chartType;
    protected int chartStyle = 0;
    protected String chartName;
    protected Image chartIcon;
    protected Image addIcon;
    protected String pageID;
    protected DAPopupMenu popupMenu;
    protected int pid = 0;
    private List<MemoryChart> children = new ArrayList<MemoryChart>();

    public MemoryChart(String pageID) {
        this.pageID = pageID;
    }

    public MemoryChart(String pageID, String chartName, DAChartBoardItem chartBoardItem, DAChart chart) {
        this.pageID = pageID;
        this.chartName = chartName;
        this.chartBoardItem = chartBoardItem;
        this.chart = chart;
        this.popupMenu = new ChartPopupMenu(chart);
    }

    public DAChartBoardItem getChartItem() {
        return this.chartBoardItem;
    }

    public void setChartITem(DAChartBoardItem item) {
        this.chartBoardItem = item;
    }

    public int getChartType() {
        return this.chartType;
    }

    public String getChartName() {
        return this.chartName;
    }

    public void clear() {
        if (this.chart != null && !this.chart.isDisposed()) {
            this.chart.clear();
        }
    }

    public void clearSeries() {
        if (this.chart == null || this.chart.getSeriesList() == null) {
            return;
        }
        for (DAChartSeries series : this.chart.getSeriesList()) {
            series.clear();
        }
    }

    public DAPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void update() {
        if (this.chart != null && !this.chart.isDisposed()) {
            this.chart.redraw();
        }
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public int getPid() {
        return this.pid;
    }

    public void inputChartSeries(List<Object> dataList) {
    }

    public DAChartBoardItem createBoardItem(DAChartBoard chartBoard) {
        DAChartBoardItem item = new DAChartBoardItem(chartBoard, this.chartName, this.chartIcon, this.chartStyle);
        item.useExpand(false);
        this.chart = item.getChart();
        this.setChartStyle();
        return item;
    }

    protected void setChartStyle() {
        DAChartPlot plot = this.chart.getPlot();
        if (plot == null) {
            return;
        }
        plot.setBackgroundImage(ImageResources.BG_GRADIENT);
        plot.setAutoHeightRange(DAChartPlot.AutoRangeType.SEMI_AUTO);
        DAChartPlotTooltip tooltip = new DAChartPlotTooltip(-1.0);
        tooltip.setFont(FontResources.CHART_TOOLTIP_FONT);
        plot.setTooltip(tooltip);
        plot.setAxisFont(FontResources.CHART_AXIS_FONT);
    }

    public void pushChild(MemoryChart child) {
        this.children.add(child);
    }

    public boolean isParentChart() {
        return this.children.size() > 0;
    }

    public DAChart getChart() {
        return this.chart;
    }
}

