/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.swap.model.data.GLES20LogData;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLContextDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLStateDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLStateProgramType;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLStateShaderType;
import org.tizen.dynamicanalyzer.utils.DownloadContentfileManager;

public class GLProgramStateDataMaker {
    private GLStateDataManager glStateDataManager = null;

    public GLProgramStateDataMaker(GLStateDataManager glStateDataManager) {
        this.glStateDataManager = glStateDataManager;
    }

    private GLStateDataManager getStateDataManager() {
        return this.glStateDataManager;
    }

    public void extractGLProgramAPIParameter(GLES20LogData logData) {
        block27: {
            GLContextDataManager curretnContextValue;
            String parameter;
            String apiName;
            block36: {
                String contextID;
                block35: {
                    String[] parameters;
                    block34: {
                        block33: {
                            block32: {
                                String returnValue;
                                block31: {
                                    block30: {
                                        block29: {
                                            String contextValue;
                                            block28: {
                                                apiName = logData.getApiName();
                                                if (!this.glStateDataManager.isNormalAPIStatusForExtractParameter(logData)) {
                                                    return;
                                                }
                                                parameter = logData.getArgs().trim();
                                                contextValue = logData.getContextValue().trim();
                                                returnValue = logData.getReturn().trim();
                                                parameters = parameter.split(", ");
                                                contextID = Long.toString(logData.getCurrentContextID()).trim();
                                                long contextId = logData.getCurrentContextID();
                                                curretnContextValue = this.getStateDataManager().getGLContextDataManager(contextId);
                                                if (!apiName.equals("glCreateShader")) break block28;
                                                int shaderID = Integer.parseInt(returnValue);
                                                int shaderType = Integer.parseInt(parameter);
                                                GLStateShaderType stateShaderType = new GLStateShaderType(contextId, shaderID);
                                                stateShaderType.setShaderType(shaderType);
                                                curretnContextValue.shaderList.add(stateShaderType);
                                                break block27;
                                            }
                                            if (!apiName.equals("glShaderSource")) break block29;
                                            int shaderID = Integer.parseInt(parameters[0]);
                                            int i = 0;
                                            while (i < curretnContextValue.shaderList.size()) {
                                                if (curretnContextValue.shaderList.get(i).getId() == shaderID) {
                                                    curretnContextValue.shaderList.get(i).setShaderSrc(DownloadContentfileManager.getDowonloadFilePath(contextValue));
                                                    return;
                                                }
                                                ++i;
                                            }
                                            break block27;
                                        }
                                        if (!apiName.equals("glCompileShader")) break block30;
                                        int shaderID = Integer.parseInt(parameter);
                                        int i = 0;
                                        while (i < curretnContextValue.shaderList.size()) {
                                            if (curretnContextValue.shaderList.get(i).getId() == shaderID) {
                                                curretnContextValue.shaderList.get(i).setCompileStatus(1);
                                                return;
                                            }
                                            ++i;
                                        }
                                        break block27;
                                    }
                                    if (!apiName.equals("glDeleteShader")) break block31;
                                    int shaderId = Integer.parseInt(parameter);
                                    int i = 0;
                                    while (i < curretnContextValue.shaderList.size()) {
                                        if (curretnContextValue.shaderList.get(i).getId() == shaderId) {
                                            curretnContextValue.shaderList.get(i).setDeleteStatus(1);
                                            break block27;
                                        }
                                        ++i;
                                    }
                                    break block27;
                                }
                                if (!apiName.equals("glCreateProgram")) break block32;
                                int programID = Integer.parseInt(returnValue);
                                GLStateProgramType stateProgramType = new GLStateProgramType(programID);
                                curretnContextValue.programList.add(stateProgramType);
                                break block27;
                            }
                            if (!apiName.equals("glAttachShader")) break block33;
                            int programID = Integer.parseInt(parameters[0]);
                            int shaderID = Integer.parseInt(parameters[1]);
                            boolean isFragementShaser = false;
                            int i = 0;
                            while (i < curretnContextValue.shaderList.size()) {
                                if (curretnContextValue.shaderList.get(i).getId() == shaderID) {
                                    if (curretnContextValue.shaderList.get(i).isFragementShader()) {
                                        isFragementShaser = true;
                                        break;
                                    }
                                    isFragementShaser = false;
                                    break;
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < curretnContextValue.programList.size()) {
                                if (curretnContextValue.programList.get(i).getId() == programID) {
                                    if (isFragementShaser) {
                                        curretnContextValue.programList.get(i).setFragmentShaderId(shaderID);
                                    } else {
                                        curretnContextValue.programList.get(i).setVertexShaderId(shaderID);
                                    }
                                    return;
                                }
                                ++i;
                            }
                            break block27;
                        }
                        if (!apiName.equals("glLinkProgram")) break block34;
                        int programID = Integer.parseInt(parameter);
                        int i = 0;
                        while (i < curretnContextValue.programList.size()) {
                            if (curretnContextValue.programList.get(i).getId() == programID) {
                                curretnContextValue.programList.get(i).setLinkStatus(1);
                                break block27;
                            }
                            ++i;
                        }
                        break block27;
                    }
                    if (!apiName.equals("glDetachShader")) break block35;
                    int programID = Integer.parseInt(parameters[0]);
                    int shaderID = Integer.parseInt(parameters[1]);
                    boolean isFragementShaser = false;
                    int i = 0;
                    while (i < curretnContextValue.shaderList.size()) {
                        if (curretnContextValue.shaderList.get(i).getId() == shaderID) {
                            if (curretnContextValue.shaderList.get(i).isFragementShader()) {
                                isFragementShaser = true;
                                break;
                            }
                            isFragementShaser = false;
                            break;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < curretnContextValue.programList.size()) {
                        if (curretnContextValue.programList.get(i).getId() == programID) {
                            if (isFragementShaser) {
                                curretnContextValue.programList.get(i).setFragmentShaderId(-1);
                            } else {
                                curretnContextValue.programList.get(i).setVertexShaderId(-1);
                            }
                            return;
                        }
                        ++i;
                    }
                    break block27;
                }
                if (!apiName.equals("glUseProgram")) break block36;
                long programId = Long.parseLong(parameter);
                int i = 0;
                while (i < curretnContextValue.programList.size()) {
                    if ((long)curretnContextValue.programList.get(i).getId() == programId) {
                        curretnContextValue.programList.get(i).setContextId(Integer.parseInt(contextID));
                        break block27;
                    }
                    ++i;
                }
                break block27;
            }
            if (!apiName.equals("glDeleteProgram")) break block27;
            int programId = Integer.parseInt(parameter);
            int i = 0;
            while (i < curretnContextValue.programList.size()) {
                if (curretnContextValue.programList.get(i).getId() == programId) {
                    curretnContextValue.programList.get(i).setDeleteStatus(1);
                    break;
                }
                ++i;
            }
        }
    }

    public void addProgramList(GLStateProgramType programType) {
        GLContextDataManager contextValue = this.getStateDataManager().getGLContextDataManager(programType.getContextId());
        if (contextValue == null) {
            contextValue = new GLContextDataManager(programType.getContextId());
            this.getStateDataManager().getStateHashMap().put(programType.getContextId(), contextValue);
        }
        contextValue.programList.add(programType);
    }

    public void addShaderList(GLStateShaderType shaderType) {
        GLContextDataManager contextValue = this.getStateDataManager().getGLContextDataManager(shaderType.getContextId());
        if (contextValue == null) {
            contextValue = new GLContextDataManager(shaderType.getContextId());
            this.getStateDataManager().getStateHashMap().put(shaderType.getContextId(), contextValue);
        }
        contextValue.shaderList.add(shaderType);
    }

    public List<GLStateProgramType> getProgramList() {
        ArrayList<GLStateProgramType> returnProgramList = new ArrayList<GLStateProgramType>();
        Iterator<Map.Entry<Long, GLContextDataManager>> itr = this.getStateDataManager().getStateHashMap().entrySet().iterator();
        while (itr.hasNext()) {
            GLContextDataManager contextValue = itr.next().getValue();
            returnProgramList.addAll(contextValue.programList);
        }
        return returnProgramList;
    }

    public List<GLStateShaderType> getShaderList() {
        ArrayList<GLStateShaderType> returnShaderList = new ArrayList<GLStateShaderType>();
        Iterator<Map.Entry<Long, GLContextDataManager>> itr = this.getStateDataManager().getStateHashMap().entrySet().iterator();
        while (itr.hasNext()) {
            GLContextDataManager contextValue = itr.next().getValue();
            returnShaderList.addAll(contextValue.shaderList);
        }
        return returnShaderList;
    }
}

