/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.table.state;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.model.FilterProperty;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.nl.GLPageLabels;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLSelectionData;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLStateProgramType;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class GLProgramTable
extends DATableComposite {
    public GLProgramTable(Composite parent, int style, int tableStyle) {
        super(parent, style, tableStyle);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = GLProgramTable.this.table.getSelection();
                if (items == null) {
                    return;
                }
                GLSelectionData selData = new GLSelectionData(GLPage.programViewID, -1L, -1L, items, (Control)GLProgramTable.this.table, -1, -1L);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected List<TableInput> makeTableInput() {
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        if (GLDataManager.getInstance().getStateDataManager() == null) {
            return input;
        }
        List<FilterProperty> filterList = this.getFilterPropertyList();
        List<GLStateProgramType> programList = GLDataManager.getInstance().getStateDataManager().getProgramMakeObject().getProgramList();
        int size = 0;
        if (programList != null) {
            size = programList.size();
        }
        int i = 0;
        while (i < size) {
            block13: {
                String programId = Integer.toString(programList.get(i).getId());
                DATableDataFormat tableData = new DATableDataFormat(Long.parseLong(programId));
                String contextName = String.valueOf(GLPageLabels.GL_CONTEXT) + "_" + programList.get(i).getContextId();
                String programID = String.valueOf(GLPageLabels.GL_PROGRAM) + programId;
                String vertexShaderID = String.valueOf(GLPageLabels.GL_SHADER) + programList.get(i).getVertexShaderId();
                String vertexFragmentID = String.valueOf(GLPageLabels.GL_SHADER) + programList.get(i).getFragmentShaderId();
                int j = 0;
                while (j < filterList.size()) {
                    switch (filterList.get(j).getColumnIndex()) {
                        case 0: {
                            if (programID.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                            break block13;
                        }
                        case 1: {
                            if (contextName.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                            break block13;
                        }
                        case 2: {
                            if (vertexShaderID.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                            break block13;
                        }
                        case 3: {
                            if (!vertexFragmentID.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break block13;
                        }
                    }
                    ++j;
                }
                ArrayList<String> text = new ArrayList<String>();
                text.add(programID);
                text.add(contextName);
                text.add(vertexShaderID);
                text.add(vertexFragmentID);
                TableInput tableInput = new TableInput();
                tableInput.setText(text);
                tableInput.setData(tableData);
                input.add(tableInput);
                long contextID = programList.get(i).getContextId();
                if (GLDataManager.getInstance().getSelectedContextID() == contextID) {
                    tableInput.setSecondSelection(true);
                }
                if (GLDataManager.getInstance().isSharingData(contextID)) {
                    tableInput.setSecondSelection(true);
                }
            }
            ++i;
        }
        return input;
    }

    public void removeSelection() {
        this.table.removeAll();
        this.updateTable();
    }
}

