/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.table.state;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLConstantDefine;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLRedundantDataType;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLSelectionData;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class GLRedundantTable
extends DATableComposite {
    public GLRedundantTable(Composite parent, int style, int tableStyle) {
        super(parent, style, tableStyle);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = GLRedundantTable.this.table.getSelection();
                if (items == null) {
                    return;
                }
                DATableDataFormat tableDataFormat = (DATableDataFormat)items[0].getData();
                GLDataManager.getInstance().setSelectedAPIAtTable((String)tableDataFormat.getData().get(2));
                GLSelectionData selData = new GLSelectionData(GLPage.redundantViewID, 0L, 0L, items, (Control)GLRedundantTable.this.table, 0, 0L);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
                AnalyzerManager.updateView(GLPage.redundantViewID, selData);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    @Override
    protected List<TableInput> makeTableInput() {
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        List<GLRedundantDataType> dataList = GLDataManager.getInstance().getStatisticsDataManger().getRedundantTableData();
        if (dataList == null) {
            return null;
        }
        int size = dataList.size();
        int i = 0;
        while (i < size) {
            GLRedundantDataType data = dataList.get(i);
            ArrayList<String> text = new ArrayList<String>();
            if (!this.isFilterConditions(data)) {
                text.add(Integer.toString(data.getCallCount()));
                text.add(Formatter.toTimeFormat4(data.getElapsedTime()));
                text.add(data.getAPIName());
                text.add(GLConstantDefine.convertEnumValue(data.getArgs(), ",", null));
                DATableDataFormat tableData = new DATableDataFormat(i);
                ArrayList<Object> compareData = new ArrayList<Object>();
                int j = 0;
                while (j < text.size()) {
                    if (j == 1) {
                        compareData.add(String.valueOf(data.getElapsedTime()));
                    } else {
                        compareData.add(text.get(j));
                    }
                    ++j;
                }
                tableData.setData(compareData);
                TableInput tableInput = new TableInput();
                tableInput.setText(text);
                tableInput.setData(tableData);
                if (GLDataManager.getInstance().getSelectedAPIAtTable().equals(data.getAPIName())) {
                    tableInput.setSecondSelection(true);
                }
                input.add(tableInput);
            }
            ++i;
        }
        return input;
    }

    private boolean isFilterConditions(GLRedundantDataType data) {
        return data.getCallCount() < 2;
    }

    public void removeSelection() {
        this.table.removeAll();
        this.updateTable();
    }
}

