/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.dlog;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.CommunicatorUtils;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.dlog.DADlogData;
import org.tizen.dynamicanalyzer.ui.timeline.dlog.DLogDBTable;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.util.StringUtil;

public class DLogDataManager
extends PageDataManager {
    private static DLogDataManager instance = new DLogDataManager();
    private Thread dlogthread = null;
    private DLogDBTable dLogDBTable = null;
    private DBInserter dLogDBInserter = null;
    private DLogVersion dlog_ver = DLogVersion.notset;
    private static final String pattern_v2_string = "\\d{2}-\\d{2}\\s(\\d{2}:\\d{2}:\\d{2}\\.?\\d*)\\+?\\d*\\s+(\\d+)\\s+(\\d+)\\s+(V|D|I|W|E|F)\\s+(\\S+)\\s*\\:\\s+(.*)";
    private Pattern pattern_v2 = Pattern.compile("\\d{2}-\\d{2}\\s(\\d{2}:\\d{2}:\\d{2}\\.?\\d*)\\+?\\d*\\s+(\\d+)\\s+(\\d+)\\s+(V|D|I|W|E|F)\\s+(\\S+)\\s*\\:\\s+(.*)");
    private static final String pattern_v3_string = "\\d{2}-\\d{2}\\s(\\d{2}:\\d{2}:\\d{2}\\.?\\d*)\\+?\\d*\\s+(V|D|I|W|E|F)\\/(\\S+)\\s+\\(P\\s(\\d+),\\s+T\\s(\\d+)\\)\\:\\s+(.*)";
    private static final Pattern pattern_v3 = Pattern.compile("\\d{2}-\\d{2}\\s(\\d{2}:\\d{2}:\\d{2}\\.?\\d*)\\+?\\d*\\s+(V|D|I|W|E|F)\\/(\\S+)\\s+\\(P\\s(\\d+),\\s+T\\s(\\d+)\\)\\:\\s+(.*)");
    static boolean start = false;
    private boolean dlogKill = false;
    static String[] daStartTime = null;

    public DLogDataManager() {
        this.dLogDBTable = new DLogDBTable();
        this.dLogDBInserter = this.makeInserter(this.dLogDBTable);
    }

    public static DLogDataManager getInstance() {
        return instance;
    }

    public DLogDBTable getDBTable() {
        return this.dLogDBTable;
    }

    @Override
    protected void makeData(LogPackage pack) {
    }

    public boolean getDlogKill() {
        return this.dlogKill;
    }

    public void setDlogKill(boolean killed) {
        if (this.dlogthread != null) {
            this.dlogKill = killed;
        }
    }

    public boolean startDlog() {
        final DeviceInfo curDev = Global.getCurrentDeviceInfo();
        this.dlogKill = false;
        if (curDev == null) {
            return false;
        }
        String datecommand = "date +\"%H:%M:%S.%3N\"";
        CommunicatorUtils.execShellCommand(curDev.getIDevice(), datecommand, (IShellOutputReceiver)new MultiLineReceiver(){

            public void processNewLines(String[] appLines) {
                int i = 0;
                while (i < appLines.length) {
                    daStartTime = appLines;
                    ++i;
                }
            }
        });
        Global.getProject().setDAStartTime(daStartTime[0]);
        CommunicatorUtils.execShellCommand(curDev.getIDevice(), "/usr/bin/dlogutil -c");
        this.dlogthread = new Thread(new Runnable(){

            @Override
            public void run() {
                CommunicatorUtils.execShellCommand(curDev.getIDevice(), "/usr/bin/dlogutil -v threadtime", (IShellOutputReceiver)new MultiLineReceiver(){

                    public void processNewLines(String[] appLines) {
                        if (DLogDataManager.this.dlogKill) {
                            start = false;
                            try {
                                Logger.debug((Object)"Dlog receiver joined");
                                Thread.currentThread().join();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (appLines != null) {
                            DLogDataManager.this.makeDlogData(appLines);
                        }
                    }
                });
            }
        }, "DlogThread");
        this.dlogthread.start();
        start = true;
        return true;
    }

    public void stopDlog() {
        this.setDlogKill(true);
    }

    private void makeDlogData(String[] dlogs) {
        if (dlogs.length > 0) {
            ArrayList<List<Object>> mList = new ArrayList<List<Object>>();
            int i = 0;
            while (i < dlogs.length) {
                String dlogstring = dlogs[i];
                List<Object> dlog = this.splitDlog(dlogstring);
                if (dlog != null) {
                    mList.add(dlog);
                }
                ++i;
            }
            this.dLogDBInserter.pushData(mList);
        }
    }

    private List<Object> splitDlog(String dlog) {
        ArrayList<Object> splited = new ArrayList<Object>();
        if (this.dlog_ver == DLogVersion.notset) {
            if (dlog.matches(pattern_v2_string)) {
                this.dlog_ver = DLogVersion.v2;
            } else if (dlog.matches(pattern_v3_string)) {
                this.dlog_ver = DLogVersion.v3;
            }
        }
        String[] matches = null;
        if (this.dlog_ver == DLogVersion.v2) {
            matches = StringUtil.split((String)dlog, (Pattern)this.pattern_v2);
        } else if (this.dlog_ver == DLogVersion.v3) {
            matches = StringUtil.split((String)dlog, (Pattern)pattern_v3);
        }
        if (matches == null || matches.length != 6) {
            return null;
        }
        if (matches[5].contains("swap_start") && Global.getProject() != null) {
            Global.getProject().setDAStartTime(matches[0]);
        }
        if (this.dlog_ver == DLogVersion.v2) {
            splited.add(matches[0]);
            splited.add(matches[1]);
            splited.add(matches[2]);
            splited.add(matches[3]);
            splited.add(matches[4]);
            splited.add(matches[5]);
        } else if (this.dlog_ver == DLogVersion.v3) {
            splited.add(matches[0]);
            splited.add(matches[3]);
            splited.add(matches[4]);
            splited.add(matches[1]);
            splited.add(matches[2]);
            splited.add(matches[5]);
        }
        return splited;
    }

    public List<DADlogData> parserDlogs() {
        ArrayList<DADlogData> dlogList = new ArrayList<DADlogData>();
        SimpleDateFormat formatter = new SimpleDateFormat("hh:mm:ss.SSS");
        List<List<Object>> Dlogs = this.getDlogFromDB();
        String dastart = Global.getProject().getDAStartTime();
        if (dastart == null || dastart.isEmpty()) {
            dastart = (String)Dlogs.get(0).get(0);
        }
        Date DAStartTime = null;
        try {
            DAStartTime = formatter.parse(dastart);
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        for (List<Object> dlog : Dlogs) {
            DADlogData dlogData = new DADlogData();
            try {
                Date date = formatter.parse((String)dlog.get(0));
                dlogData.setSyncTime(DAStartTime);
                int compare = date.compareTo(DAStartTime);
                if (compare < 0) continue;
                long diffTime = date.getTime() * 1000L - DAStartTime.getTime() * 1000L;
                dlogData.setTime(Long.toString(diffTime));
                dlogData.setPid((String)dlog.get(1));
                dlogData.setTid((String)dlog.get(2));
                dlogData.setLevel((String)dlog.get(3));
                dlogData.setTag((String)dlog.get(4));
                dlogData.setMessage((String)dlog.get(5));
                dlogList.add(dlogData);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return dlogList;
    }

    public boolean isStart() {
        return start;
    }

    private List<List<Object>> getDlogFromDB() {
        List<List<Object>> dlogdatas = new ArrayList<List<Object>>();
        List<List<Object>> queryResult = this.dLogDBTable.selectAllColumnData(null);
        if (queryResult == null) {
            return dlogdatas;
        }
        dlogdatas = queryResult;
        return dlogdatas;
    }

    static enum DLogVersion {
        notset,
        v2,
        v3;

    }
}

