/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.toolbar.RemoteDeviceManager;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.widgets.animation.DAAnimationIcon;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;
import org.tizen.dynamicanalyzer.widgets.da.base.DATextBox;

public class RemoteDeviceDialog
extends DAMessageBox {
    private static final int WIDTH = 430;
    private static final int HEIGHT = 190;
    private static final int WIDTH_MARGIN = 20;
    private Composite mainContentsComp = null;
    private Composite buttonContentsComp = null;
    private RemoteDeviceDialog self = null;
    private DATextBox ipTextbox = null;
    private DATextBox portTextbox = null;
    private List<Image> progressImage = new ArrayList<Image>();
    private DAAnimationIcon progressIcon = null;
    private Label progressLabel = null;
    private Button connectButton = null;
    private Button cancelButton = null;
    private String address = null;
    private SelectionListener connectButtonListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            String ip = RemoteDeviceDialog.this.ipTextbox.getText();
            String port = RemoteDeviceDialog.this.portTextbox.getText();
            if (ip.isEmpty()) {
                return;
            }
            if (port.isEmpty()) {
                port = String.valueOf(26101);
            }
            RemoteDeviceDialog.this.address = String.valueOf(ip) + ":" + port;
            RemoteDeviceDialog.this.connectButton.setEnabled(false);
            RemoteDeviceDialog.this.connectButton.redraw();
            RemoteDeviceDialog.this.ipTextbox.setEnabled(false);
            RemoteDeviceDialog.this.portTextbox.setEnabled(false);
            RemoteDeviceDialog.this.progressIcon.setVisible(true);
            RemoteDeviceDialog.this.progressLabel.setVisible(true);
            RemoteDeviceDialog.this.progressIcon.start();
            Thread managerThread = new Thread((Runnable)new RemoteDeviceManager(RemoteDeviceDialog.this.self), RemoteDeviceManager.class.getSimpleName());
            managerThread.start();
        }
    };
    private SelectionListener cancelButtonListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            RemoteDeviceDialog.this.shell.close();
        }
    };
    private KeyListener textboxListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            boolean valid = RemoteDeviceDialog.this.checkValidPort(RemoteDeviceDialog.this.portTextbox.getText()) && RemoteDeviceDialog.this.checkValidIP(RemoteDeviceDialog.this.ipTextbox.getText());
            RemoteDeviceDialog.this.connectButton.setEnabled(valid);
            RemoteDeviceDialog.this.connectButton.redraw();
        }

        public void keyPressed(KeyEvent e) {
        }
    };

    public RemoteDeviceDialog(Shell parentShell) {
        super(parentShell);
        this.self = this;
        int dialogLocationX = this.shell.getParent().getLocation().x + (this.shell.getParent().getSize().x - 430) / 2;
        int dialogLocationY = this.shell.getParent().getLocation().y + (this.shell.getParent().getSize().y - 190) / 2;
        this.shell.setLocation(dialogLocationX, dialogLocationY);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(430, 190);
        this.shell.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        this.shell.setText(AnalyzerLabels.REMOTE_DEVICE);
        Composite marginTop = new Composite((Composite)this.shell, 0);
        this.mainContentsComp = new Composite((Composite)this.shell, 0);
        Composite marginMiddle = new Composite((Composite)this.shell, 0);
        this.buttonContentsComp = new Composite((Composite)this.shell, 0);
        marginTop.setLayout((Layout)new FormLayout());
        FormData marginCompData = new FormData();
        marginCompData.top = new FormAttachment(0, 0);
        marginCompData.left = new FormAttachment(0, 0);
        marginCompData.right = new FormAttachment(100, 0);
        marginCompData.bottom = new FormAttachment(0, 1);
        marginTop.setLayoutData((Object)marginCompData);
        marginTop.setBackground(ColorResources.DIALOG_TOP_LINE_COLOR);
        this.mainContentsComp.setLayout((Layout)new FormLayout());
        FormData scrollCompData = new FormData();
        scrollCompData.top = new FormAttachment((Control)marginTop, 0);
        scrollCompData.left = new FormAttachment(0, 0);
        scrollCompData.right = new FormAttachment(100, 0);
        scrollCompData.bottom = new FormAttachment(100, -61);
        this.mainContentsComp.setLayoutData((Object)scrollCompData);
        this.mainContentsComp.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        marginMiddle.setLayout((Layout)new FormLayout());
        marginCompData = new FormData();
        marginCompData.top = new FormAttachment((Control)this.mainContentsComp, 0);
        marginCompData.left = new FormAttachment(0, 0);
        marginCompData.right = new FormAttachment(100, 0);
        marginCompData.bottom = new FormAttachment(100, -60);
        marginMiddle.setLayoutData((Object)marginCompData);
        marginMiddle.setBackground(ColorResources.DIALOG_MIDDLE_LINE_COLOR);
        GridLayout grid = new GridLayout(4, false);
        grid.horizontalSpacing = 5;
        grid.marginWidth = 20;
        this.buttonContentsComp.setLayout((Layout)grid);
        FormData compData = new FormData();
        compData.top = new FormAttachment((Control)marginMiddle, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        this.buttonContentsComp.setLayoutData((Object)compData);
        this.buttonContentsComp.setBackground(ColorResources.WHITE);
        this.drawMainContents();
        this.drawProgress();
        this.drawButtons();
    }

    private void drawMainContents() {
        Composite contentGridComp = new Composite(this.mainContentsComp, 0);
        GridLayout grid = new GridLayout(2, false);
        grid.horizontalSpacing = 15;
        grid.marginWidth = 20;
        contentGridComp.setLayout((Layout)grid);
        Rectangle rect = this.shell.getClientArea();
        FormData formData = new FormData(rect.width, rect.height - 61);
        contentGridComp.setLayoutData((Object)formData);
        contentGridComp.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        Label ipText = new Label(contentGridComp, 16384);
        GridData data = new GridData(16384, 0x1000000, false, true);
        ipText.setLayoutData((Object)data);
        ipText.setForeground(ColorResources.BLACK);
        ipText.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        ipText.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        ipText.setText(String.valueOf(AnalyzerLabels.IP) + " :");
        this.ipTextbox = new DATextBox(contentGridComp, 4);
        data = new GridData(260);
        data.grabExcessHorizontalSpace = true;
        this.ipTextbox.setLayoutData((Object)data);
        this.ipTextbox.setBackground(ColorResources.WHITE);
        this.ipTextbox.getControl().addKeyListener(this.textboxListener);
        this.ipTextbox.getControl().addVerifyListener((VerifyListener)new TextBoxVerifyListener("0123456789."));
        Label portText = new Label(contentGridComp, 16384);
        data = new GridData(16384, 0x1000000, false, true);
        portText.setLayoutData((Object)data);
        portText.setForeground(ColorResources.BLACK);
        portText.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        portText.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        portText.setText(String.valueOf(AnalyzerLabels.PORT) + " :");
        this.portTextbox = new DATextBox(contentGridComp, 4);
        data = new GridData(260);
        data.grabExcessHorizontalSpace = true;
        this.portTextbox.setLayoutData((Object)data);
        this.portTextbox.setBackground(ColorResources.WHITE);
        this.portTextbox.getControl().addKeyListener(this.textboxListener);
        this.portTextbox.getControl().addVerifyListener((VerifyListener)new TextBoxVerifyListener("0123456789"));
    }

    private void drawButtons() {
        this.cancelButton = new Button(this.buttonContentsComp, 0);
        GridData buttonData = new GridData(100, 30);
        buttonData.verticalAlignment = 0x1000000;
        buttonData.horizontalAlignment = 0x1000000;
        this.cancelButton.setLayoutData((Object)buttonData);
        this.cancelButton.setText(WidgetLabels.CANCEL);
        this.cancelButton.addSelectionListener(this.cancelButtonListener);
        this.connectButton = new Button(this.buttonContentsComp, 0);
        buttonData = new GridData(100, 30);
        buttonData.verticalAlignment = 0x1000000;
        buttonData.horizontalAlignment = 0x1000000;
        this.connectButton.setLayoutData((Object)buttonData);
        this.connectButton.setText(WidgetLabels.OK);
        this.connectButton.addSelectionListener(this.connectButtonListener);
        this.connectButton.setEnabled(false);
    }

    private void drawProgress() {
        this.progressImage.add(ImageResources.STOP_PROGRESS_LOADING_01);
        this.progressImage.add(ImageResources.STOP_PROGRESS_LOADING_02);
        this.progressImage.add(ImageResources.STOP_PROGRESS_LOADING_03);
        this.progressImage.add(ImageResources.STOP_PROGRESS_LOADING_04);
        this.progressImage.add(ImageResources.STOP_PROGRESS_LOADING_05);
        this.progressImage.add(ImageResources.STOP_PROGRESS_LOADING_06);
        this.progressImage.add(ImageResources.STOP_PROGRESS_LOADING_07);
        this.progressImage.add(ImageResources.STOP_PROGRESS_LOADING_08);
        this.progressIcon = new DAAnimationIcon(this.buttonContentsComp, 0, this.progressImage);
        GridData data = new GridData(24, 24);
        data.verticalAlignment = 0x1000000;
        data.horizontalAlignment = 0x1000000;
        data.grabExcessVerticalSpace = true;
        this.progressIcon.setLayoutData((Object)data);
        this.progressIcon.setVisible(false);
        this.progressLabel = new Label(this.buttonContentsComp, 0x40000000);
        data = new GridData(16384, 0x1000000, true, false);
        this.progressLabel.setLayoutData((Object)data);
        this.progressLabel.setBackground(ColorResources.WHITE);
        this.progressLabel.setAlignment(16384);
        this.progressLabel.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        this.progressLabel.setForeground(ColorResources.BLACK);
        this.progressLabel.setText(AnalyzerLabels.CONNECTING);
        this.progressLabel.setVisible(false);
    }

    private boolean checkValidIP(String ipaddr) {
        String[] splitstr = ipaddr.split("\\.");
        if (splitstr == null || splitstr.length != 4) {
            return false;
        }
        int i = 0;
        while (i < 4) {
            if (!CommonUtil.isNumeric((String)splitstr[i])) {
                return false;
            }
            try {
                int classnum = Integer.parseInt(splitstr[i]);
                if (classnum < 0 || classnum > 255) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkValidPort(String port) {
        if (port.isEmpty()) {
            return true;
        }
        if (!CommonUtil.isNumeric((String)port)) {
            return false;
        }
        int portnum = -1;
        try {
            portnum = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return portnum >= 1 && portnum <= 65535;
    }

    public String getAddress() {
        return this.address;
    }

    public void setConnectionResult(boolean bresult) {
        if (bresult) {
            this.setResult(1);
            this.shell.close();
        } else {
            this.address = null;
            this.progressIcon.setVisible(false);
            this.progressLabel.setVisible(false);
            this.connectButton.setEnabled(true);
            this.connectButton.redraw();
            this.ipTextbox.setEnabled(true);
            this.portTextbox.setEnabled(true);
        }
    }

    private class TextBoxVerifyListener
    implements VerifyListener {
        private String allowedChars = "";

        public TextBoxVerifyListener(String allowedChars) {
            this.allowedChars = allowedChars;
        }

        public void verifyText(VerifyEvent e) {
            int i = 0;
            while (i < e.text.length()) {
                char ch = e.text.charAt(i);
                if (this.allowedChars.indexOf(ch) < 0) {
                    e.doit = false;
                    return;
                }
                ++i;
            }
        }
    }
}

