/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.utils;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;

public class RpmUtil {
    public static final String RPM_EXT = ".rpm";
    public static final String DEVEL = "devel";
    public static final String DEBUG = "debug-";
    public static final String DEBUGINFO = "debuginfo";
    public static final String DEBUGSOURCE = "debugsource";

    public static boolean extractRpm(String targetpath, String rpmpath) {
        boolean bret = false;
        if (rpmpath != null) {
            ArrayList errorlines;
            ArrayList outputlines;
            String toolPath = PathManager.getDebugInfoScript();
            String debugOption = RpmUtil.getDebugInfoOption();
            String[] command = debugOption == null || debugOption.isEmpty() ? new String[]{toolPath, "-d", targetpath, rpmpath} : new String[]{toolPath, debugOption, "-d", targetpath, rpmpath};
            if (CommonUtil.executeCommand((String[])command, outputlines = new ArrayList(), errorlines = new ArrayList())) {
                int linecount = outputlines.size();
                if (linecount < 2) {
                    Logger.debug((Object)"debug info file extract failed...");
                    if (errorlines.size() != 0) {
                        Logger.debug(errorlines.get(0));
                    }
                } else {
                    bret = true;
                }
            }
        }
        return bret;
    }

    public static List<String> getFileListInRpm(String rpmpath) {
        ArrayList<String> ret = null;
        if (rpmpath != null) {
            ArrayList outputlines;
            String toolPath = PathManager.getDebugInfoScript();
            String[] command = new String[]{toolPath, RpmUtil.getDebugInfoOption(), "-l", rpmpath};
            if (CommonUtil.executeCommand((String[])command, outputlines = new ArrayList(), null)) {
                ret = new ArrayList<String>();
                for (String line : outputlines) {
                    if (!line.startsWith("./")) continue;
                    line = line.substring(1);
                    ret.add(line);
                }
            }
        }
        return ret;
    }

    public static String getDebugInfoOption() {
        String option = null;
        if (CommonUtil.isLinux()) {
            option = "-u";
        } else if (CommonUtil.isMac()) {
            option = "-m";
        } else if (CommonUtil.isWin()) {
            option = "";
        } else {
            Logger.error((Object)"Unknown host OS!\n");
        }
        return option;
    }
}

