/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug.tools;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.debug.DebugBaseType;
import org.eclipse.cdt.utils.debug.DebugParameterKind;
import org.eclipse.cdt.utils.debug.DebugType;
import org.eclipse.cdt.utils.debug.DebugVariableKind;
import org.eclipse.cdt.utils.debug.IDebugEntryRequestor;
import org.eclipse.cdt.utils.debug.dwarf.Dwarf;
import org.eclipse.cdt.utils.debug.stabs.Stabs;
import org.eclipse.cdt.utils.elf.Elf;

public class DebugDump
implements IDebugEntryRequestor {
    BufferedWriter bwriter;
    int bracket;
    int paramCount = -1;
    String currentCU;

    public DebugDump(OutputStream stream) {
        this.bwriter = new BufferedWriter(new OutputStreamWriter(stream));
    }

    void parse(String file) throws IOException {
        Elf elf = new Elf(file);
        this.parse(elf);
        elf.dispose();
    }

    void parse(Elf elf) throws IOException {
        Elf.Attribute attribute = elf.getAttributes();
        int type = attribute.getDebugType();
        if (type == 1) {
            Stabs stabs = new Stabs(elf);
            stabs.parse(this);
        } else if (type == 2) {
            Dwarf dwarf = new Dwarf(elf);
            dwarf.parse(this);
        } else {
            throw new IOException(CCorePlugin.getResourceString("Util.unknownFormat"));
        }
        this.bwriter.flush();
    }

    void write(String s) {
        try {
            this.bwriter.write(s, 0, s.length());
        }
        catch (IOException iOException) {}
    }

    void newLine() {
        try {
            this.bwriter.newLine();
        }
        catch (IOException iOException) {}
    }

    String printTabs() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.bracket) {
            sb.append('\t');
            ++i;
        }
        return sb.toString();
    }

    public void enterCompilationUnit(String name, long address) {
        this.write("/* Enter Compilation Unit " + name + " address " + Long.toHexString(address) + " */");
        this.newLine();
        this.currentCU = name;
    }

    public void exitCompilationUnit(long address) {
        this.write("/* Exit Compilation Unit ");
        if (this.currentCU != null) {
            this.write(String.valueOf(this.currentCU) + " address " + Long.toHexString(address));
        }
        this.write(" */");
        this.newLine();
        this.newLine();
        this.currentCU = null;
    }

    public void enterInclude(String name) {
        this.write("#include \"" + name + "\" ");
        this.write("/* Enter Include */");
        this.newLine();
    }

    public void exitInclude() {
    }

    public void enterFunction(String name, DebugType type, boolean isGlobal, long address) {
        this.write("/* Func:" + name + " address " + Long.toHexString(address) + " */");
        this.newLine();
        if (!isGlobal) {
            this.write("static ");
        }
        this.write(String.valueOf(type.toString()) + " " + name + "(");
        this.paramCount = 0;
    }

    public void exitFunction(long address) {
        if (this.paramCount > -1) {
            this.paramCount = -1;
            this.write(")");
            this.newLine();
            this.write("{");
            this.newLine();
            ++this.bracket;
        }
        while (this.bracket > 0) {
            this.write("}");
            --this.bracket;
        }
        this.write(" /* Exit Func address " + Long.toHexString(address) + " */");
        this.newLine();
        this.newLine();
    }

    public void enterCodeBlock(long offset) {
        if (this.paramCount > -1) {
            this.paramCount = -1;
            this.write(")");
            this.newLine();
        }
        this.write(String.valueOf(this.printTabs()) + "{ " + "/* " + offset + " */");
        this.newLine();
        ++this.bracket;
    }

    public void exitCodeBlock(long offset) {
        --this.bracket;
        this.write(String.valueOf(this.printTabs()) + "} " + "/* " + offset + " */");
        this.newLine();
    }

    public void acceptStatement(int line, long address) {
        if (this.paramCount > -1) {
            this.write(")");
            this.newLine();
            this.write("{");
            this.newLine();
            ++this.bracket;
            this.paramCount = -1;
        }
        this.write(String.valueOf(this.printTabs()) + "/* line " + line + " address " + address + " */");
        this.newLine();
    }

    public void acceptIntegerConst(String name, int value) {
        this.write("const int " + name + " = " + value + ";");
        this.newLine();
    }

    public void acceptFloatConst(String name, double value) {
        this.write("const float " + name + " = " + value + ";");
        this.newLine();
    }

    public void acceptTypeConst(String name, DebugType type, int value) {
        this.write("const " + type.toString() + " " + name + " = " + value + ";");
        this.newLine();
    }

    public void acceptParameter(String name, DebugType type, DebugParameterKind kind, long offset) {
        if (this.paramCount > 0) {
            this.write(", ");
        }
        ++this.paramCount;
        this.write(String.valueOf(type.toString()) + " " + name + "/* " + offset + " */");
    }

    public void acceptVariable(String name, DebugType type, DebugVariableKind kind, long address) {
        this.write(String.valueOf(this.printTabs()) + type.toString() + " " + name + ";" + "/* " + Long.toHexString(address) + " */");
        this.newLine();
    }

    public void acceptCaughtException(String name, DebugType type, long address) {
    }

    public void acceptTypeDef(String name, DebugType type) {
        if (!name.equals(type.toString())) {
            this.write("typedef " + type.toString() + " " + name + ";");
            this.newLine();
        } else if (type instanceof DebugBaseType) {
            DebugBaseType baseType = (DebugBaseType)type;
            this.write("/* " + name + ": " + baseType.sizeof() + " bytes */");
            this.newLine();
        }
    }

    public static void main(String[] args) {
        try {
            DebugDump dump = new DebugDump(System.out);
            dump.parse(args[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

