/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.callback;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.callback.IExecutionCallback;

public class ExecutionCallbackManager {
    private static Map<String, List<IExecutionCallback>> callbackMap = new HashMap<String, List<IExecutionCallback>>();
    public static final String WINDOWADVISOR_POSTWINDOWOPEN = "WindowAdvisor.postWindowOpen";
    public static final String WINDOWADVISOR_PREWINDOWCLOSE = "WindowAdvisor.preWindowShellClose";

    public static boolean createCallbackList(String listname) {
        boolean ret = false;
        List<IExecutionCallback> clist = callbackMap.get(listname);
        if (clist == null) {
            clist = new ArrayList<IExecutionCallback>();
            callbackMap.put(listname, clist);
            ret = true;
        }
        return ret;
    }

    public static boolean registerCallback(String key, IExecutionCallback callback) {
        boolean ret = false;
        List<IExecutionCallback> clist = callbackMap.get(key);
        if (clist != null) {
            clist.add(callback);
            ret = true;
        }
        return ret;
    }

    public static void executeCallback(String key) {
        List<IExecutionCallback> clist = callbackMap.get(key);
        if (clist != null) {
            int size = clist.size();
            int i = 0;
            while (i < size) {
                IExecutionCallback cb = clist.get(i);
                cb.execute();
                ++i;
            }
        }
    }

    public static void executeCallback(String key, String[] msg) {
        List<IExecutionCallback> clist = callbackMap.get(key);
        if (clist != null) {
            int size = clist.size();
            int i = 0;
            while (i < size) {
                IExecutionCallback cb = clist.get(i);
                cb.execute(msg);
                ++i;
            }
        }
    }
}

