/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.manager;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.tizen.dynamicanalyzer.cli.manager.TracingProcessContext;
import org.tizen.dynamicanalyzer.cli.tracing.TracingArguments;
import org.tizen.dynamicanalyzer.cli.tracing.TracingArgumentsParser;
import org.tizen.dynamicanalyzer.cli.tracing.TracingProcess;
import org.tizen.dynamicanalyzer.cli.utils.Communicator;
import org.tizen.dynamicanalyzer.cli.utils.ManagerCommunicationProcessor;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;

public class TracingProcessManager {
    private static final String TRACING_PROCESS_CANONICAL_NAME = TracingProcess.class.getCanonicalName();
    private static final String TRACING_PROCESS_LIBRARY_PATH = TracingProcessManager.getTracingProcessLibraryPath();
    private TracingProcessContext ctx;
    private Process tracingProcess;
    private volatile Thread monitoringThread;
    private volatile long tracingTime;
    private ManagerCommunicationProcessor communicationProcessor;
    private Thread commThread;

    private static String getTracingProcessLibraryPath() {
        try {
            return new File(TracingProcess.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getAbsolutePath();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static TracingProcessManager createTracingProcess(TracingArguments args) throws IOException {
        String currentClasspath = System.getProperty("java.class.path");
        ArrayList<String> commandLine = new ArrayList<String>(Arrays.asList("java", "-classpath", TRACING_PROCESS_LIBRARY_PATH + CommonUtil.CLASSPATH_SEPARATOR + currentClasspath, TRACING_PROCESS_CANONICAL_NAME));
        if (args.getOutput() == null) {
            String output = PathManager.DA_SAVE_PATH + File.separator + Project.constructSaveName((String)args.getApplicationID(), (Date)new Date());
            args.setOutput(output);
        }
        ServerSocket ss = TracingProcessManager.getServerSocket();
        commandLine.add(Integer.toString(ss.getLocalPort()));
        commandLine.addAll(Arrays.asList(TracingArgumentsParser.toStringArray(args)));
        ProcessBuilder pBuilder = new ProcessBuilder(commandLine).redirectInput(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT);
        Process process = pBuilder.start();
        TracingProcessManager tpManager = new TracingProcessManager(args, process, ss);
        if (!tpManager.communicationProcessor.isInitSuccessful()) {
            tpManager.forceStopTracing();
            throw new IOException("Tracing process was not started successfully");
        }
        return tpManager;
    }

    private static ServerSocket getServerSocket() {
        while (true) {
            try {
                ServerSocket ss = new ServerSocket(0);
                return ss;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    private void startMonitoring() {
        this.monitoringThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TracingProcessManager.this.waitForCompletion();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, "wait-completion-thread-" + this.ctx.getArgs().getDevice());
        this.monitoringThread.setDaemon(true);
        this.monitoringThread.start();
    }

    private TracingProcessManager(TracingArguments args, Process process, ServerSocket ss) {
        this.ctx = new TracingProcessContext(args);
        this.tracingProcess = process;
        try {
            Socket socket = ss.accept();
            ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
            oos.flush();
            ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
            this.communicationProcessor = new ManagerCommunicationProcessor(new Communicator(ois, oos), this.ctx);
            this.commThread = new Thread((Runnable)this.communicationProcessor, "Communication thread");
            this.commThread.start();
            ss.close();
        }
        catch (IOException e1) {
            Logger.error((Object)"Failed to establish communication between TracingProcessManager and TracingProcess");
        }
        this.startMonitoring();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion() throws InterruptedException {
        int errCode = this.tracingProcess.waitFor();
        TracingProcessManager tracingProcessManager = this;
        synchronized (tracingProcessManager) {
            this.ctx.finishContext(errCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTracing() throws InterruptedException, IOException {
        TracingProcessManager tracingProcessManager = this;
        synchronized (tracingProcessManager) {
            if (this.ctx.isFinished()) {
                return;
            }
            this.communicationProcessor.stopTracing();
        }
        if (this.tracingTime == 0L) {
            this.tracingTime = this.communicationProcessor.getTracingTime();
        }
        this.communicationProcessor.closeConnection();
        this.waitForCompletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopTracing(long timeoutMs) throws InterruptedException {
        TracingProcessManager tracingProcessManager = this;
        synchronized (tracingProcessManager) {
            if (this.ctx.isFinished()) {
                return true;
            }
        }
        Thread workingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TracingProcessManager.this.stopTracing();
                }
                catch (IOException | InterruptedException exception) {
                    // empty catch block
                }
            }
        }, "stop-tracing-thread-" + this.ctx.getArgs().getDevice());
        workingThread.start();
        workingThread.join(timeoutMs);
        if (workingThread.isAlive()) {
            workingThread.interrupt();
        }
        TracingProcessManager tracingProcessManager2 = this;
        synchronized (tracingProcessManager2) {
            return this.ctx.isFinished();
        }
    }

    public long getTracingTime() {
        if (this.tracingTime == 0L) {
            this.tracingTime = this.communicationProcessor.getTracingTime();
        }
        return this.tracingTime;
    }

    public synchronized void forceStopTracing() {
        if (this.ctx.isFinished()) {
            return;
        }
        this.tracingProcess.destroy();
        try {
            this.waitForCompletion();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"Something goes wrong while destroying tracing process.");
        }
    }

    public synchronized TracingProcessContext getContext() {
        return this.ctx.clone();
    }

    public synchronized boolean isFinished() {
        return this.ctx.isFinished();
    }
}

