/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CPPNamespaceAlias
extends PlatformObject
implements ICPPNamespaceAlias,
ICPPInternalBinding {
    private ICPPNamespace namespace;
    private IASTName alias;

    public CPPNamespaceAlias(IASTName aliasName, ICPPNamespace namespace) {
        this.namespace = namespace;
        this.alias = aliasName;
    }

    public ICPPNamespaceScope getNamespaceScope() {
        return this.namespace.getNamespaceScope();
    }

    public IBinding getBinding() {
        return this.namespace;
    }

    public String getName() {
        return new String(this.getNameCharArray());
    }

    public char[] getNameCharArray() {
        return this.alias.getSimpleID();
    }

    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.alias);
    }

    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    public IASTNode[] getDeclarations() {
        return null;
    }

    public IASTNode getDefinition() {
        return this.alias;
    }

    public void addDefinition(IASTNode node) {
    }

    public void addDeclaration(IASTNode node) {
    }

    public IBinding[] getMemberBindings() {
        return this.namespace.getMemberBindings();
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public IBinding getOwner() {
        return CPPVisitor.findDeclarationOwner(this.alias, false);
    }

    public boolean isInline() {
        return false;
    }
}

