/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerList;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArraySet;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPArrayType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassTemplatePartialSpecializationSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPConstructorInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPConstructorSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPConstructorTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFieldSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethodInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethodSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethodTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameterPackType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateNonTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTypedefSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPASTInternalTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInstanceCache;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.InitializerListType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TemplateArgumentDeduction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.UniqueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPPTemplates {
    private static final int PACK_SIZE_DEFER = -1;
    private static final int PACK_SIZE_FAIL = -2;
    private static final int PACK_SIZE_NOT_FOUND = Integer.MAX_VALUE;
    private static final ICPPFunction[] NO_FUNCTIONS = new ICPPFunction[0];

    public static IBinding instantiate(ICPPClassTemplate template, ICPPTemplateArgument[] args, boolean isDef) {
        try {
            ICPPTemplateInstance prim;
            ICPPTemplateArgument[] arguments = SemanticUtil.getSimplifiedArguments(args);
            arguments = CPPTemplates.addDefaultArguments(template, arguments);
            if (arguments == null) {
                return CPPTemplates.createProblem(template, 15);
            }
            if (template instanceof ICPPTemplateTemplateParameter || CPPTemplates.hasDependentArgument(arguments)) {
                return CPPTemplates.deferredInstance(template, arguments);
            }
            if (template instanceof ICPPClassTemplatePartialSpecialization) {
                return CPPTemplates.instantiatePartialSpecialization((ICPPClassTemplatePartialSpecialization)template, arguments, isDef, null);
            }
            ICPPTemplateParameter[] parameters = template.getTemplateParameters();
            int numArgs = arguments.length;
            int numParams = parameters.length;
            int length = Math.max(numArgs, numParams);
            CPPTemplateParameterMap map = new CPPTemplateParameterMap(numParams);
            boolean isPack = false;
            ICPPTemplateParameter param = null;
            int i = 0;
            while (i < length) {
                if (!isPack || param == null) {
                    if (i < numParams) {
                        param = parameters[i];
                        isPack = param.isParameterPack();
                    } else {
                        return CPPTemplates.createProblem(template, 15);
                    }
                }
                if (i < numArgs) {
                    ICPPTemplateArgument arg = arguments[i];
                    ICPPTemplateArgument newArg = CPPTemplates.matchTemplateParameterAndArgument(param, arg, map);
                    if (newArg == null) {
                        return CPPTemplates.createProblem(template, 15);
                    }
                    if (newArg != arg) {
                        if (arguments == args) {
                            arguments = (ICPPTemplateArgument[])args.clone();
                        }
                        arguments[i] = newArg;
                    }
                    if (!isPack) {
                        map.put(param, newArg);
                    }
                } else assert (isPack);
                ++i;
            }
            if (isPack) {
                int packOffset = numParams - 1;
                int packSize = numArgs - packOffset;
                ICPPTemplateArgument[] pack = new ICPPTemplateArgument[packSize];
                System.arraycopy(arguments, packOffset, pack, 0, packSize);
                map.put(param, pack);
            }
            if ((prim = CPPTemplates.getInstance(template, arguments, isDef)) != null && prim.isExplicitSpecialization()) {
                return prim;
            }
            IBinding result = CPPTemplates.selectSpecialization(template, arguments, isDef);
            if (result != null) {
                return result;
            }
            return CPPTemplates.instantiatePrimaryTemplate(template, arguments, map, isDef);
        }
        catch (DOMException e) {
            return e.getProblem();
        }
    }

    private static IBinding createProblem(ICPPClassTemplate template, int id) {
        CPPASTName node = new CPPASTName(template.getNameCharArray());
        return new ProblemBinding((IASTNode)node, id, template.getNameCharArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static IBinding isUsedInClassTemplateScope(ICPPClassTemplate ct, IASTName name) {
        try {
            IASTInternalScope internalScope;
            IASTName start = name;
            ICPPASTFunctionDefinition func = CPPVisitor.findEnclosingFunctionDefinition(name);
            if (func != null) {
                start = ASTQueries.findInnermostDeclarator(func.getDeclarator()).getName();
                start = start.getLastName();
            }
            IScope scope = CPPVisitor.getContainingScope(start);
            do {
                ICPPClassSpecialization specialization;
                IName scopeName;
                if (!(scope instanceof IASTInternalScope)) {
                    return null;
                }
                if (scope instanceof ISemanticProblem) {
                    return null;
                }
                internalScope = (IASTInternalScope)scope;
                if (!(scope instanceof ICPPClassScope) || !((scopeName = internalScope.getScopeName()) instanceof IASTName)) continue;
                IBinding b = ((IASTName)scopeName).resolveBinding();
                if (b instanceof IType && ct.isSameType((IType)((Object)b))) {
                    return CPPTemplates.instantiateWithinClassTemplate(ct);
                }
                if (b instanceof ICPPClassTemplatePartialSpecialization) {
                    ICPPClassTemplatePartialSpecialization pspec = (ICPPClassTemplatePartialSpecialization)b;
                    if (!ct.isSameType(pspec.getPrimaryClassTemplate())) continue;
                    return CPPTemplates.instantiateWithinClassTemplate(pspec);
                }
                if (!(b instanceof ICPPClassSpecialization) || !ct.isSameType((specialization = (ICPPClassSpecialization)b).getSpecializedBinding())) continue;
                return specialization;
            } while ((scope = CPPVisitor.getContainingScope(internalScope.getPhysicalNode())) != internalScope);
            return null;
        }
        catch (DOMException dOMException) {}
        return null;
    }

    private static IBinding instantiateFunctionTemplate(ICPPFunctionTemplate template, ICPPTemplateArgument[] arguments, CPPTemplateParameterMap map) throws DOMException {
        ICPPTemplateInstance instance = CPPTemplates.getInstance(template, arguments, false);
        if (instance != null) {
            return instance;
        }
        IBinding owner = template.getOwner();
        instance = CPPTemplates.createInstance(owner, template, map, arguments);
        CPPTemplates.addInstance(template, arguments, instance);
        return instance;
    }

    private static IBinding instantiatePartialSpecialization(ICPPClassTemplatePartialSpecialization partialSpec, ICPPTemplateArgument[] args, boolean isDef, CPPTemplateParameterMap tpMap) throws DOMException {
        ICPPTemplateInstance instance = CPPTemplates.getInstance(partialSpec, args, isDef);
        if (instance != null) {
            return instance;
        }
        if (tpMap == null) {
            tpMap = new CPPTemplateParameterMap(args.length);
            if (!TemplateArgumentDeduction.fromTemplateArguments(partialSpec.getTemplateParameters(), partialSpec.getTemplateArguments(), args, tpMap)) {
                return null;
            }
        }
        instance = CPPTemplates.createInstance(partialSpec.getOwner(), partialSpec, tpMap, args);
        CPPTemplates.addInstance(partialSpec, args, instance);
        return instance;
    }

    private static IBinding instantiatePrimaryTemplate(ICPPClassTemplate template, ICPPTemplateArgument[] arguments, CPPTemplateParameterMap map, boolean isDef) throws DOMException {
        assert (!(template instanceof ICPPClassTemplatePartialSpecialization));
        ICPPTemplateInstance instance = CPPTemplates.getInstance(template, arguments, isDef);
        if (instance != null) {
            return instance;
        }
        IBinding owner = template.getOwner();
        instance = CPPTemplates.createInstance(owner, template, map, arguments);
        CPPTemplates.addInstance(template, arguments, instance);
        return instance;
    }

    private static ICPPTemplateInstance getInstance(ICPPTemplateDefinition template, ICPPTemplateArgument[] args, boolean forDefinition) {
        if (template instanceof ICPPInstanceCache) {
            ICPPTemplateInstance result = ((ICPPInstanceCache)((Object)template)).getInstance(args);
            if (forDefinition && result instanceof IIndexBinding) {
                return null;
            }
            return result;
        }
        return null;
    }

    private static void addInstance(ICPPTemplateDefinition template, ICPPTemplateArgument[] args, ICPPTemplateInstance instance) {
        if (template instanceof ICPPInstanceCache) {
            ((ICPPInstanceCache)((Object)template)).addInstance(args, instance);
        }
    }

    private static IBinding deferredInstance(ICPPClassTemplate template, ICPPTemplateArgument[] arguments) throws DOMException {
        ICPPTemplateInstance instance = CPPTemplates.getInstance(template, arguments, false);
        if (instance != null) {
            return instance;
        }
        instance = new CPPDeferredClassInstance(template, arguments);
        CPPTemplates.addInstance(template, arguments, instance);
        return instance;
    }

    private static ICPPTemplateArgument[] addDefaultArguments(ICPPClassTemplate template, ICPPTemplateArgument[] arguments) throws DOMException {
        int argCount;
        if (template instanceof ICPPClassTemplatePartialSpecialization) {
            return arguments;
        }
        boolean havePackExpansion = false;
        int i = 0;
        while (i < arguments.length) {
            ICPPTemplateArgument arg = arguments[i];
            if (arg.isPackExpansion()) {
                if (i != arguments.length - 1) {
                    return arguments;
                }
                havePackExpansion = true;
            }
            ++i;
        }
        ICPPTemplateParameter[] tpars = template.getTemplateParameters();
        int tparCount = tpars.length;
        if (tparCount == (argCount = arguments.length)) {
            return arguments;
        }
        if (tparCount == 0) {
            return null;
        }
        if (tparCount < argCount) {
            if (tpars[tparCount - 1].isParameterPack()) {
                return arguments;
            }
            if (havePackExpansion && tparCount + 1 == argCount) {
                return arguments;
            }
            return null;
        }
        if (havePackExpansion) {
            return arguments;
        }
        if (tpars[tparCount - 1].isParameterPack()) {
            --tparCount;
        }
        if (tparCount == argCount) {
            return arguments;
        }
        ICPPTemplateArgument[] completeArgs = new ICPPTemplateArgument[tparCount];
        CPPTemplateParameterMap map = new CPPTemplateParameterMap(tparCount);
        int i2 = 0;
        while (i2 < tparCount) {
            ICPPTemplateArgument arg;
            ICPPTemplateParameter tpar = tpars[i2];
            if (tpar.isParameterPack()) {
                return null;
            }
            if (i2 < argCount) {
                arg = arguments[i2];
            } else {
                ICPPTemplateArgument defaultArg = tpar.getDefaultValue();
                if (defaultArg == null && template instanceof ICPPInternalClassTemplate) {
                    defaultArg = ((ICPPInternalClassTemplate)((Object)template)).getDefaultArgFromIndex(i2);
                }
                if (defaultArg == null) {
                    return null;
                }
                arg = CPPTemplates.instantiateArgument(defaultArg, map, -1, null);
                if (!CPPTemplates.isValidArgument(arg = SemanticUtil.getSimplifiedArgument(arg))) {
                    return null;
                }
            }
            map.put(tpar, arg);
            completeArgs[i2] = arg;
            ++i2;
        }
        return completeArgs;
    }

    public static ICPPClassType instantiateWithinClassTemplate(ICPPClassTemplate template) throws DOMException {
        ICPPTemplateArgument[] args;
        ICPPTemplateInstance di = template.asDeferredInstance();
        if (di instanceof ICPPClassType) {
            return (ICPPClassType)((Object)di);
        }
        if (template instanceof ICPPClassTemplatePartialSpecialization) {
            args = ((ICPPClassTemplatePartialSpecialization)template).getTemplateArguments();
        } else {
            ICPPTemplateParameter[] templateParameters = template.getTemplateParameters();
            args = CPPTemplates.templateParametersAsArguments(templateParameters);
        }
        IBinding result = CPPTemplates.deferredInstance(template, args);
        if (result instanceof ICPPClassType) {
            return (ICPPClassType)result;
        }
        return template;
    }

    public static ICPPTemplateArgument[] templateParametersAsArguments(ICPPTemplateParameter[] templateParameters) throws DOMException {
        ICPPTemplateArgument[] args = new ICPPTemplateArgument[templateParameters.length];
        int i = 0;
        while (i < templateParameters.length) {
            ICPPTemplateParameter tp = templateParameters[i];
            if (tp instanceof IType) {
                IType t = (IType)((Object)tp);
                if (tp.isParameterPack()) {
                    t = new CPPParameterPackType(t);
                }
                args[i] = new CPPTemplateArgument(t);
            } else if (tp instanceof ICPPTemplateNonTypeParameter) {
                ICPPTemplateNonTypeParameter nttp = (ICPPTemplateNonTypeParameter)tp;
                args[i] = new CPPTemplateArgument(Value.create(nttp), nttp.getType());
            } else assert (false);
            ++i;
        }
        return args;
    }

    public static IASTName getTemplateParameterName(ICPPASTTemplateParameter param) {
        if (param instanceof ICPPASTSimpleTypeTemplateParameter) {
            return ((ICPPASTSimpleTypeTemplateParameter)param).getName();
        }
        if (param instanceof ICPPASTTemplatedTypeTemplateParameter) {
            return ((ICPPASTTemplatedTypeTemplateParameter)param).getName();
        }
        if (param instanceof ICPPASTParameterDeclaration) {
            return ASTQueries.findInnermostDeclarator(((ICPPASTParameterDeclaration)param).getDeclarator()).getName();
        }
        return null;
    }

    public static ICPPTemplateDefinition getContainingTemplate(ICPPASTTemplateParameter param) {
        IASTNode parent = param.getParent();
        IBinding binding = null;
        if (parent instanceof ICPPASTTemplateDeclaration) {
            Object[] templates = new ICPPASTTemplateDeclaration[]{(ICPPASTTemplateDeclaration)parent};
            while (parent.getParent() instanceof ICPPASTTemplateDeclaration) {
                parent = parent.getParent();
                templates = (ICPPASTTemplateDeclaration[])ArrayUtil.append(ICPPASTTemplateDeclaration.class, templates, parent);
            }
            templates = (ICPPASTTemplateDeclaration[])ArrayUtil.trim(ICPPASTTemplateDeclaration.class, templates);
            Object templateDeclaration = templates[0];
            IASTDeclaration decl = templateDeclaration.getDeclaration();
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            IASTName name = null;
            if (decl instanceof IASTSimpleDeclaration) {
                IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)decl;
                IASTDeclarator[] dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                if (dtors.length == 0) {
                    IASTDeclSpecifier spec = simpleDecl.getDeclSpecifier();
                    if (spec instanceof ICPPASTCompositeTypeSpecifier) {
                        name = ((ICPPASTCompositeTypeSpecifier)spec).getName();
                    } else if (spec instanceof ICPPASTElaboratedTypeSpecifier) {
                        name = ((ICPPASTElaboratedTypeSpecifier)spec).getName();
                    }
                } else {
                    IASTDeclarator dtor = dtors[0];
                    dtor = ASTQueries.findInnermostDeclarator(dtor);
                    name = dtor.getName();
                }
            } else if (decl instanceof IASTFunctionDefinition) {
                IASTDeclarator dtor = ((IASTFunctionDefinition)decl).getDeclarator();
                dtor = ASTQueries.findInnermostDeclarator(dtor);
                name = dtor.getName();
            }
            if (name == null) {
                return null;
            }
            if (name instanceof ICPPASTQualifiedName) {
                IASTName[] ns;
                int idx = templates.length;
                int i = 0;
                IASTName[] iASTNameArray = ns = ((ICPPASTQualifiedName)name).getNames();
                int n = ns.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTName element = iASTNameArray[n2];
                    if (element instanceof ICPPASTTemplateId && ++i == idx) {
                        binding = ((ICPPASTTemplateId)element).resolveBinding();
                        break;
                    }
                    ++n2;
                }
                if (binding == null) {
                    binding = ns[ns.length - 1].resolveBinding();
                }
            } else {
                binding = name.resolveBinding();
            }
        } else if (parent instanceof ICPPASTTemplatedTypeTemplateParameter) {
            ICPPASTTemplatedTypeTemplateParameter templatedParam = (ICPPASTTemplatedTypeTemplateParameter)parent;
            binding = templatedParam.getName().resolveBinding();
        }
        return binding instanceof ICPPTemplateDefinition ? (ICPPTemplateDefinition)binding : null;
    }

    public static IBinding createBinding(ICPPASTTemplateParameter tp) {
        if (tp instanceof ICPPASTSimpleTypeTemplateParameter) {
            return new CPPTemplateTypeParameter(((ICPPASTSimpleTypeTemplateParameter)tp).getName(), tp.isParameterPack());
        }
        if (tp instanceof ICPPASTTemplatedTypeTemplateParameter) {
            return new CPPTemplateTemplateParameter(((ICPPASTTemplatedTypeTemplateParameter)tp).getName(), tp.isParameterPack());
        }
        assert (tp instanceof ICPPASTParameterDeclaration);
        ICPPASTDeclarator dtor = ((ICPPASTParameterDeclaration)tp).getDeclarator();
        return new CPPTemplateNonTypeParameter(ASTQueries.findInnermostDeclarator(dtor).getName());
    }

    public static ICPPScope getContainingScope(IASTNode node) {
        while (node != null) {
            IASTNode parent;
            if (node instanceof ICPPASTTemplateParameter && (parent = node.getParent()) instanceof ICPPASTTemplateDeclaration) {
                return ((ICPPASTTemplateDeclaration)parent).getScope();
            }
            node = node.getParent();
        }
        return null;
    }

    public static IBinding createBinding(ICPPASTTemplateId id) {
        if (!CPPTemplates.isClassTemplate(id)) {
            IBinding result = CPPVisitor.createBinding(id);
            IASTName templateName = id.getTemplateName();
            if (result instanceof ICPPTemplateInstance) {
                templateName.setBinding(((ICPPTemplateInstance)result).getTemplateDefinition());
            } else {
                templateName.setBinding(result);
            }
            return result;
        }
        IASTNode parentOfName = id.getParent();
        boolean isLastName = true;
        if (parentOfName instanceof ICPPASTQualifiedName) {
            isLastName = ((ICPPASTQualifiedName)parentOfName).getLastName() == id;
            parentOfName = parentOfName.getParent();
        }
        boolean isDecl = false;
        boolean isDef = false;
        if (isLastName) {
            if (parentOfName instanceof ICPPASTElaboratedTypeSpecifier) {
                IASTNode parentOfDeclaration = parentOfName;
                while (parentOfDeclaration != null) {
                    if (parentOfDeclaration instanceof IASTDeclaration) {
                        parentOfDeclaration = parentOfDeclaration.getParent();
                        break;
                    }
                    parentOfDeclaration = parentOfDeclaration.getParent();
                }
                isDecl = !(parentOfDeclaration instanceof ICPPASTExplicitTemplateInstantiation);
            } else if (parentOfName instanceof ICPPASTCompositeTypeSpecifier) {
                isDef = true;
            }
        }
        try {
            ICPPASTTemplateDeclaration tdecl;
            IBinding owner;
            IBinding result = null;
            IASTName templateName = id.getTemplateName();
            IBinding template = templateName.resolvePreBinding();
            if (template instanceof ICPPConstructor) {
                template = template.getOwner();
            }
            if (template instanceof ICPPUnknownClassType && (owner = template.getOwner()) instanceof ICPPUnknownBinding) {
                ICPPTemplateArgument[] args = CPPTemplates.createTemplateArgumentArray(id);
                args = SemanticUtil.getSimplifiedArguments(args);
                return new CPPUnknownClassInstance((ICPPUnknownBinding)template.getOwner(), id.getSimpleID(), args);
            }
            if (!(template instanceof ICPPClassTemplate) || template instanceof ICPPClassTemplatePartialSpecialization) {
                return new ProblemBinding((IASTNode)id, 5, templateName.toCharArray());
            }
            ICPPClassTemplate classTemplate = (ICPPClassTemplate)template;
            ICPPTemplateArgument[] args = CPPTemplates.createTemplateArgumentArray(id);
            if (CPPTemplates.hasDependentArgument(args) && (tdecl = CPPTemplates.getTemplateDeclaration(id)) != null) {
                if (CPPTemplates.argsAreTrivial(classTemplate.getTemplateParameters(), args)) {
                    result = classTemplate;
                } else {
                    ICPPClassTemplatePartialSpecialization partialSpec = CPPTemplates.findPartialSpecialization(classTemplate, args);
                    if ((isDecl || isDef) && partialSpec == null) {
                        partialSpec = new CPPClassTemplatePartialSpecialization(id);
                        if (template instanceof ICPPInternalClassTemplate) {
                            ((ICPPInternalClassTemplate)template).addPartialSpecialization(partialSpec);
                        }
                        return partialSpec;
                    }
                    if (partialSpec == null) {
                        return new ProblemBinding((IASTNode)id, 5, templateName.toCharArray());
                    }
                    result = partialSpec;
                }
            }
            if (result == null && (result = CPPTemplates.instantiate(classTemplate, args, isDef)) instanceof ICPPInternalBinding) {
                if (isDecl) {
                    ASTInternal.addDeclaration(result, id);
                } else if (isDef) {
                    ASTInternal.addDefinition(result, id);
                }
            }
            return CPPSemantics.postResolution(result, id);
        }
        catch (DOMException e) {
            return e.getProblem();
        }
    }

    static boolean isClassTemplate(ICPPASTTemplateId id) {
        IASTNode parentOfName = id.getParent();
        if (parentOfName instanceof ICPPASTQualifiedName) {
            if (((ICPPASTQualifiedName)parentOfName).getLastName() != id) {
                return true;
            }
            parentOfName = parentOfName.getParent();
        }
        return parentOfName instanceof ICPPASTElaboratedTypeSpecifier || parentOfName instanceof ICPPASTCompositeTypeSpecifier || parentOfName instanceof ICPPASTNamedTypeSpecifier || parentOfName instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier;
    }

    public static ICPPTemplateInstance createInstance(IBinding owner, ICPPTemplateDefinition template, CPPTemplateParameterMap tpMap, ICPPTemplateArgument[] args) {
        ICPPTemplateParameterMap map;
        if (owner instanceof ICPPSpecialization && (map = ((ICPPSpecialization)owner).getTemplateParameterMap()) != null) {
            tpMap.putAll(map);
        }
        CPPSpecialization instance = null;
        if (template instanceof ICPPClassType) {
            instance = new CPPClassInstance((ICPPClassType)((Object)template), owner, tpMap, args);
        } else if (owner instanceof ICPPClassType && template instanceof ICPPMethod) {
            instance = template instanceof ICPPConstructor ? new CPPConstructorInstance((ICPPConstructor)((Object)template), (ICPPClassType)owner, tpMap, args) : new CPPMethodInstance((ICPPMethod)((Object)template), (ICPPClassType)owner, tpMap, args);
        } else if (template instanceof ICPPFunction) {
            instance = new CPPFunctionInstance((ICPPFunction)((Object)template), owner, tpMap, args);
        }
        return instance;
    }

    public static IBinding createSpecialization(ICPPClassSpecialization owner, IBinding decl) {
        IBinding spec = null;
        ICPPTemplateParameterMap tpMap = owner.getTemplateParameterMap();
        if (decl instanceof ICPPClassTemplatePartialSpecialization) {
            try {
                ICPPClassTemplatePartialSpecialization pspec = (ICPPClassTemplatePartialSpecialization)decl;
                ICPPClassTemplate template = (ICPPClassTemplate)owner.specializeMember(pspec.getPrimaryClassTemplate());
                spec = new CPPClassTemplatePartialSpecializationSpecialization(pspec, template, tpMap);
            }
            catch (DOMException dOMException) {}
        } else if (decl instanceof ICPPClassTemplate) {
            spec = new CPPClassTemplateSpecialization((ICPPClassTemplate)decl, owner, tpMap);
        } else if (decl instanceof ICPPClassType) {
            spec = new CPPClassSpecialization((ICPPClassType)decl, (IBinding)owner, tpMap);
        } else if (decl instanceof ICPPField) {
            spec = new CPPFieldSpecialization(decl, owner, tpMap);
        } else if (decl instanceof ICPPFunctionTemplate) {
            spec = decl instanceof ICPPConstructor ? new CPPConstructorTemplateSpecialization((ICPPConstructor)decl, (ICPPClassType)owner, tpMap) : (decl instanceof ICPPMethod ? new CPPMethodTemplateSpecialization((ICPPMethod)decl, (ICPPClassType)owner, tpMap) : new CPPFunctionTemplateSpecialization((ICPPFunction)((ICPPFunctionTemplate)decl), owner, tpMap));
        } else if (decl instanceof ICPPConstructor) {
            spec = new CPPConstructorSpecialization((ICPPConstructor)decl, (ICPPClassType)owner, tpMap);
        } else if (decl instanceof ICPPMethod) {
            spec = new CPPMethodSpecialization((ICPPMethod)decl, owner, tpMap);
        } else if (decl instanceof ICPPFunction) {
            spec = new CPPFunctionSpecialization((ICPPFunction)decl, (IBinding)owner, tpMap);
        } else if (decl instanceof ITypedef) {
            spec = new CPPTypedefSpecialization(decl, owner, tpMap);
        } else if (decl instanceof IEnumeration || decl instanceof IEnumerator) {
            spec = decl;
        }
        return spec;
    }

    public static IValue instantiateValue(IValue value, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, int maxdepth) {
        if (value == null) {
            return null;
        }
        IBinding[] unknowns = value.getUnknownBindings();
        IBinding[] resolvedUnknowns = null;
        if (unknowns.length != 0) {
            int i = 0;
            while (i < unknowns.length) {
                IBinding unknown;
                IBinding resolved = unknown = unknowns[i];
                if (unknown instanceof ICPPUnknownBinding) {
                    try {
                        resolved = CPPTemplates.resolveUnknown((ICPPUnknownBinding)unknown, tpMap, packOffset, within);
                    }
                    catch (DOMException dOMException) {
                        return Value.UNKNOWN;
                    }
                }
                if (resolvedUnknowns != null) {
                    resolvedUnknowns[i] = resolved;
                } else if (resolved != unknown) {
                    resolvedUnknowns = new IBinding[unknowns.length];
                    System.arraycopy(unknowns, 0, resolvedUnknowns, 0, i);
                    resolvedUnknowns[i] = resolved;
                }
                ++i;
            }
        }
        if (resolvedUnknowns != null) {
            return Value.reevaluate(value, packOffset, resolvedUnknowns, tpMap, maxdepth);
        }
        if (Value.referencesTemplateParameter(value)) {
            return Value.reevaluate(value, packOffset, unknowns, tpMap, maxdepth);
        }
        return value;
    }

    public static boolean containsParameterPack(IType type) {
        return CPPTemplates.determinePackSize(type, (ICPPTemplateParameterMap)CPPTemplateParameterMap.EMPTY) == -1;
    }

    private static int determinePackSize(IType type, ICPPTemplateParameterMap tpMap) {
        IArrayType at;
        IValue asize;
        if (type instanceof ICPPFunctionType) {
            IType[] ps;
            ICPPFunctionType ft = (ICPPFunctionType)type;
            IType rt = ft.getReturnType();
            int r = CPPTemplates.determinePackSize(rt, tpMap);
            if (r < 0) {
                return r;
            }
            IType[] iTypeArray = ps = ft.getParameterTypes();
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                IType pt = iTypeArray[n2];
                if ((r = CPPTemplates.combine(r, CPPTemplates.determinePackSize(pt, tpMap))) < 0) {
                    return r;
                }
                ++n2;
            }
            return r;
        }
        if (type instanceof ICPPTemplateParameter) {
            ICPPTemplateParameter tpar = (ICPPTemplateParameter)((Object)type);
            if (tpar.isParameterPack()) {
                ICPPTemplateArgument[] args = tpMap.getPackExpansion(tpar);
                if (args != null) {
                    return args.length;
                }
                return -1;
            }
            return Integer.MAX_VALUE;
        }
        int r = Integer.MAX_VALUE;
        if (type instanceof ICPPUnknownBinding) {
            IBinding binding;
            if (type instanceof ICPPDeferredClassInstance) {
                ICPPTemplateArgument[] args;
                ICPPDeferredClassInstance dcl = (ICPPDeferredClassInstance)type;
                ICPPTemplateArgument[] iCPPTemplateArgumentArray = args = dcl.getTemplateArguments();
                int n = args.length;
                int n3 = 0;
                while (n3 < n) {
                    ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n3];
                    if ((r = CPPTemplates.combine(r, CPPTemplates.determinePackSize(arg, tpMap))) < 0) {
                        return r;
                    }
                    ++n3;
                }
            }
            if ((binding = ((ICPPUnknownBinding)((Object)type)).getOwner()) instanceof IType) {
                r = CPPTemplates.combine(r, CPPTemplates.determinePackSize((IType)((Object)binding), tpMap));
            }
            return r;
        }
        if (type instanceof ICPPParameterPackType) {
            return Integer.MAX_VALUE;
        }
        if (type instanceof IArrayType && (r = CPPTemplates.determinePackSize(asize = (at = (IArrayType)type).getSize(), tpMap)) < 0) {
            return r;
        }
        if (type instanceof ITypeContainer) {
            ITypeContainer typeContainer = (ITypeContainer)type;
            r = CPPTemplates.combine(r, CPPTemplates.determinePackSize(typeContainer.getType(), tpMap));
        }
        return r;
    }

    private static int combine(int ps1, int ps2) {
        if (ps1 < 0 || ps2 == Integer.MAX_VALUE) {
            return ps1;
        }
        if (ps2 < 0 || ps1 == Integer.MAX_VALUE) {
            return ps2;
        }
        if (ps1 != ps2) {
            return -2;
        }
        return ps1;
    }

    private static int determinePackSize(IValue value, ICPPTemplateParameterMap tpMap) {
        int[] tpars;
        IBinding[] unknown;
        int r = Integer.MAX_VALUE;
        IBinding[] iBindingArray = unknown = value.getUnknownBindings();
        int n = unknown.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray[n2];
            if (binding instanceof IType && (r = CPPTemplates.combine(r, CPPTemplates.determinePackSize((IType)((Object)binding), tpMap))) < 0) {
                return r;
            }
            ++n2;
        }
        int[] nArray = tpars = Value.getParameterPackReferences(value);
        if (tpars.length != 0) {
            int parID = nArray[0];
            ICPPTemplateArgument[] args = tpMap.getPackExpansion(parID);
            if (args != null && (r = CPPTemplates.combine(r, args.length)) < 0) {
                return r;
            }
            return -1;
        }
        return r;
    }

    private static int determinePackSize(ICPPTemplateArgument arg, ICPPTemplateParameterMap tpMap) {
        if (arg.isTypeValue()) {
            return CPPTemplates.determinePackSize(arg.getTypeValue(), tpMap);
        }
        return CPPTemplates.determinePackSize(arg.getNonTypeValue(), tpMap);
    }

    public static IType[] instantiateTypes(IType[] types, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within) {
        IType[] result = types;
        int j = 0;
        int i = 0;
        while (i < types.length) {
            block9: {
                IType newType;
                IType origType;
                block7: {
                    block5: {
                        int packSize;
                        block8: {
                            block6: {
                                origType = types[i];
                                if (!(origType instanceof ICPPParameterPackType)) break block5;
                                packSize = CPPTemplates.determinePackSize(origType = ((ICPPParameterPackType)origType).getType(), tpMap);
                                if (packSize != -2 && packSize != Integer.MAX_VALUE) break block6;
                                newType = new ProblemBinding(null, 5);
                                break block7;
                            }
                            if (packSize != -1) break block8;
                            newType = origType;
                            break block7;
                        }
                        IType[] newResult = new IType[result.length + packSize - 1];
                        System.arraycopy(result, 0, newResult, 0, j);
                        result = newResult;
                        int k = 0;
                        while (k < packSize) {
                            result[j++] = CPPTemplates.instantiateType(origType, tpMap, k, within);
                            ++k;
                        }
                        break block9;
                    }
                    newType = CPPTemplates.instantiateType(origType, tpMap, packOffset, within);
                }
                if (result != types) {
                    result[j++] = newType;
                } else {
                    if (newType != origType) {
                        result = new IType[types.length];
                        System.arraycopy(types, 0, result, 0, i);
                        result[j] = newType;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public static ICPPTemplateArgument[] instantiateArguments(ICPPTemplateArgument[] args, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within) throws DOMException {
        ICPPTemplateArgument[] result = args;
        int resultShift = 0;
        int i = 0;
        while (i < args.length) {
            block11: {
                ICPPTemplateArgument newArg;
                ICPPTemplateArgument origArg;
                block10: {
                    block8: {
                        int packSize;
                        block9: {
                            origArg = args[i];
                            if (!origArg.isPackExpansion()) break block8;
                            packSize = CPPTemplates.determinePackSize(origArg = origArg.getExpansionPattern(), tpMap);
                            if (packSize == -2 || packSize == Integer.MAX_VALUE) {
                                throw new DOMException(new ProblemBinding(null, 15));
                            }
                            if (packSize != -1) break block9;
                            newArg = origArg;
                            break block10;
                        }
                        int shift = packSize - 1;
                        ICPPTemplateArgument[] newResult = new ICPPTemplateArgument[args.length + resultShift + shift];
                        System.arraycopy(result, 0, newResult, 0, i + resultShift);
                        int j = 0;
                        while (j < packSize) {
                            newResult[i + resultShift + j] = CPPTemplates.instantiateArgument(origArg, tpMap, j, within);
                            ++j;
                        }
                        result = newResult;
                        resultShift += shift;
                        break block11;
                    }
                    newArg = CPPTemplates.instantiateArgument(origArg, tpMap, packOffset, within);
                }
                if (result != args) {
                    result[i + resultShift] = newArg;
                } else if (newArg != origArg) {
                    assert (resultShift == 0);
                    result = new ICPPTemplateArgument[args.length];
                    if (i > 0) {
                        System.arraycopy(args, 0, result, 0, i);
                    }
                    result[i] = newArg;
                }
            }
            ++i;
        }
        return result;
    }

    static ICPPTemplateArgument instantiateArgument(ICPPTemplateArgument arg, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within) {
        IType inst;
        if (arg == null) {
            return null;
        }
        if (arg.isNonTypeValue()) {
            IValue origValue = arg.getNonTypeValue();
            IType origType = arg.getTypeOfNonTypeValue();
            IValue instValue = CPPTemplates.instantiateValue(origValue, tpMap, packOffset, within, 25);
            IType instType = CPPTemplates.instantiateType(origType, tpMap, packOffset, within);
            if (origType == instType && origValue == instValue) {
                return arg;
            }
            return new CPPTemplateArgument(instValue, instType);
        }
        IType orig = arg.getTypeValue();
        if (orig == (inst = CPPTemplates.instantiateType(orig, tpMap, packOffset, within))) {
            return arg;
        }
        return new CPPTemplateArgument(inst);
    }

    public static IType instantiateType(IType type, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within) {
        try {
            if (tpMap == null) {
                return type;
            }
            if (type instanceof ICPPFunctionType) {
                ICPPFunctionType ft = (ICPPFunctionType)type;
                IType ret = null;
                IType[] params = null;
                IType r = ft.getReturnType();
                ret = CPPTemplates.instantiateType(r, tpMap, packOffset, within);
                IType[] ps = ft.getParameterTypes();
                params = CPPTemplates.instantiateTypes(ps, tpMap, packOffset, within);
                if (ret == r && params == ps) {
                    return type;
                }
                int i = 0;
                while (i < params.length) {
                    IType p = params[i];
                    if (!CPPTemplates.isDependentType(p)) {
                        params[i] = CPPVisitor.adjustParameterType(p, true);
                    }
                    ++i;
                }
                return new CPPFunctionType(ret, params, ft.isConst(), ft.isVolatile(), ft.takesVarArgs());
            }
            if (type instanceof ICPPTemplateParameter) {
                IType t;
                ICPPTemplateParameter tpar = (ICPPTemplateParameter)((Object)type);
                ICPPTemplateArgument arg = null;
                if (tpar.isParameterPack()) {
                    ICPPTemplateArgument[] args;
                    if (packOffset >= 0 && (args = tpMap.getPackExpansion(tpar)) != null) {
                        if (packOffset >= args.length) {
                            return new ProblemBinding(null, 5);
                        }
                        arg = args[packOffset];
                    }
                } else {
                    arg = tpMap.getArgument(tpar);
                }
                if (arg != null && (t = arg.getTypeValue()) != null) {
                    return t;
                }
                return type;
            }
            if (type instanceof ICPPUnknownBinding) {
                IBinding binding = CPPTemplates.resolveUnknown((ICPPUnknownBinding)((Object)type), tpMap, packOffset, within);
                if (binding instanceof IType) {
                    return (IType)((Object)binding);
                }
                return type;
            }
            if (within != null && type instanceof IBinding && (type instanceof ITypedef || type instanceof ICPPClassType)) {
                ICPPClassType originalClass = within.getSpecializedBinding();
                if (originalClass.isSameType(type)) {
                    return within;
                }
                IBinding typeAsBinding = (IBinding)((Object)type);
                IBinding typeOwner = typeAsBinding.getOwner();
                if (typeOwner instanceof IType) {
                    IType newOwner = CPPTemplates.instantiateType((IType)((Object)typeOwner), tpMap, packOffset, within);
                    if (newOwner != typeOwner && newOwner instanceof ICPPClassSpecialization) {
                        return (IType)((Object)((ICPPClassSpecialization)newOwner).specializeMember(typeAsBinding));
                    }
                    return type;
                }
            }
            if (type instanceof ITypeContainer) {
                IValue newSize;
                IArrayType at;
                IValue asize;
                ITypeContainer typeContainer = (ITypeContainer)type;
                IType nestedType = typeContainer.getType();
                IType newNestedType = CPPTemplates.instantiateType(nestedType, tpMap, packOffset, within);
                if (typeContainer instanceof ICPPPointerToMemberType) {
                    ICPPPointerToMemberType ptm = (ICPPPointerToMemberType)((Object)typeContainer);
                    IType memberOfClass = ptm.getMemberOfClass();
                    IType newMemberOfClass = CPPTemplates.instantiateType(memberOfClass, tpMap, packOffset, within);
                    if (!(newMemberOfClass instanceof ICPPClassType || newMemberOfClass instanceof UniqueType || newMemberOfClass instanceof ICPPUnknownBinding)) {
                        newMemberOfClass = memberOfClass;
                    }
                    if (newNestedType != nestedType || newMemberOfClass != memberOfClass) {
                        return new CPPPointerToMemberType(newNestedType, newMemberOfClass, ptm.isConst(), ptm.isVolatile(), ptm.isRestrict());
                    }
                    return typeContainer;
                }
                if (typeContainer instanceof IArrayType && (asize = (at = (IArrayType)((Object)typeContainer)).getSize()) != null && (newSize = CPPTemplates.instantiateValue(asize, tpMap, packOffset, within, 25)) != asize) {
                    return new CPPArrayType(newNestedType, newSize);
                }
                if (newNestedType != nestedType) {
                    return SemanticUtil.replaceNestedType(typeContainer, newNestedType);
                }
                return typeContainer;
            }
            return type;
        }
        catch (DOMException e) {
            return e.getProblem();
        }
    }

    public static ICPPASTTemplateDeclaration getTemplateDeclaration(IASTName name) {
        if (name == null) {
            return null;
        }
        ICPPASTInternalTemplateDeclaration tdecl = CPPTemplates.getInnerTemplateDeclaration(name);
        if (tdecl == null) {
            return null;
        }
        IASTNode parent = (name = name.getLastName()).getParent();
        if (!(parent instanceof ICPPASTQualifiedName)) {
            if (parent instanceof ICPPASTTemplateId) {
                return null;
            }
            return tdecl;
        }
        ICPPASTQualifiedName qname = (ICPPASTQualifiedName)parent;
        IASTName lastName = qname.getLastName();
        boolean lastIsTemplate = tdecl.isAssociatedWithLastName();
        if (name == lastName) {
            if (lastIsTemplate) {
                return tdecl;
            }
            return null;
        }
        if (!(name instanceof ICPPASTTemplateId)) {
            return null;
        }
        if (lastIsTemplate) {
            tdecl = CPPTemplates.getDirectlyEnclosingTemplateDeclaration(tdecl);
        }
        IASTName[] ns = qname.getNames();
        int i = ns.length - 2;
        while (tdecl != null && i >= 0) {
            IASTName n = ns[i];
            if (n == name) {
                return tdecl;
            }
            if (n instanceof ICPPASTTemplateId) {
                tdecl = CPPTemplates.getDirectlyEnclosingTemplateDeclaration(tdecl);
            }
            --i;
        }
        return null;
    }

    public static void associateTemplateDeclarations(ICPPASTInternalTemplateDeclaration tdecl) {
        IASTDeclaration decl = tdecl.getDeclaration();
        while (decl instanceof ICPPASTInternalTemplateDeclaration) {
            tdecl = (ICPPASTInternalTemplateDeclaration)decl;
            decl = tdecl.getDeclaration();
        }
        ICPPASTInternalTemplateDeclaration innerMostTDecl = tdecl;
        IASTName name = CPPTemplates.getNameForDeclarationInTemplateDeclaration(decl);
        int tdeclcount = 1;
        IASTNode node = tdecl.getParent();
        while (node instanceof ICPPASTInternalTemplateDeclaration) {
            ++tdeclcount;
            tdecl = (ICPPASTInternalTemplateDeclaration)node;
            node = node.getParent();
        }
        ICPPASTInternalTemplateDeclaration outerMostTDecl = tdecl;
        boolean lastIsTemplate = true;
        int missingTemplateDecls = 0;
        if (name instanceof ICPPASTQualifiedName) {
            char[] lastNamesLookupKey;
            IASTName secondLastName;
            IASTName[] ns;
            ICPPASTQualifiedName qname = (ICPPASTQualifiedName)name;
            IASTName lastName = qname.getLastName();
            boolean lastIsID = lastName instanceof ICPPASTTemplateId;
            int idcount = 0;
            IASTName[] iASTNameArray = ns = qname.getNames();
            int n = ns.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName n3 = iASTNameArray[n2];
                if (n3 instanceof ICPPASTTemplateId) {
                    ++idcount;
                }
                ++n2;
            }
            boolean isCtorWithTemplateID = false;
            if (lastIsID && ns.length > 1 && (secondLastName = ns[ns.length - 2]) instanceof ICPPASTTemplateId && (CharArrayUtils.equals(lastNamesLookupKey = lastName.getLookupKey(), ((ICPPASTTemplateId)secondLastName).getLookupKey()) || lastNamesLookupKey.length > 0 && lastNamesLookupKey[0] == '~')) {
                isCtorWithTemplateID = true;
                --idcount;
            }
            if (lastIsID && !isCtorWithTemplateID) {
                missingTemplateDecls = idcount - tdeclcount;
            } else {
                missingTemplateDecls = idcount + 1 - tdeclcount;
                if (missingTemplateDecls > 0) {
                    --missingTemplateDecls;
                    lastIsTemplate = false;
                    CharArraySet tparnames = CPPTemplates.collectTemplateParameterNames(outerMostTDecl);
                    int j = 0;
                    IASTName[] iASTNameArray2 = ns;
                    int n4 = ns.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IASTName n6 = iASTNameArray2[n5];
                        if (n6 instanceof ICPPASTTemplateId) {
                            ICPPASTTemplateId id = (ICPPASTTemplateId)n6;
                            if (CPPTemplates.usesTemplateParameter(id, tparnames)) break;
                            if (j++ == missingTemplateDecls) {
                                IBinding b = n6.resolveBinding();
                                if (!(b instanceof ICPPTemplateInstance) || !(b instanceof ICPPClassType) || !((ICPPTemplateInstance)b).isExplicitSpecialization()) break;
                                ++missingTemplateDecls;
                                lastIsTemplate = true;
                                break;
                            }
                        }
                        ++n5;
                    }
                }
            }
        }
        if (missingTemplateDecls < 0) {
            missingTemplateDecls = 0;
        }
        int level = missingTemplateDecls;
        if (!CPPVisitor.isFriendFunctionDeclaration(innerMostTDecl.getDeclaration())) {
            node = outerMostTDecl.getParent();
            while (node != null) {
                if (node instanceof ICPPASTInternalTemplateDeclaration) {
                    level += ((ICPPASTInternalTemplateDeclaration)node).getNestingLevel() + 1;
                    break;
                }
                node = node.getParent();
            }
        }
        tdecl = outerMostTDecl;
        while (true) {
            tdecl.setNestingLevel((short)level++);
            tdecl.setAssociatedWithLastName(false);
            node = tdecl.getDeclaration();
            if (!(node instanceof ICPPASTInternalTemplateDeclaration)) break;
            tdecl = (ICPPASTInternalTemplateDeclaration)node;
        }
        innerMostTDecl.setAssociatedWithLastName(lastIsTemplate);
    }

    private static CharArraySet collectTemplateParameterNames(ICPPASTTemplateDeclaration tdecl) {
        CharArraySet set = new CharArraySet(4);
        while (true) {
            ICPPASTTemplateParameter[] pars;
            ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = pars = tdecl.getTemplateParameters();
            int n = pars.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTTemplateParameter par = iCPPASTTemplateParameterArray[n2];
                IASTName name = CPPTemplates.getTemplateParameterName(par);
                if (name != null) {
                    set.put(name.getLookupKey());
                }
                ++n2;
            }
            IASTDeclaration next = tdecl.getDeclaration();
            if (!(next instanceof ICPPASTTemplateDeclaration)) break;
            tdecl = (ICPPASTTemplateDeclaration)next;
        }
        return set;
    }

    private static boolean usesTemplateParameter(ICPPASTTemplateId id, final CharArraySet names) {
        final boolean[] result = new boolean[1];
        ASTVisitor v = new ASTVisitor(false){
            {
                super($anonymous0);
                this.shouldVisitNames = true;
                this.shouldVisitAmbiguousNodes = true;
            }

            public int visit(IASTName name) {
                if (name instanceof ICPPASTTemplateId) {
                    return 3;
                }
                if (name instanceof ICPPASTQualifiedName) {
                    ICPPASTQualifiedName qname = (ICPPASTQualifiedName)name;
                    if (qname.isFullyQualified()) {
                        return 1;
                    }
                    return 3;
                }
                if (names.containsKey(name.getLookupKey())) {
                    IASTNode parent = name.getParent();
                    if (parent instanceof ICPPASTQualifiedName) {
                        if (((ICPPASTQualifiedName)parent).getNames()[0] != name) {
                            return 3;
                        }
                        result[0] = true;
                        return 2;
                    }
                    if (parent instanceof IASTIdExpression || parent instanceof ICPPASTNamedTypeSpecifier) {
                        result[0] = true;
                        return 2;
                    }
                }
                return 3;
            }

            public int visit(ASTAmbiguousNode node) {
                IASTNode[] alternatives;
                IASTNode[] iASTNodeArray = alternatives = node.getNodes();
                int n = alternatives.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTNode alt = iASTNodeArray[n2];
                    if (!alt.accept(this)) {
                        return 2;
                    }
                    ++n2;
                }
                return 3;
            }
        };
        id.accept(v);
        return result[0];
    }

    private static IASTName getNameForDeclarationInTemplateDeclaration(IASTDeclaration decl) {
        IASTName name = null;
        if (decl instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration sdecl = (IASTSimpleDeclaration)decl;
            IASTDeclarator[] dtors = sdecl.getDeclarators();
            if (dtors != null && dtors.length > 0) {
                name = ASTQueries.findInnermostDeclarator(dtors[0]).getName();
            } else {
                IASTDeclSpecifier declspec = sdecl.getDeclSpecifier();
                if (declspec instanceof IASTCompositeTypeSpecifier) {
                    name = ((IASTCompositeTypeSpecifier)declspec).getName();
                } else if (declspec instanceof IASTElaboratedTypeSpecifier) {
                    name = ((IASTElaboratedTypeSpecifier)declspec).getName();
                }
            }
        } else if (decl instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition fdef = (IASTFunctionDefinition)decl;
            name = ASTQueries.findInnermostDeclarator(fdef.getDeclarator()).getName();
        }
        return name;
    }

    /*
     * Unable to fully structure code
     */
    private static ICPPASTInternalTemplateDeclaration getInnerTemplateDeclaration(IASTName name) {
        block5: {
            parent = name.getParent();
            while (parent instanceof IASTName) {
                parent = parent.getParent();
            }
            if (!(parent instanceof IASTDeclSpecifier)) ** GOTO lbl11
            if (!(parent instanceof IASTCompositeTypeSpecifier) && !(parent instanceof IASTElaboratedTypeSpecifier)) {
                return null;
            }
            parent = parent.getParent();
            break block5;
lbl-1000:
            // 1 sources

            {
                parent = parent.getParent();
lbl11:
                // 2 sources

                ** while (parent instanceof IASTDeclarator)
            }
        }
        if (!(parent instanceof IASTDeclaration)) {
            return null;
        }
        if ((parent = parent.getParent()) instanceof ICPPASTInternalTemplateDeclaration) {
            return (ICPPASTInternalTemplateDeclaration)parent;
        }
        return null;
    }

    private static ICPPASTInternalTemplateDeclaration getDirectlyEnclosingTemplateDeclaration(ICPPASTInternalTemplateDeclaration tdecl) {
        IASTNode parent = tdecl.getParent();
        if (parent instanceof ICPPASTInternalTemplateDeclaration) {
            return (ICPPASTInternalTemplateDeclaration)parent;
        }
        return null;
    }

    public static IASTName getTemplateName(ICPPASTTemplateDeclaration templateDecl) {
        if (templateDecl == null) {
            return null;
        }
        ICPPASTTemplateDeclaration decl = templateDecl;
        while (decl.getParent() instanceof ICPPASTTemplateDeclaration) {
            decl = (ICPPASTTemplateDeclaration)decl.getParent();
        }
        IASTDeclaration nestedDecl = templateDecl.getDeclaration();
        while (nestedDecl instanceof ICPPASTTemplateDeclaration) {
            nestedDecl = ((ICPPASTTemplateDeclaration)nestedDecl).getDeclaration();
        }
        IASTName name = null;
        if (nestedDecl instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration simple = (IASTSimpleDeclaration)nestedDecl;
            if (simple.getDeclarators().length == 1) {
                IASTDeclarator dtor = simple.getDeclarators()[0];
                while (dtor.getNestedDeclarator() != null) {
                    dtor = dtor.getNestedDeclarator();
                }
                name = dtor.getName();
            } else if (simple.getDeclarators().length == 0) {
                IASTDeclSpecifier spec = simple.getDeclSpecifier();
                if (spec instanceof ICPPASTCompositeTypeSpecifier) {
                    name = ((ICPPASTCompositeTypeSpecifier)spec).getName();
                } else if (spec instanceof ICPPASTElaboratedTypeSpecifier) {
                    name = ((ICPPASTElaboratedTypeSpecifier)spec).getName();
                }
            }
        } else if (nestedDecl instanceof IASTFunctionDefinition) {
            IASTDeclarator declarator = ((IASTFunctionDefinition)nestedDecl).getDeclarator();
            declarator = ASTQueries.findInnermostDeclarator(declarator);
            name = declarator.getName();
        }
        if (name != null) {
            if (name instanceof ICPPASTQualifiedName) {
                IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
                IASTDeclaration currDecl = decl;
                int j = 0;
                while (j < ns.length) {
                    if (ns[j] instanceof ICPPASTTemplateId || j + 1 == ns.length) {
                        if (currDecl == templateDecl) {
                            return ns[j];
                        }
                        if (currDecl instanceof ICPPASTTemplateDeclaration) {
                            currDecl = currDecl.getDeclaration();
                        } else {
                            return null;
                        }
                    }
                    ++j;
                }
            } else {
                return name;
            }
        }
        return null;
    }

    public static boolean areSameArguments(ICPPTemplateArgument[] args, ICPPTemplateArgument[] specArgs) {
        if (args.length != specArgs.length) {
            return false;
        }
        int i = 0;
        while (i < args.length) {
            if (!specArgs[i].isSameValue(args[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static ICPPTemplateArgument[] createTemplateArgumentArray(ICPPASTTemplateId id) {
        ICPPTemplateArgument[] result = ICPPTemplateArgument.EMPTY_ARGUMENTS;
        if (id != null) {
            IASTNode[] args = id.getTemplateArguments();
            result = new ICPPTemplateArgument[args.length];
            int i = 0;
            while (i < args.length) {
                IASTNode arg = args[i];
                if (arg instanceof IASTTypeId) {
                    result[i] = new CPPTemplateArgument(CPPVisitor.createType((IASTTypeId)arg));
                } else if (arg instanceof IASTExpression) {
                    IASTExpression expr = (IASTExpression)arg;
                    IType type = expr.getExpressionType();
                    IValue value = Value.create((IASTExpression)arg, 25);
                    result[i] = new CPPTemplateArgument(value, type);
                } else {
                    throw new IllegalArgumentException();
                }
                ++i;
            }
        }
        return result;
    }

    static ICPPFunction[] instantiateForFunctionCall(IASTName name, ICPPFunction[] fns, List<IType> fnArgs, List<IASTExpression.ValueCategory> argCats, boolean withImpliedObjectArg) {
        if (name != null && name.getPropertyInParent() == ICPPASTTemplateId.TEMPLATE_NAME) {
            name = (IASTName)name.getParent();
        }
        ICPPTemplateArgument[] tmplArgs = ICPPTemplateArgument.EMPTY_ARGUMENTS;
        boolean requireTemplate = name instanceof ICPPASTTemplateId;
        boolean haveTemplate = false;
        ICPPFunction[] iCPPFunctionArray = fns;
        int n = fns.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPFunction func = iCPPFunctionArray[n2];
            if (func instanceof ICPPConstructor || func instanceof ICPPMethod && ((ICPPMethod)func).isDestructor()) {
                requireTemplate = false;
            }
            if (func instanceof ICPPFunctionTemplate) {
                ICPPFunctionTemplate template = (ICPPFunctionTemplate)func;
                try {
                    if (CPPTemplates.containsDependentType(fnArgs)) {
                        return new ICPPFunction[]{CPPUnknownFunction.createForSample(template)};
                    }
                    if (requireTemplate && CPPTemplates.hasDependentArgument(tmplArgs = CPPTemplates.createTemplateArgumentArray((ICPPASTTemplateId)name))) {
                        return new ICPPFunction[]{CPPUnknownFunction.createForSample(template)};
                    }
                }
                catch (DOMException dOMException) {
                    return NO_FUNCTIONS;
                }
                haveTemplate = true;
                break;
            }
            ++n2;
        }
        if (!haveTemplate && !requireTemplate) {
            return fns;
        }
        ArrayList<ICPPFunction> result = new ArrayList<ICPPFunction>(fns.length);
        ICPPFunction[] iCPPFunctionArray2 = fns;
        int n3 = fns.length;
        n = 0;
        while (n < n3) {
            ICPPFunction fn = iCPPFunctionArray2[n];
            if (fn != null) {
                if (fn instanceof ICPPFunctionTemplate) {
                    ICPPFunctionTemplate fnTmpl = (ICPPFunctionTemplate)fn;
                    ICPPFunction inst = CPPTemplates.instantiateForFunctionCall(fnTmpl, tmplArgs, fnArgs, argCats, withImpliedObjectArg);
                    if (inst != null) {
                        result.add(inst);
                    }
                } else if (!requireTemplate || fn instanceof ICPPUnknownBinding) {
                    result.add(fn);
                }
            }
            ++n;
        }
        return result.toArray(new ICPPFunction[result.size()]);
    }

    private static ICPPFunction instantiateForFunctionCall(ICPPFunctionTemplate template, ICPPTemplateArgument[] tmplArgs, List<IType> fnArgs, List<IASTExpression.ValueCategory> argCats, boolean withImpliedObjectArg) {
        if (withImpliedObjectArg && template instanceof ICPPMethod) {
            fnArgs = fnArgs.subList(1, fnArgs.size());
            argCats = argCats.subList(1, argCats.size());
        }
        CPPTemplateParameterMap map = new CPPTemplateParameterMap(fnArgs.size());
        try {
            ICPPFunction f;
            IBinding instance;
            ICPPTemplateArgument[] args = TemplateArgumentDeduction.deduceForFunctionCall(template, tmplArgs, fnArgs, argCats, map);
            if (args != null && (instance = CPPTemplates.instantiateFunctionTemplate(template, args, map)) instanceof ICPPFunction && CPPTemplates.isValidType((f = (ICPPFunction)instance).getType())) {
                return f;
            }
        }
        catch (DOMException dOMException) {}
        return null;
    }

    static void instantiateConversionTemplates(IFunction[] functions, IType conversionType) {
        boolean checkedForDependentType = false;
        int i = 0;
        while (i < functions.length) {
            IFunction func = functions[i];
            if (func instanceof ICPPFunctionTemplate) {
                ICPPFunctionTemplate template = (ICPPFunctionTemplate)func;
                functions[i] = null;
                if (!checkedForDependentType) {
                    try {
                        if (CPPTemplates.isDependentType(conversionType)) {
                            functions[i] = CPPUnknownFunction.createForSample(template);
                            return;
                        }
                        checkedForDependentType = true;
                    }
                    catch (DOMException dOMException) {
                        return;
                    }
                }
                CPPTemplateParameterMap map = new CPPTemplateParameterMap(1);
                try {
                    IBinding instance;
                    ICPPTemplateArgument[] args = TemplateArgumentDeduction.deduceForConversion(template, conversionType, map);
                    if (args != null && (instance = CPPTemplates.instantiateFunctionTemplate(template, args, map)) instanceof IFunction) {
                        functions[i] = (IFunction)instance;
                    }
                }
                catch (DOMException dOMException) {}
            }
            ++i;
        }
    }

    static ICPPFunction instantiateForAddressOfFunction(ICPPFunctionTemplate template, IFunctionType target, IASTName name) {
        if (name.getPropertyInParent() == ICPPASTTemplateId.TEMPLATE_NAME) {
            name = (IASTName)name.getParent();
        }
        try {
            IBinding instance;
            CPPTemplateParameterMap map;
            ICPPTemplateArgument[] args;
            ICPPTemplateArgument[] tmplArgs;
            if (target != null && CPPTemplates.isDependentType(target)) {
                return CPPUnknownFunction.createForSample(template);
            }
            if (name instanceof ICPPASTTemplateId && !(template instanceof ICPPConstructor)) {
                tmplArgs = CPPTemplates.createTemplateArgumentArray((ICPPASTTemplateId)name);
                if (CPPTemplates.hasDependentArgument(tmplArgs)) {
                    return CPPUnknownFunction.createForSample(template);
                }
            } else {
                tmplArgs = ICPPTemplateArgument.EMPTY_ARGUMENTS;
            }
            if ((args = TemplateArgumentDeduction.deduceForAddressOf(template, tmplArgs, target, map = new CPPTemplateParameterMap(4))) != null && (instance = CPPTemplates.instantiateFunctionTemplate(template, args, map)) instanceof ICPPFunction) {
                return (ICPPFunction)instance;
            }
        }
        catch (DOMException dOMException) {}
        return null;
    }

    static int orderFunctionTemplates(ICPPFunctionTemplate f1, ICPPFunctionTemplate f2, TypeSelection mode) throws DOMException {
        int s2;
        int s1 = CPPTemplates.compareSpecialization(f1, f2, mode);
        if (s1 == (s2 = CPPTemplates.compareSpecialization(f2, f1, mode))) {
            return 0;
        }
        if (s1 < 0 || s2 > 0) {
            return -1;
        }
        assert (s2 < 0 || s1 > 0);
        return 1;
    }

    private static ICPPFunction transferFunctionTemplate(ICPPFunctionTemplate f) throws DOMException {
        ICPPTemplateParameter[] tpars = f.getTemplateParameters();
        int argLen = tpars.length;
        ICPPTemplateArgument[] args = new ICPPTemplateArgument[argLen];
        CPPTemplateParameterMap map = new CPPTemplateParameterMap(argLen);
        int i = 0;
        while (i < argLen) {
            ICPPTemplateParameter tpar = tpars[i];
            CPPTemplateArgument arg = CPPTemplates.uniqueArg(tpar);
            args[i] = arg;
            if (tpar.isParameterPack()) {
                map.put(tpar, new ICPPTemplateArgument[]{arg});
            } else {
                map.put(tpar, (ICPPTemplateArgument)arg);
            }
            ++i;
        }
        IBinding result = CPPTemplates.instantiateFunctionTemplate(f, args, map);
        if (result instanceof ICPPFunction) {
            return (ICPPFunction)result;
        }
        return null;
    }

    private static CPPTemplateArgument uniqueArg(ICPPTemplateParameter tpar) throws DOMException {
        CPPTemplateArgument arg = tpar instanceof ICPPTemplateNonTypeParameter ? new CPPTemplateArgument(Value.unique(), ((ICPPTemplateNonTypeParameter)tpar).getType()) : new CPPTemplateArgument(new UniqueType(tpar.isParameterPack()));
        return arg;
    }

    private static int compareSpecialization(ICPPFunctionTemplate f1, ICPPFunctionTemplate f2, TypeSelection mode) throws DOMException {
        IType[] args;
        IType[] pars;
        ICPPFunction transF1 = CPPTemplates.transferFunctionTemplate(f1);
        if (transF1 == null) {
            return -1;
        }
        ICPPFunctionType ft2 = f2.getType();
        ICPPFunctionType transFt1 = transF1.getType();
        switch (mode) {
            case RETURN_TYPE: {
                pars = new IType[]{ft2.getReturnType()};
                args = new IType[]{transFt1.getReturnType()};
                break;
            }
            case PARAMETERS_AND_RETURN_TYPE: {
                pars = CPPTemplates.concat(ft2.getReturnType(), ft2.getParameterTypes());
                args = CPPTemplates.concat(transFt1.getReturnType(), transFt1.getParameterTypes());
                break;
            }
            default: {
                pars = ft2.getParameterTypes();
                args = transFt1.getParameterTypes();
                boolean nonStaticMember1 = CPPTemplates.isNonStaticMember(f1);
                boolean nonStaticMember2 = CPPTemplates.isNonStaticMember(f2);
                if (nonStaticMember1 == nonStaticMember2) break;
                if (nonStaticMember1) {
                    args = CPPTemplates.addImplicitParameterType(args, (ICPPMethod)((Object)f1));
                    break;
                }
                pars = CPPTemplates.addImplicitParameterType(pars, (ICPPMethod)((Object)f2));
            }
        }
        return TemplateArgumentDeduction.deduceForPartialOrdering(f2.getTemplateParameters(), pars, args);
    }

    private static boolean isNonStaticMember(ICPPFunctionTemplate f) {
        return f instanceof ICPPMethod && !((ICPPMethod)((Object)f)).isStatic();
    }

    private static IType[] addImplicitParameterType(IType[] types, ICPPMethod m) {
        try {
            IType t = CPPSemantics.getImplicitParameterType(m);
            return CPPTemplates.concat(t, types);
        }
        catch (DOMException dOMException) {
            return types;
        }
    }

    private static IType[] concat(IType t, IType[] types) {
        IType[] result = new IType[types.length + 1];
        result[0] = t;
        System.arraycopy(types, 0, result, 1, types.length);
        return result;
    }

    private static ICPPClassTemplatePartialSpecialization findPartialSpecialization(ICPPClassTemplate ct, ICPPTemplateArgument[] args) throws DOMException {
        ICPPClassTemplatePartialSpecialization[] pspecs = ct.getPartialSpecializations();
        if (pspecs != null && pspecs.length > 0) {
            String argStr = ASTTypeUtil.getArgumentListString(args, true);
            ICPPClassTemplatePartialSpecialization[] iCPPClassTemplatePartialSpecializationArray = pspecs;
            int n = pspecs.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPClassTemplatePartialSpecialization pspec = iCPPClassTemplatePartialSpecializationArray[n2];
                try {
                    if (argStr.equals(ASTTypeUtil.getArgumentListString(pspec.getTemplateArguments(), true))) {
                        return pspec;
                    }
                }
                catch (DOMException dOMException) {}
                ++n2;
            }
        }
        return null;
    }

    private static IBinding selectSpecialization(ICPPClassTemplate template, ICPPTemplateArgument[] args, boolean isDef) throws DOMException {
        if (template == null) {
            return null;
        }
        ICPPClassTemplatePartialSpecialization[] specializations = template.getPartialSpecializations();
        if (specializations == null || specializations.length == 0) {
            return null;
        }
        ICPPClassTemplatePartialSpecialization bestMatch = null;
        ICPPClassTemplatePartialSpecialization spec = null;
        CPPTemplateParameterMap bestMap = null;
        boolean bestMatchIsBest = true;
        ICPPClassTemplatePartialSpecialization[] iCPPClassTemplatePartialSpecializationArray = specializations;
        int n = specializations.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPClassTemplatePartialSpecialization specialization;
            spec = specialization = iCPPClassTemplatePartialSpecializationArray[n2];
            CPPTemplateParameterMap map = new CPPTemplateParameterMap(args.length);
            if (TemplateArgumentDeduction.fromTemplateArguments(spec.getTemplateParameters(), spec.getTemplateArguments(), args, map)) {
                int compare = CPPTemplates.orderSpecializations(bestMatch, spec);
                if (compare == 0) {
                    bestMatchIsBest = false;
                } else if (compare < 0) {
                    bestMatch = spec;
                    bestMap = map;
                    bestMatchIsBest = true;
                }
            }
            ++n2;
        }
        if (!bestMatchIsBest) {
            return new CPPTemplateDefinition.CPPTemplateProblem(null, 4, null);
        }
        if (bestMatch == null) {
            return null;
        }
        return CPPTemplates.instantiatePartialSpecialization(bestMatch, args, isDef, bestMap);
    }

    private static int orderSpecializations(ICPPClassTemplatePartialSpecialization spec1, ICPPClassTemplatePartialSpecialization spec2) throws DOMException {
        boolean f2IsAtLeastAsSpecializedAsF1;
        if (spec1 == null) {
            return -1;
        }
        boolean f1IsAtLeastAsSpecializedAsF2 = CPPTemplates.isAtLeastAsSpecializedAs(spec1, spec2);
        if (f1IsAtLeastAsSpecializedAsF2 == (f2IsAtLeastAsSpecializedAsF1 = CPPTemplates.isAtLeastAsSpecializedAs(spec2, spec1))) {
            return 0;
        }
        if (f1IsAtLeastAsSpecializedAsF2) {
            return 1;
        }
        return -1;
    }

    private static boolean isAtLeastAsSpecializedAs(ICPPClassTemplatePartialSpecialization f1, ICPPClassTemplatePartialSpecialization f2) throws DOMException {
        CPPTemplateParameterMap deductionMap;
        ICPPTemplateArgument[] targs2;
        ICPPTemplateParameter[] tpars1 = f1.getTemplateParameters();
        ICPPTemplateParameter[] tpars2 = f2.getTemplateParameters();
        ICPPTemplateArgument[] targs1 = f1.getTemplateArguments();
        if (targs1.length != (targs2 = f2.getTemplateArguments()).length) {
            return false;
        }
        int tpars1Len = tpars1.length;
        ICPPTemplateArgument[] args = new ICPPTemplateArgument[tpars1Len];
        CPPTemplateParameterMap transferMap = new CPPTemplateParameterMap(tpars1Len);
        int i = 0;
        while (i < tpars1Len) {
            ICPPTemplateParameter param = tpars1[i];
            CPPTemplateArgument arg = CPPTemplates.uniqueArg(param);
            args[i] = arg;
            transferMap.put(param, (ICPPTemplateArgument)arg);
            ++i;
        }
        ICPPTemplateArgument[] transferredArgs1 = CPPTemplates.instantiateArguments(targs1, transferMap, -1, null);
        if (!TemplateArgumentDeduction.fromTemplateArguments(tpars2, targs2, transferredArgs1, deductionMap = new CPPTemplateParameterMap(2))) {
            return false;
        }
        int i2 = 0;
        while (i2 < targs2.length) {
            ICPPTemplateArgument transferredArg2 = CPPTemplates.instantiateArgument(targs2[i2], deductionMap, -1, null);
            if (!transferredArg2.isSameValue(transferredArgs1[i2])) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    static boolean isValidType(IType t) {
        while (true) {
            if (t instanceof ISemanticProblem) {
                return false;
            }
            if (t instanceof IFunctionType) {
                IFunctionType ft = (IFunctionType)t;
                IType[] iTypeArray = ft.getParameterTypes();
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType parameterType = iTypeArray[n2];
                    if (!CPPTemplates.isValidType(parameterType)) {
                        return false;
                    }
                    ++n2;
                }
                t = ft.getReturnType();
                continue;
            }
            if (t instanceof ICPPPointerToMemberType) {
                ICPPPointerToMemberType mptr = (ICPPPointerToMemberType)t;
                if (!CPPTemplates.isValidType(mptr.getMemberOfClass())) {
                    return false;
                }
                t = mptr.getType();
                continue;
            }
            if (!(t instanceof ITypeContainer)) break;
            t = ((ITypeContainer)t).getType();
        }
        return true;
    }

    static boolean isValidArgument(ICPPTemplateArgument arg) {
        return arg != null && CPPTemplates.isValidType(arg.isTypeValue() ? arg.getTypeValue() : arg.getTypeOfNonTypeValue());
    }

    static ICPPTemplateArgument matchTemplateParameterAndArgument(ICPPTemplateParameter param, ICPPTemplateArgument arg, CPPTemplateParameterMap map) {
        if (arg == null || !CPPTemplates.isValidType(arg.getTypeValue())) {
            return null;
        }
        if (param instanceof ICPPTemplateTypeParameter) {
            IType t = arg.getTypeValue();
            if (t != null && !(t instanceof ICPPTemplateDefinition)) {
                return arg;
            }
            return null;
        }
        if (param instanceof ICPPTemplateTemplateParameter) {
            IType t = arg.getTypeValue();
            if (!(t instanceof ICPPTemplateDefinition)) {
                return null;
            }
            ICPPTemplateParameter[] pParams = null;
            ICPPTemplateParameter[] aParams = null;
            try {
                pParams = ((ICPPTemplateTemplateParameter)param).getTemplateParameters();
                aParams = ((ICPPTemplateDefinition)((Object)t)).getTemplateParameters();
                if (!CPPTemplates.matchTemplateTemplateParameters(pParams, aParams)) {
                    return null;
                }
            }
            catch (DOMException dOMException) {
                return null;
            }
            return arg;
        }
        if (param instanceof ICPPTemplateNonTypeParameter) {
            if (!arg.isNonTypeValue()) {
                return null;
            }
            IType argType = arg.getTypeOfNonTypeValue();
            try {
                IType pType = ((ICPPTemplateNonTypeParameter)param).getType();
                if (pType instanceof ICPPParameterPackType) {
                    pType = ((ICPPParameterPackType)pType).getType();
                }
                if (map != null && pType != null) {
                    pType = CPPTemplates.instantiateType(pType, map, -1, null);
                }
                if (argType instanceof ICPPUnknownType || argType instanceof ISemanticProblem || CPPTemplates.isNonTypeArgumentConvertible(pType, argType)) {
                    return new CPPTemplateArgument(arg.getNonTypeValue(), pType);
                }
                return null;
            }
            catch (DOMException dOMException) {
                return null;
            }
        }
        assert (false);
        return null;
    }

    private static boolean matchTemplateTemplateParameters(ICPPTemplateParameter[] pParams, ICPPTemplateParameter[] aParams) throws DOMException {
        int pi = 0;
        int ai = 0;
        while (pi < pParams.length && ai < aParams.length) {
            ICPPTemplateParameter pp = pParams[pi];
            ICPPTemplateParameter ap = aParams[ai];
            if (ap.isParameterPack() && !pp.isParameterPack()) {
                return false;
            }
            boolean pb = pp instanceof ICPPTemplateTypeParameter;
            boolean ab = ap instanceof ICPPTemplateTypeParameter;
            if (pb != ab) {
                return false;
            }
            if (!pb) {
                pb = pp instanceof ICPPTemplateNonTypeParameter;
                ab = ap instanceof ICPPTemplateNonTypeParameter;
                if (pb != ab) {
                    return false;
                }
                if (!pb) {
                    if (!(pp instanceof ICPPTemplateTemplateParameter) || !(ap instanceof ICPPTemplateTemplateParameter)) {
                        assert (false);
                        return false;
                    }
                    if (!CPPTemplates.matchTemplateTemplateParameters(((ICPPTemplateTemplateParameter)pp).getTemplateParameters(), ((ICPPTemplateTemplateParameter)ap).getTemplateParameters())) {
                        return false;
                    }
                }
            }
            if (!pp.isParameterPack()) {
                ++pi;
            }
            ++ai;
        }
        if (pi < pParams.length) {
            return pi == pParams.length - 1 && pParams[pi].isParameterPack();
        }
        return ai == aParams.length;
    }

    private static boolean isNonTypeArgumentConvertible(IType paramType, IType arg) throws DOMException {
        if (paramType instanceof IFunctionType) {
            paramType = new CPPPointerType(paramType);
        } else if (paramType instanceof IArrayType) {
            paramType = new CPPPointerType(((IArrayType)paramType).getType());
        }
        Cost cost = Conversions.checkImplicitConversionSequence(paramType, arg, IASTExpression.ValueCategory.LVALUE, Conversions.UDCMode.FORBIDDEN, Conversions.Context.ORDINARY);
        return cost != null && cost.converts();
    }

    static boolean argsAreTrivial(ICPPTemplateParameter[] pars, ICPPTemplateArgument[] args) {
        if (pars.length != args.length) {
            return false;
        }
        int i = 0;
        while (i < args.length) {
            ICPPTemplateParameter par = pars[i];
            ICPPTemplateArgument arg = args[i];
            if (par instanceof IType) {
                if (arg.isNonTypeValue()) {
                    return false;
                }
                IType argType = arg.getTypeValue();
                if (argType == null) {
                    return false;
                }
                if (par.isParameterPack()) {
                    if (!(argType instanceof ICPPParameterPackType)) {
                        return false;
                    }
                    if ((argType = ((ICPPParameterPackType)argType).getType()) == null) {
                        return false;
                    }
                }
                if (!argType.isSameType((IType)((Object)par))) {
                    return false;
                }
            } else {
                if (arg.isTypeValue()) {
                    return false;
                }
                int parpos = Value.isTemplateParameter(arg.getNonTypeValue());
                if (parpos != par.getParameterID()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean hasDependentArgument(ICPPTemplateArgument[] args) {
        ICPPTemplateArgument[] iCPPTemplateArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
            if (CPPTemplates.isDependentArgument(arg)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isDependentArgument(ICPPTemplateArgument arg) {
        if (arg.isTypeValue()) {
            return CPPTemplates.isDependentType(arg.getTypeValue());
        }
        return Value.isDependentValue(arg.getNonTypeValue());
    }

    public static boolean containsDependentType(List<IType> ts) {
        for (IType t : ts) {
            if (!CPPTemplates.isDependentType(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsDependentType(IType[] ts) {
        IType[] iTypeArray = ts;
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            if (CPPTemplates.isDependentType(t)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isDependentType(IType t) {
        while (true) {
            IValue asize;
            if (t instanceof ICPPUnknownType) {
                return true;
            }
            if (t instanceof ICPPFunctionType) {
                ICPPFunctionType ft = (ICPPFunctionType)t;
                if (CPPTemplates.containsDependentType(ft.getParameterTypes())) {
                    return true;
                }
                t = ft.getReturnType();
                continue;
            }
            if (t instanceof ICPPPointerToMemberType) {
                ICPPPointerToMemberType ptmt = (ICPPPointerToMemberType)t;
                if (CPPTemplates.isDependentType(ptmt.getMemberOfClass())) {
                    return true;
                }
                t = ptmt.getType();
                continue;
            }
            if (t instanceof ICPPParameterPackType) {
                return true;
            }
            if (!(t instanceof ITypeContainer)) break;
            if (t instanceof IArrayType && (asize = ((IArrayType)t).getSize()) != null && Value.isDependentValue(asize)) {
                return true;
            }
            t = ((ITypeContainer)t).getType();
        }
        if (t instanceof InitializerListType) {
            return CPPTemplates.isDependentInitializerList(((InitializerListType)t).getInitializerList());
        }
        return false;
    }

    private static boolean isDependentInitializerList(ICPPASTInitializerList initializerList) {
        IASTInitializerClause[] clauses;
        IASTInitializerClause[] iASTInitializerClauseArray = clauses = initializerList.getClauses();
        int n = clauses.length;
        int n2 = 0;
        while (n2 < n) {
            IType t;
            IASTInitializerClause clause = iASTInitializerClauseArray[n2];
            if (clause instanceof IASTExpression ? CPPTemplates.isDependentType(t = ((IASTExpression)clause).getExpressionType()) : clause instanceof ICPPASTInitializerList && CPPTemplates.isDependentInitializerList((ICPPASTInitializerList)clause)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean containsDependentArg(ObjectMap tpMap) {
        Object[] objectArray = tpMap.valueArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (CPPTemplates.isDependentType((IType)arg)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IBinding resolveUnknown(ICPPUnknownBinding unknown, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within) throws DOMException {
        if (unknown instanceof ICPPDeferredClassInstance) {
            return CPPTemplates.resolveDeferredClassInstance((ICPPDeferredClassInstance)unknown, tpMap, packOffset, within);
        }
        IBinding owner = unknown.getOwner();
        if (!(owner instanceof ICPPTemplateTypeParameter) && !(owner instanceof ICPPUnknownClassType)) {
            return unknown;
        }
        IBinding result = unknown;
        IType t = CPPTemplates.instantiateType((IType)((Object)owner), tpMap, packOffset, within);
        if (t != null) {
            IScope s;
            if ((t = SemanticUtil.getUltimateType(t, false)) instanceof ICPPUnknownBinding) {
                if (unknown instanceof ICPPUnknownClassInstance) {
                    ICPPUnknownClassInstance ucli = (ICPPUnknownClassInstance)unknown;
                    ICPPTemplateArgument[] arguments = ucli.getArguments();
                    ICPPTemplateArgument[] newArgs = CPPTemplates.instantiateArguments(arguments, tpMap, packOffset, within);
                    if (!t.equals(owner) && newArgs != arguments) {
                        newArgs = SemanticUtil.getSimplifiedArguments(newArgs);
                        result = new CPPUnknownClassInstance((ICPPUnknownBinding)((Object)t), ucli.getNameCharArray(), newArgs);
                    }
                } else if (!t.equals(owner)) {
                    result = unknown instanceof ICPPUnknownClassType ? new CPPUnknownClass((ICPPUnknownBinding)((Object)t), unknown.getNameCharArray()) : (unknown instanceof IFunction ? new CPPUnknownClass((ICPPUnknownBinding)((Object)t), unknown.getNameCharArray()) : new CPPUnknownBinding((ICPPUnknownBinding)((Object)t), unknown.getNameCharArray()));
                }
            } else if (t instanceof ICPPClassType && (s = ((ICPPClassType)t).getCompositeScope()) != null) {
                result = CPPSemantics.resolveUnknownName(s, unknown);
                if (unknown instanceof ICPPUnknownClassInstance && result instanceof ICPPTemplateDefinition) {
                    ICPPTemplateArgument[] newArgs = CPPTemplates.instantiateArguments(((ICPPUnknownClassInstance)unknown).getArguments(), tpMap, packOffset, within);
                    if (result instanceof ICPPClassTemplate) {
                        result = CPPTemplates.instantiate((ICPPClassTemplate)result, newArgs, false);
                    }
                }
            }
        }
        return result;
    }

    private static IBinding resolveDeferredClassInstance(ICPPDeferredClassInstance dci, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within) {
        IBinding inst;
        ICPPTemplateArgument[] newArgs;
        ICPPTemplateArgument[] arguments = dci.getTemplateArguments();
        try {
            newArgs = CPPTemplates.instantiateArguments(arguments, tpMap, packOffset, within);
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        boolean changed = arguments != newArgs;
        ICPPClassTemplate classTemplate = dci.getClassTemplate();
        IType classTemplateSpecialization = CPPTemplates.instantiateType(classTemplate, tpMap, packOffset, within);
        if (classTemplateSpecialization != classTemplate && classTemplateSpecialization instanceof ICPPClassTemplate) {
            classTemplate = (ICPPClassTemplate)classTemplateSpecialization;
            changed = true;
        }
        if (changed && (inst = CPPTemplates.instantiate(classTemplate, newArgs, false)) != null) {
            return inst;
        }
        return dci;
    }

    public static boolean haveSameArguments(ICPPTemplateInstance i1, ICPPTemplateInstance i2) {
        ICPPTemplateArgument[] m1 = i1.getTemplateArguments();
        ICPPTemplateArgument[] m2 = i2.getTemplateArguments();
        if (m1 == null || m2 == null || m1.length != m2.length) {
            return false;
        }
        String s1 = ASTTypeUtil.getArgumentListString(m1, true);
        String s2 = ASTTypeUtil.getArgumentListString(m2, true);
        return s1.equals(s2);
    }

    public static ICPPTemplateParameterMap createParameterMap(ICPPTemplateDefinition tdef, ICPPTemplateArgument[] args) {
        ICPPTemplateParameter[] tpars = tdef.getTemplateParameters();
        int len = Math.min(tpars.length, args.length);
        CPPTemplateParameterMap result = new CPPTemplateParameterMap(len);
        int i = 0;
        while (i < len) {
            result.put(tpars[i], args[i]);
            ++i;
        }
        return result;
    }

    @Deprecated
    public static IType[] getArguments(ICPPTemplateArgument[] arguments) {
        IType[] types = new IType[arguments.length];
        int i = 0;
        while (i < types.length) {
            ICPPTemplateArgument arg = arguments[i];
            types[i] = arg == null ? null : (arg.isNonTypeValue() ? arg.getTypeOfNonTypeValue() : arg.getTypeValue());
            ++i;
        }
        return types;
    }

    @Deprecated
    public static ObjectMap getArgumentMap(IBinding b, ICPPTemplateParameterMap tpmap) {
        Integer[] keys = tpmap.getAllParameterPositions();
        if (keys.length == 0) {
            return ObjectMap.EMPTY_MAP;
        }
        ArrayList<ICPPTemplateDefinition> defs = new ArrayList<ICPPTemplateDefinition>();
        IBinding owner = b;
        while (owner != null) {
            if (owner instanceof ICPPTemplateDefinition) {
                defs.add((ICPPTemplateDefinition)owner);
            } else if (owner instanceof ICPPTemplateInstance) {
                defs.add(((ICPPTemplateInstance)owner).getTemplateDefinition());
            }
            owner = owner.getOwner();
        }
        Collections.reverse(defs);
        ObjectMap result = new ObjectMap(keys.length);
        Integer[] integerArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateArgument arg;
            ICPPTemplateDefinition tdef;
            ICPPTemplateParameter[] tps;
            int key = integerArray[n2];
            int nestingLevel = key >> 16;
            int numParam = key & 0xFFFF;
            if (numParam >= 0 && nestingLevel >= 0 && nestingLevel < defs.size() && numParam < (tps = (tdef = (ICPPTemplateDefinition)defs.get(nestingLevel)).getTemplateParameters()).length && (arg = tpmap.getArgument(key)) != null) {
                IType type = arg.isNonTypeValue() ? arg.getTypeOfNonTypeValue() : arg.getTypeValue();
                result.put(tps[numParam], type);
            }
            ++n2;
        }
        return result;
    }

    public static IBinding findDeclarationForSpecialization(IBinding binding) {
        while (binding instanceof ICPPSpecialization) {
            if (ASTInternal.hasDeclaration(binding)) {
                return binding;
            }
            IBinding original = ((ICPPSpecialization)binding).getSpecializedBinding();
            if (original == null) {
                return binding;
            }
            binding = original;
        }
        return binding;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TypeSelection {
        PARAMETERS,
        RETURN_TYPE,
        PARAMETERS_AND_RETURN_TYPE;

    }
}

