/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CExternalSetting;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingChangeEvent;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingContainerFactory;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsContainer;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsContainerChangeInfo;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsDeltaProcessor;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsHolder;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettinsDeltaCalculator;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.CRefSettingsHolder;
import org.eclipse.cdt.internal.core.settings.model.CSettingsRefInfo;
import org.eclipse.cdt.internal.core.settings.model.CfgExportSettingContainerFactory;
import org.eclipse.cdt.internal.core.settings.model.ExtensionContainerFactory;
import org.eclipse.cdt.internal.core.settings.model.ICExternalSettingsListener;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CExternalSettingsManager
implements ICExternalSettingsListener,
ICProjectDescriptionListener {
    private static final int OP_CHANGED = 1;
    private static final int OP_ADDED = 2;
    private static final int OP_REMOVED = 3;
    private static final QualifiedName EXTERNAL_SETTING_PROPERTY = new QualifiedName("org.eclipse.cdt.core", "externalSettings");
    private static final String EXTERNAL_SETTING_STORAGE_ID = "org.eclipse.cdt.core.externalSettings";
    private Map<String, FactoryDescriptor> fFactoryMap = new HashMap<String, FactoryDescriptor>();
    private static CExternalSettingsManager fInstance;
    private volatile IWorkspaceRunnable workspaceReconcileRunnable;

    private CExternalSettingsManager() {
    }

    public void startup() {
        CProjectDescriptionManager.getInstance().addCProjectDescriptionListener(this, 17);
    }

    public void shutdown() {
        for (FactoryDescriptor dr : this.fFactoryMap.values()) {
            dr.shutdown();
        }
        this.fFactoryMap.clear();
        CProjectDescriptionManager.getInstance().removeCProjectDescriptionListener(this);
    }

    public static CExternalSettingsManager getInstance() {
        if (fInstance == null) {
            fInstance = new CExternalSettingsManager();
        }
        return fInstance;
    }

    private FactoryDescriptor getFactoryDescriptor(String id) {
        FactoryDescriptor dr = this.fFactoryMap.get(id);
        if (dr == null) {
            dr = new FactoryDescriptor(id);
            this.fFactoryMap.put(id, dr);
        }
        return dr;
    }

    CExternalSettingContainerFactory getFactory(String id) {
        FactoryDescriptor dr = this.getFactoryDescriptor(id);
        return dr.getFactory();
    }

    @Override
    public void settingsChanged(final IProject project, final String cfgId, final CExternalSettingChangeEvent event) {
        final boolean isWorkspaceReconcile = project == null && cfgId == null;
        IWorkspaceRunnable r = this.workspaceReconcileRunnable;
        if (r != null && isWorkspaceReconcile) {
            return;
        }
        r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                List list;
                if (isWorkspaceReconcile) {
                    CExternalSettingsManager.this.workspaceReconcileRunnable = null;
                }
                ProjDesCfgList[] lists = null;
                CExternalSettingsContainerChangeInfo[] cExternalSettingsContainerChangeInfoArray = event.getChangeInfos();
                int n = cExternalSettingsContainerChangeInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CExternalSettingsContainerChangeInfo info = cExternalSettingsContainerChangeInfoArray[n2];
                    switch (info.getEventType()) {
                        case 1: {
                            int flags = info.getChangeFlags();
                            if ((flags & 2) == 0) break;
                            if (lists == null) {
                                lists = CExternalSettingsManager.this.createCfgListsForEvent(project, cfgId);
                            }
                            ProjDesCfgList[] projDesCfgListArray = lists;
                            int n3 = lists.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                ProjDesCfgList list2 = projDesCfgListArray[n4];
                                int i = 0;
                                while (i < list2.size()) {
                                    CfgListCfgContainer cr = new CfgListCfgContainer(list2, i);
                                    if (CExternalSettingsManager.this.processContainerChange(1, cr, new CfgContainerRefInfoContainer(cr), info.getContainerInfo())) {
                                        ICConfigurationDescription desc = cr.getConfguration(true);
                                        Map<String, String> references = desc.getReferenceInfo();
                                        desc.setReferenceInfo(Collections.EMPTY_MAP);
                                        cr.getConfguration(true).setReferenceInfo(references);
                                    }
                                    ++i;
                                }
                                ++n4;
                            }
                            break;
                        }
                    }
                    ++n2;
                }
                if (lists != null && (list = CExternalSettingsManager.this.getModifiedProjDesList(lists)).size() != 0) {
                    int i = 0;
                    while (i < list.size()) {
                        ICProjectDescription des = (ICProjectDescription)list.get(i);
                        CProjectDescriptionManager.getInstance().setProjectDescription(des.getProject(), des, false, monitor);
                        ++i;
                    }
                }
            }
        };
        if (isWorkspaceReconcile) {
            this.workspaceReconcileRunnable = r;
        }
        CProjectDescriptionManager.runWspModification(r, (IProgressMonitor)new NullProgressMonitor());
    }

    private List<ICProjectDescription> getModifiedProjDesList(ProjDesCfgList[] lists) {
        ArrayList<ICProjectDescription> list = new ArrayList<ICProjectDescription>();
        int i = 0;
        while (i < lists.length) {
            if (lists[i].isWritable()) {
                list.add(lists[i].fProjDes);
            }
            ++i;
        }
        return list;
    }

    private ProjDesCfgList[] createCfgListsForEvent(IProject project, String cfgId) {
        ProjDesCfgList[] lists;
        HashSet<String> set = null;
        if (project != null) {
            ProjDesCfgList l;
            if (cfgId != null) {
                set = new HashSet<String>();
                set.add(cfgId);
            }
            lists = (l = this.createCfgList(project, set)) != null ? new ProjDesCfgList[]{l} : new ProjDesCfgList[]{};
        } else {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            ArrayList<ProjDesCfgList> list = new ArrayList<ProjDesCfgList>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                ProjDesCfgList l = this.createCfgList(p, set);
                if (l != null) {
                    list.add(l);
                }
                ++n2;
            }
            lists = list.toArray(new ProjDesCfgList[list.size()]);
        }
        return lists;
    }

    private ProjDesCfgList createCfgList(IProject project, Set<String> cfgIdSet) {
        ICProjectDescription des = CProjectDescriptionManager.getInstance().getProjectDescription(project, false);
        if (des == null) {
            return null;
        }
        return new ProjDesCfgList(des, cfgIdSet);
    }

    private boolean processContainerChange(int op, ICfgContainer cr, CfgContainerRefInfoContainer riContainer, CContainerRef crInfo) {
        ICConfigurationDescription cfg = cr.getConfguration(false);
        CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas = this.checkExternalSettingsChange(op, cfg.getProjectDescription().getProject(), cfg, riContainer, crInfo);
        if (deltas != null) {
            return CExternalSettingsDeltaProcessor.applyDelta(cr.getConfguration(true), deltas);
        }
        return false;
    }

    private CSettingsRefInfo getRefInfo(ICConfigurationDescription cfg, boolean write) {
        CSettingsRefInfo ri;
        if (write && cfg.isReadOnly()) {
            throw new IllegalArgumentException(SettingsModelMessages.getString("CExternalSettingsManager.3"));
        }
        RefInfoContainer cr = (RefInfoContainer)cfg.getSessionProperty(EXTERNAL_SETTING_PROPERTY);
        boolean setCr = false;
        if (cr == null) {
            ri = this.load(cfg);
            if (ri == null) {
                ri = new CSettingsRefInfo();
            }
            setCr = true;
        } else if (write && cr.fInstanceId != cfg.hashCode()) {
            ri = new CSettingsRefInfo(cr.fRefInfo);
            setCr = true;
        } else {
            ri = cr.fRefInfo;
            setCr = false;
        }
        if (setCr) {
            cr = new RefInfoContainer(ri, cfg.hashCode());
            cfg.setSessionProperty(EXTERNAL_SETTING_PROPERTY, cr);
        }
        return ri;
    }

    private CSettingsRefInfo load(ICConfigurationDescription cfg) {
        try {
            ICStorageElement el = cfg.getStorage(EXTERNAL_SETTING_STORAGE_ID, false);
            if (el != null) {
                CSettingsRefInfo ri = new CSettingsRefInfo(el);
                return ri;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    @Override
    public void handleEvent(CProjectDescriptionEvent event) {
        switch (event.getEventType()) {
            case 16: {
                ICProjectDescription des = event.getNewCProjectDescription();
                if (des == null) {
                    return;
                }
                ICConfigurationDescription[] cfgs = des.getConfigurations();
                int i = 0;
                while (i < cfgs.length) {
                    ICConfigurationDescription cfg = cfgs[i];
                    RefInfoContainer cr = (RefInfoContainer)cfg.getSessionProperty(EXTERNAL_SETTING_PROPERTY);
                    if (cr != null) {
                        this.store(cfg, cr.fRefInfo);
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                boolean needsReconcile = false;
                ICConfigurationDescription[] iCConfigurationDescriptionArray = event.getNewCProjectDescription().getConfigurations();
                int n = iCConfigurationDescriptionArray.length;
                int i = 0;
                while (i < n) {
                    ICConfigurationDescription desc = iCConfigurationDescriptionArray[i];
                    if (!desc.getReferenceInfo().isEmpty() || desc.getExternalSettingsProviderIds() != null && desc.getExternalSettingsProviderIds().length > 0) {
                        needsReconcile = true;
                        break;
                    }
                    ++i;
                }
                if (!needsReconcile) {
                    return;
                }
                final IProject project = event.getProject();
                IWorkspaceRunnable r = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        if (!project.isAccessible()) {
                            return;
                        }
                        ProjDesCfgList list = new ProjDesCfgList(CoreModel.getDefault().getProjectDescription(project), null);
                        boolean changed = false;
                        int i = 0;
                        while (i < list.size()) {
                            CfgListCfgContainer cfgCr = new CfgListCfgContainer(list, i);
                            CfgContainerRefInfoContainer ric = new CfgContainerRefInfoContainer(cfgCr);
                            CContainerRef[] refs = ric.getRefInfo(false).getReferences();
                            int k = 0;
                            while (k < refs.length) {
                                if (CExternalSettingsManager.this.processContainerChange(1, cfgCr, new CfgContainerRefInfoContainer(cfgCr), refs[k])) {
                                    ICConfigurationDescription desc = cfgCr.getConfguration(true);
                                    Map<String, String> references = desc.getReferenceInfo();
                                    desc.setReferenceInfo(Collections.EMPTY_MAP);
                                    cfgCr.getConfguration(true).setReferenceInfo(references);
                                    changed = true;
                                }
                                ++k;
                            }
                            ++i;
                        }
                        if (changed) {
                            CProjectDescriptionManager.getInstance().setProjectDescription(project, list.fProjDes);
                        }
                    }
                };
                CProjectDescriptionManager.runWspModification(r, null);
            }
        }
    }

    private void store(ICConfigurationDescription cfg, CSettingsRefInfo ri) {
        try {
            ICStorageElement el = cfg.getStorage(EXTERNAL_SETTING_STORAGE_ID, true);
            el.clear();
            ri.serialize(el);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    public void containerContentsChanged(ICConfigurationDescription cfg, CContainerRef cr) {
        CfgContainer ccr = new CfgContainer(cfg);
        this.processContainerChange(1, ccr, new CfgContainerRefInfoContainer(ccr), cr);
    }

    public void addContainer(ICConfigurationDescription cfg, CContainerRef cr) {
        CfgContainer ccr = new CfgContainer(cfg);
        this.processContainerChange(2, ccr, new CfgContainerRefInfoContainer(ccr), cr);
    }

    public void removeContainer(ICConfigurationDescription cfg, CContainerRef cr) {
        CfgContainer ccr = new CfgContainer(cfg);
        this.processContainerChange(3, ccr, new CfgContainerRefInfoContainer(ccr), cr);
    }

    public CContainerRef[] getReferences(ICConfigurationDescription cfg, String factoryId) {
        CSettingsRefInfo info = this.getRefInfo(cfg, false);
        return info.getReferences(factoryId);
    }

    private CExternalSettinsDeltaCalculator.ExtSettingsDelta[] checkExternalSettingsChange(int op, IProject proj, ICConfigurationDescription cfgDes, CfgContainerRefInfoContainer riContainer, CContainerRef cr) {
        CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas;
        HolderContainer hCr = new HolderContainer(riContainer, cr);
        CRefSettingsHolder holder = hCr.getHolder(false);
        if (holder == null && op == 2) {
            holder = new CRefSettingsHolder(cr);
            hCr.setHolder(holder);
        }
        if (holder == null) {
            return null;
        }
        CExternalSetting[] newSettings = null;
        CExternalSetting[] oldSettings = hCr.getHolder(false).getExternalSettings();
        FactoryDescriptor dr = this.getFactoryDescriptor(cr.getFactoryId());
        ContainerDescriptor cdr = new ContainerDescriptor(dr, cr.getContainerId(), proj, cfgDes, oldSettings);
        newSettings = cdr.getExternalSettings();
        if (op == 3) {
            newSettings = null;
        }
        if ((deltas = CExternalSettinsDeltaCalculator.getInstance().getSettingChange(newSettings, oldSettings)) != null) {
            CRefSettingsHolder holder1 = hCr.getHolder(true);
            holder1.setExternalSettings(newSettings, false);
            holder1.setReconsiled(true);
        }
        if (op == 3) {
            hCr.removeHolder();
        }
        return deltas;
    }

    public void restoreSourceEntryDefaults(ICConfigurationDescription cfg) {
        CfgContainer cr = new CfgContainer(cfg);
        CfgContainerRefInfoContainer ric = new CfgContainerRefInfoContainer(cr);
        CExternalSetting[] settings = ric.getRefInfo(false).createExternalSettings();
        CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas = CExternalSettinsDeltaCalculator.getInstance().getSettingChange(settings, null);
        if (deltas != null) {
            CExternalSettingsDeltaProcessor.applySourceEntriesChange(cfg, deltas);
        }
    }

    public void restoreOutputEntryDefaults(ICConfigurationDescription cfg) {
        CfgContainer cr = new CfgContainer(cfg);
        CfgContainerRefInfoContainer ric = new CfgContainerRefInfoContainer(cr);
        CExternalSetting[] settings = ric.getRefInfo(false).createExternalSettings();
        CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas = CExternalSettinsDeltaCalculator.getInstance().getSettingChange(settings, null);
        if (deltas != null) {
            CExternalSettingsDeltaProcessor.applyOutputEntriesChange(cfg, deltas);
        }
    }

    public void restoreDefaults(ICLanguageSetting ls, int entryKinds) {
        ICConfigurationDescription cfg = ls.getConfiguration();
        CfgContainer cr = new CfgContainer(cfg);
        CfgContainerRefInfoContainer ric = new CfgContainerRefInfoContainer(cr);
        CExternalSetting[] settings = ric.getRefInfo(false).createExternalSettings();
        CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas = CExternalSettinsDeltaCalculator.getInstance().getSettingChange(settings, null);
        if (deltas != null) {
            CExternalSettingsDeltaProcessor.applyDelta(ls, deltas, entryKinds);
        }
    }

    public static final class CContainerRef {
        private final String fFactoryId;
        private final String fContainerId;

        public CContainerRef(String factoryId, String containerId) {
            this.fFactoryId = factoryId;
            this.fContainerId = containerId;
        }

        public String getFactoryId() {
            return this.fFactoryId;
        }

        public String getContainerId() {
            return this.fContainerId;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CContainerRef)) {
                return false;
            }
            CContainerRef other = (CContainerRef)obj;
            if (!this.fContainerId.equals(other.fContainerId)) {
                return false;
            }
            return this.fFactoryId.equals(other.fFactoryId);
        }

        public int hashCode() {
            return this.fFactoryId.hashCode() + this.fContainerId.hashCode();
        }

        public String toString() {
            return String.valueOf(this.fFactoryId.toString()) + " : " + this.fContainerId.toString();
        }
    }

    private static class CfgContainer
    implements ICfgContainer {
        private ICConfigurationDescription fCfgDes;

        CfgContainer(ICConfigurationDescription cfgDes) {
            this.fCfgDes = cfgDes;
        }

        public ICConfigurationDescription getConfguration(boolean write) {
            return this.fCfgDes;
        }
    }

    private class CfgContainerRefInfoContainer {
        private ICfgContainer fCfgContainer;
        private CSettingsRefInfo fRefInfo;
        private boolean fWriteWasRequested;

        CfgContainerRefInfoContainer(ICfgContainer container) {
            this.fCfgContainer = container;
        }

        public CSettingsRefInfo getRefInfo(boolean write) {
            if (this.fRefInfo == null || write && !this.fWriteWasRequested) {
                ICConfigurationDescription cfg = this.fCfgContainer.getConfguration(write);
                this.fRefInfo = CExternalSettingsManager.this.getRefInfo(cfg, write);
                this.fWriteWasRequested |= write;
            }
            return this.fRefInfo;
        }
    }

    private static class CfgListCfgContainer
    implements ICfgContainer {
        private ProjDesCfgList fList;
        private int fNum;

        CfgListCfgContainer(ProjDesCfgList list, int num) {
            this.fList = list;
            this.fNum = num;
        }

        public ICConfigurationDescription getConfguration(boolean write) {
            return this.fList.get(this.fNum, write);
        }
    }

    private static class ContainerDescriptor {
        private FactoryDescriptor fFactoryDr;
        private CExternalSettingsHolder fHolder;
        private CExternalSettingsContainer fContainer;
        private static Set<String> failingProvidersMessages;

        private ContainerDescriptor(FactoryDescriptor factoryDr, String containerId, IProject project, ICConfigurationDescription cfgDes, CExternalSetting[] previousSettings) {
            this.fFactoryDr = factoryDr;
            try {
                this.fContainer = this.fFactoryDr.getFactory().createContainer(containerId, project, cfgDes, previousSettings);
            }
            catch (CoreException e) {
                if (failingProvidersMessages == null) {
                    failingProvidersMessages = new HashSet<String>();
                }
                if (!failingProvidersMessages.contains(e.getMessage())) {
                    CCorePlugin.log(e.getMessage());
                }
                failingProvidersMessages.add(e.getMessage());
            }
            if (this.fContainer == null) {
                this.fContainer = NullContainer.INSTANCE;
            }
        }

        public CExternalSetting[] getExternalSettings() {
            if (this.fHolder == null) {
                this.fHolder = new CExternalSettingsHolder();
                this.fHolder.setExternalSettings(this.fContainer.getExternalSettings(), false);
            }
            return this.fHolder.getExternalSettings();
        }
    }

    private class FactoryDescriptor {
        private CExternalSettingContainerFactory fFactory;
        private String fId;

        private FactoryDescriptor(String id) {
            this.fId = id;
        }

        private CExternalSettingContainerFactory getFactory() {
            if (this.fFactory == null) {
                this.fFactory = this.createFactory(this.fId);
                this.fFactory.startup();
                this.fFactory.addListener(CExternalSettingsManager.this);
            }
            return this.fFactory;
        }

        private CExternalSettingContainerFactory createFactory(String id) {
            if (id.equals("org.eclipse.cdt.core.cfg.export.settings.sipplier")) {
                return CfgExportSettingContainerFactory.getInstance();
            }
            if (id.equals("org.eclipse.cdt.core.extension.container.factory")) {
                return ExtensionContainerFactory.getInstance();
            }
            return NullFactory.INSTANCE;
        }

        public void shutdown() {
            if (this.fFactory != null) {
                this.fFactory.removeListener(CExternalSettingsManager.this);
                this.fFactory.shutdown();
                this.fFactory = null;
            }
        }
    }

    private static class HolderContainer {
        private CfgContainerRefInfoContainer fRIContainer;
        private CRefSettingsHolder fHolder;
        private boolean fWriteWasRequested;
        private CContainerRef fCRef;

        HolderContainer(CfgContainerRefInfoContainer cr, CContainerRef cref) {
            this.fRIContainer = cr;
            this.fCRef = cref;
        }

        CRefSettingsHolder getHolder(boolean write) {
            if (this.fHolder == null || write && !this.fWriteWasRequested) {
                CSettingsRefInfo ri = this.fRIContainer.getRefInfo(write);
                this.fHolder = ri.get(this.fCRef);
                this.fWriteWasRequested |= write;
            }
            return this.fHolder;
        }

        void setHolder(CRefSettingsHolder holder) {
            this.fRIContainer.getRefInfo(true).put(holder);
            this.fWriteWasRequested = true;
            this.fHolder = holder;
        }

        void removeHolder() {
            this.fWriteWasRequested = true;
            this.fHolder = null;
            this.fRIContainer.getRefInfo(true).remove(this.fCRef);
        }
    }

    private static interface ICfgContainer {
        public ICConfigurationDescription getConfguration(boolean var1);
    }

    static class NullContainer
    extends CExternalSettingsContainer {
        static final NullContainer INSTANCE = new NullContainer();

        NullContainer() {
        }

        public CExternalSetting[] getExternalSettings() {
            return new CExternalSetting[0];
        }
    }

    private static class NullFactory
    extends CExternalSettingContainerFactory {
        static NullFactory INSTANCE = new NullFactory();

        private NullFactory() {
        }

        public CExternalSettingsContainer createContainer(String id, IProject project, ICConfigurationDescription cfgDes, CExternalSetting[] previousSettings) throws CoreException {
            return NullContainer.INSTANCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjDesCfgList {
        private ICProjectDescription fProjDes;
        private List<ICConfigurationDescription> fCfgList = new ArrayList<ICConfigurationDescription>();

        public ProjDesCfgList(ICProjectDescription des, Set<String> idSet) {
            this.fProjDes = des;
            ICConfigurationDescription[] cfgs = des.getConfigurations();
            int i = 0;
            while (i < cfgs.length) {
                if (idSet == null || idSet.contains(cfgs[i].getId())) {
                    this.fCfgList.add(cfgs[i]);
                }
                ++i;
            }
        }

        public boolean isWritable() {
            return !this.fProjDes.isReadOnly();
        }

        public ICConfigurationDescription get(int num, boolean write) {
            if (write && this.fProjDes.isReadOnly()) {
                this.makeWritable();
            }
            return this.fCfgList.get(num);
        }

        private void makeWritable() {
            ICProjectDescription writeDes;
            this.fProjDes = writeDes = CProjectDescriptionManager.getInstance().getProjectDescription(this.fProjDes.getProject());
            int i = 0;
            while (i < this.fCfgList.size()) {
                ICConfigurationDescription cfg = this.fCfgList.get(i);
                if ((cfg = writeDes.getConfigurationById(cfg.getId())) != null) {
                    this.fCfgList.set(i, cfg);
                } else {
                    this.fCfgList.remove(i);
                }
                ++i;
            }
        }

        public int size() {
            return this.fCfgList.size();
        }
    }

    private static class RefInfoContainer {
        CSettingsRefInfo fRefInfo;
        int fInstanceId;

        RefInfoContainer(CSettingsRefInfo ri, int id) {
            this.fRefInfo = ri;
            this.fInstanceId = id;
        }
    }
}

