/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.xcoff.parser;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.BinaryFile;
import org.eclipse.cdt.utils.xcoff.AR;
import org.eclipse.cdt.utils.xcoff.parser.XCOFFBinaryObject;
import org.eclipse.core.runtime.IPath;

public class XCOFFBinaryArchive
extends BinaryFile
implements IBinaryParser.IBinaryArchive {
    private ArrayList<IBinaryParser.IBinaryObject> children;

    public XCOFFBinaryArchive(IBinaryParser parser, IPath path) throws IOException {
        super(parser, path, 8);
        new AR(path.toOSString()).dispose();
        this.children = new ArrayList(5);
    }

    public IBinaryParser.IBinaryObject[] getObjects() {
        if (this.hasChanged()) {
            this.children.clear();
            AR ar = null;
            try {
                ar = new AR(this.getPath().toOSString());
                AR.MemberHeader[] headers = ar.getHeaders();
                int i = 0;
                while (i < headers.length) {
                    XCOFFBinaryObject bin = new XCOFFBinaryObject(this.getBinaryParser(), this.getPath(), headers[i]);
                    this.children.add(bin);
                    ++i;
                }
            }
            catch (IOException iOException) {}
            if (ar != null) {
                ar.dispose();
            }
            this.children.trimToSize();
        }
        return this.children.toArray(new IBinaryParser.IBinaryObject[0]);
    }
}

