/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.button.splitButton;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.button.splitButton.DACustomSplitButton;
import org.tizen.dynamicanalyzer.widgets.button.splitButton.DACustomSplitButtonAttribute;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;

public abstract class DACustomSplitButtonClickEventListener
extends DACustomButtonClickEventListener {
    @Override
    public void handleEvent(Event event) {
        DACustomButton button = (DACustomButton)event.widget;
        if (button != null && button.getState() != 3) {
            Rectangle rectangle = button.getBounds();
            int x = event.x;
            int y = event.y;
            if (x < 0 || x > rectangle.width || y < 0 || y > rectangle.height) {
                return;
            }
        } else {
            return;
        }
        String tooltip = button.getToolTipText();
        button.setToolTipText(null);
        DACustomSplitButton splitButton = (DACustomSplitButton)button;
        if (this.isShowMenu(splitButton, event.x, event.y)) {
            this.handleMenuEvent(splitButton);
        } else {
            this.handleClickEvent(button);
        }
        if (!button.isDisposed()) {
            button.setToolTipText(tooltip);
        }
    }

    private void handleMenuEvent(DACustomSplitButton button) {
        Point p = button.toDisplay(0, 0);
        DAPopupMenu popupMenu = button.getPopupMenu();
        popupMenu.open(popupMenu.getTopShell(), p.x, p.y + button.getBounds().height);
    }

    private boolean isShowMenu(DACustomSplitButton button, int x, int y) {
        DACustomSplitButtonAttribute attr = button.getAttr();
        Point startArea = attr.getPolygonAreaPoint(0);
        Point endArea = attr.getPolygonAreaPoint(1);
        return x >= startArea.x && y > startArea.y && x <= endArea.x && y <= endArea.y;
    }
}

