/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.graph.bar;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;
import org.tizen.dynamicanalyzer.widgets.helper.Formatter;

public class SingleBar
extends Canvas {
    public static int TYPE_PERCENT = 0;
    public static int TYPE_BYTE = 1;
    private static final int TOP_MARGIN = 5;
    private static final int BOTTOM_MARGIN = 4;
    private static final int BOTTOM_FULL_MARGIN = 15;
    private int graphType = TYPE_PERCENT;
    private long maxSize = 0L;
    private long currentSize = 0L;
    private Color graphColor;
    private Color fontColor;
    private Color bgColor;
    private Color grayColor;
    private Font font;
    private PaintListener barPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            int endY;
            Canvas canvas = (Canvas)e.widget;
            canvas.setBackground(SingleBar.this.bgColor);
            Rectangle rect = canvas.getClientArea();
            int graphHeight = rect.height - 5 - 15;
            int maxDrawCount = graphHeight / 2;
            maxDrawCount = graphHeight % 2 > 0 ? maxDrawCount + 1 : maxDrawCount;
            int drawCount = 0;
            if (SingleBar.this.maxSize > 0L) {
                drawCount = (int)((long)maxDrawCount * SingleBar.this.currentSize / SingleBar.this.maxSize);
            }
            int startY = rect.y + 5;
            int y = endY = startY + graphHeight;
            int i = 0;
            while (i <= maxDrawCount) {
                if (i > drawCount || i == 0 && SingleBar.this.currentSize == 0L) {
                    e.gc.setForeground(SingleBar.this.grayColor);
                } else {
                    e.gc.setForeground(SingleBar.this.graphColor);
                }
                e.gc.drawLine(rect.x, y, rect.x + rect.width, y);
                e.gc.setForeground(SingleBar.this.bgColor);
                e.gc.drawLine(rect.x, --y, rect.x + rect.width, y);
                --y;
                ++i;
            }
            int textY = endY + 4;
            e.gc.setForeground(SingleBar.this.fontColor);
            e.gc.setFont(SingleBar.this.font);
            String value = null;
            value = SingleBar.this.graphType == TYPE_BYTE ? Formatter.toByteFormatValue(SingleBar.this.currentSize) : Long.toString(SingleBar.this.currentSize);
            Point textSize = e.gc.textExtent(value, 8);
            e.gc.drawText(value, rect.width - textSize.x - 2, textY);
        }
    };

    public SingleBar(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(this.barPaintListener);
        this.graphColor = ColorResources.BLUE;
        this.fontColor = ColorResources.RED;
        this.bgColor = ColorResources.BLACK;
        this.grayColor = ColorResources.BAR_GRAY1;
        this.font = new Font((Device)this.getDisplay(), new FontData[]{new FontData("Arial", 7, 0)});
    }

    public SingleBar(Composite parent, int style, int type) {
        this(parent, style);
        this.graphType = type;
    }

    public void setMaxSize(long max) {
        this.maxSize = max;
    }

    public void setCurrentSize(long current) {
        this.currentSize = current;
    }

    public void setColors(Color graph, Color bg, Color gray, Color font) {
        this.graphColor = graph;
        this.bgColor = bg;
        this.grayColor = gray;
        this.fontColor = font;
    }

    public void setBgColor(Color bg) {
        this.bgColor = bg;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
    }
}

