/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.dwarf;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.symbols.ISection;
import org.eclipse.cdt.debug.edc.internal.symbols.ModuleLineEntryProvider;
import org.eclipse.cdt.debug.edc.internal.symbols.Scope;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfDebugInfoProvider;
import org.eclipse.cdt.debug.edc.services.IFrameRegisterProvider;
import org.eclipse.cdt.debug.edc.symbols.ICompileUnitScope;
import org.eclipse.cdt.debug.edc.symbols.IEnumerator;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.IModuleLineEntryProvider;
import org.eclipse.cdt.debug.edc.symbols.IModuleScope;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.IVariable;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.core.runtime.IPath;

public class DwarfModuleScope
extends Scope
implements IModuleScope {
    private final DwarfDebugInfoProvider provider;
    private ModuleLineEntryProvider lineEntryMapper;

    public DwarfModuleScope(DwarfDebugInfoProvider provider) {
        super("", null, null, null);
        this.provider = provider;
        if (provider == null) {
            this.lowAddress = Addr32.ZERO;
            this.highAddress = Addr32.ZERO;
        } else {
            this.name = provider.getSymbolFile().lastSegment();
            this.lowAddress = Addr32.MAX;
            this.highAddress = Addr32.ZERO;
            for (ISection section : provider.getExecutableSymbolicsReader().getSections()) {
                IAddress end;
                if (!section.getProperties().get("name").equals(".data")) continue;
                if (section.getLinkAddress().compareTo((Object)this.lowAddress) < 0) {
                    this.lowAddress = section.getLinkAddress();
                }
                if ((end = section.getLinkAddress().add(section.getSize())).compareTo((Object)this.highAddress) <= 0) continue;
                this.highAddress = end;
            }
        }
    }

    @Override
    public IPath getSymbolFile() {
        return this.provider.getSymbolFile();
    }

    @Override
    public ICompileUnitScope getCompileUnitForAddress(IAddress linkAddress) {
        if (this.provider != null) {
            return this.provider.getCompileUnitForAddress(linkAddress);
        }
        return null;
    }

    @Override
    public List<ICompileUnitScope> getCompileUnitsForFile(IPath filePath) {
        if (this.provider != null) {
            return this.provider.getCompileUnitsForFile(filePath);
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<IFunctionScope> getFunctionsByName(String name) {
        if (this.provider != null) {
            return this.provider.getFunctionsByName(name);
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<IVariable> getVariablesByName(String name, boolean globalsOnly) {
        if (this.provider != null) {
            return this.provider.getVariablesByName(name, globalsOnly);
        }
        return Collections.emptyList();
    }

    @Override
    public IScope getScopeAtAddress(IAddress linkAddress) {
        this.ensureParsed();
        return super.getScopeAtAddress(linkAddress);
    }

    @Override
    public Collection<IEnumerator> getEnumerators() {
        this.ensureParsed();
        return super.getEnumerators();
    }

    @Override
    public Collection<IScope> getChildren() {
        this.ensureParsed();
        return super.getChildren();
    }

    @Override
    public Collection<IVariable> getVariables() {
        this.ensureParsedForVariables();
        return super.getVariables();
    }

    private void ensureParsed() {
        if (this.provider != null) {
            this.provider.ensureParsedInitially();
        }
    }

    private void ensureParsedForVariables() {
        if (this.provider != null) {
            this.provider.ensureParsedForVariables();
        }
    }

    @Override
    public Collection<IType> getTypes() {
        if (this.provider != null) {
            return this.provider.getTypes();
        }
        return Collections.emptyList();
    }

    @Override
    public IModuleLineEntryProvider getModuleLineEntryProvider() {
        if (this.lineEntryMapper == null) {
            this.lineEntryMapper = new ModuleLineEntryProvider();
            for (IScope scope : this.getChildren()) {
                if (!(scope instanceof ICompileUnitScope)) continue;
                this.lineEntryMapper.addCompileUnit((ICompileUnitScope)scope);
            }
        }
        return this.lineEntryMapper;
    }

    @Override
    public void addChild(IScope scope) {
        super.addChild(scope);
        this.mergeScopeRange(scope);
        if (scope instanceof ICompileUnitScope && this.lineEntryMapper != null) {
            this.lineEntryMapper.addCompileUnit((ICompileUnitScope)scope);
        }
    }

    public void updateLineInfoForCU(ICompileUnitScope scope) {
        if (this.lineEntryMapper != null) {
            this.lineEntryMapper.addCompileUnit(scope);
        }
    }

    @Override
    public IFrameRegisterProvider getFrameRegisterProvider() {
        if (this.provider != null) {
            return this.provider.getFrameRegisterProvider();
        }
        return null;
    }

    @Override
    public void dispose() {
        this.lineEntryMapper = null;
        super.dispose();
    }
}

