/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.button.splitButton;

import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonAttribute;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.button.splitButton.DACustomSplitButtonAttribute;

public class DACustomSplitButtonRenderer
extends DACustomButtonRenderer {
    @Override
    public void draw(GC gc, Canvas canvas, int state, DACustomButtonAttribute attr) {
        DACustomSplitButtonAttribute splitAttr;
        Rectangle rect = canvas.getClientArea();
        if (attr.getDrawType() == 0) {
            this.drawImageButton(gc, rect, state, attr);
        } else if (attr.getDrawType() == 1 || attr.getDrawType() == 2) {
            this.drawButton(gc, rect, state, attr);
        }
        if (attr instanceof DACustomSplitButtonAttribute && (splitAttr = (DACustomSplitButtonAttribute)attr).getSplitButtonType() == 1) {
            this.drawButtonPolygon(gc, rect, splitAttr, state);
        }
    }

    protected void drawButtonPolygon(GC gc, Rectangle rect, DACustomSplitButtonAttribute attr, int state) {
        Color color = null;
        Point startSeparator = attr.getPolygonSeparatorPoint(0);
        Point endSeparator = attr.getPolygonSeparatorPoint(1);
        if (attr.isPolygonSeparator()) {
            color = attr.getPolygonSeparatorColor(state);
            gc.setForeground(color);
            gc.setBackground(color);
            gc.drawLine(startSeparator.x, startSeparator.y, endSeparator.x, endSeparator.y);
        }
        attr.setPolygonAreaPoint(0, new Point(startSeparator.x, 0));
        attr.setPolygonAreaPoint(1, new Point(rect.width, rect.height));
        color = attr.getPolygonColor(state);
        gc.setForeground(color);
        gc.setBackground(color);
        gc.fillPolygon(this.convertArray(attr.getPolygonPoints()));
    }

    private int[] convertArray(List<Point> list) {
        int[] array = new int[list.size() * 2];
        int arrayIndex = 0;
        int i = 0;
        while (i < list.size()) {
            array[arrayIndex++] = list.get((int)i).x;
            array[arrayIndex++] = list.get((int)i).y;
            ++i;
        }
        return array;
    }
}

