/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.chart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.helper.FontResources;

public class DAChartSeries {
    public static final int SERIES_STYLE_NONE = 0;
    public static final int SERIES_STYLE_LINE = 1;
    public static final int SERIES_STYLE_BAR = 2;
    public static final int SERIES_STYLE_AREA = 3;
    public static final int SERIES_STYLE_STACK_BAR = 4;
    public static final int SERIES_STYLE_AREA_STACK = 5;
    public static final int SERIES_STYLE_STEP = 6;
    public static final int SERIES_STYLE_IMAGE = 7;
    public static final int SERIES_STYLE_EVENT = 8;
    public static final int SERIES_STYLE_EVENT_AREA = 9;
    public static final int SERIES_STYLE_MULTI_CHECK_BAR = 10;
    public static final int SERIES_STYLE_LOAD = 11;
    public static final int SERIES_STYLE_ARROW = 12;
    public static final int SERIES_STYLE_STATE = 13;
    public static final int SERIES_STYLE_LAST_CONTINUE_STEP = 14;
    public static final int SERIES_STYLE_MULTI_LINE = 15;
    public static final int SERIES_STYLE_STATE_AREA = 16;
    public static final int SERIES_STYLE_DOT = 17;
    public static final double SERIES_DEFAULT_BAR_WIDTH = 0.5;
    public static final int SERIES_BAR_ALIGN_LEFT = 0;
    public static final int SERIES_BAR_ALIGN_CENTER = 1;
    public static final int SERIES_BAR_ALIGN_RIGHT = 2;
    private Object data;
    private String name;
    private int style = 0;
    private List<DAChartSeriesItem> seriesItems = Collections.synchronizedList(new ArrayList());
    private Color color;
    private Color secondColor;
    private double alpha = 0.2;
    private double barWidth = 0.5;
    private int barAlign = 0;
    private double maxX = 0.0;
    private double maxY = 0.0;
    private double endX = 0.0;
    private double endY = 0.0;
    private boolean hasUpdate = false;
    private Font font;
    private boolean summarizeTooltip = false;
    private String summarizeString;
    private boolean disableTooltip = false;

    public DAChartSeries(String name, int style) {
        this.name = name;
        this.style = style;
    }

    public DAChartSeries(String name, int style, Color color) {
        this(name, style);
        this.color = color;
    }

    public DAChartSeries(String name, int style, Color color, double alpha) {
        this(name, style);
        this.color = color;
        this.alpha = alpha;
    }

    public DAChartSeries(String name, int style, Color color, boolean disableTooltip) {
        this(name, style, color);
        this.disableTooltip = disableTooltip;
    }

    public DAChartSeries(String name, int style, Color color, Color secondColor) {
        this(name, style, color);
        this.setSecondColor(secondColor);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public String getName() {
        return this.name;
    }

    public int getStyle() {
        return this.style;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color Color2) {
        this.color = Color2;
    }

    public boolean isDisableTooltip() {
        return this.disableTooltip;
    }

    public double getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(long barWidth) {
        this.barWidth = barWidth;
    }

    public List<DAChartSeriesItem> getSeriesItemList() {
        return this.seriesItems;
    }

    public void addSeriesItem(DAChartSeriesItem item) {
        int insert = 0;
        int i = this.seriesItems.size();
        while (i > 0) {
            if (this.seriesItems.get(i - 1).getX() <= item.getX()) {
                insert = i;
                break;
            }
            --i;
        }
        if (this.maxX < item.getX()) {
            this.maxX = item.getX();
        }
        if (this.maxY < item.getY()) {
            this.maxY = item.getY();
        }
        this.seriesItems.add(insert, item);
        this.hasUpdate = true;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public int getPrevIndexByXvalue(double x) {
        int seriesItemSize = this.seriesItems.size();
        if (seriesItemSize <= 0) {
            return -1;
        }
        int current = seriesItemSize <= (int)x ? seriesItemSize - 1 : ((int)x < 0 ? 0 : (int)x);
        if (this.seriesItems.get(current).getX() == x) {
            int i = current + 1;
            while (i < seriesItemSize) {
                if (this.seriesItems.get(i).getX() != x) break;
                ++i;
            }
            return i - 1;
        }
        if (this.seriesItems.get(current).getX() < x) {
            int i = current;
            while (i < seriesItemSize) {
                if (this.seriesItems.get(i).getX() > x) break;
                ++i;
            }
            return i - 1;
        }
        int i = current;
        while (i >= 0) {
            if (this.seriesItems.get(i).getX() <= x) break;
            --i;
        }
        return i;
    }

    public int getNextIndexByXvalue(double x) {
        int seriesItemSize = this.seriesItems.size();
        if (seriesItemSize <= 0) {
            return -1;
        }
        int current = seriesItemSize <= (int)x ? seriesItemSize - 1 : ((int)x < 0 ? 0 : (int)x);
        if (this.seriesItems.get(current).getX() == x) {
            return current;
        }
        if (this.seriesItems.get(current).getX() < x) {
            int i = current;
            while (i < seriesItemSize) {
                if (this.seriesItems.get(i).getX() >= x) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        int i = current;
        while (i >= 0) {
            if (this.seriesItems.get(i).getX() < x) break;
            --i;
        }
        return i + 1;
    }

    public void clear() {
        this.seriesItems.clear();
        this.maxX = 0.0;
        this.maxY = 0.0;
    }

    public double getEndX() {
        return this.endX;
    }

    public void setEndX(double endX) {
        this.endX = endX;
    }

    public double getEndY() {
        return this.endY;
    }

    public void setEndY(double endY) {
        this.endY = endY;
    }

    protected boolean hasUpdate() {
        return this.hasUpdate;
    }

    protected void setUpdate(boolean bUpdate) {
        this.hasUpdate = bUpdate;
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = FontResources.CHART_SERIES_FONT;
        }
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setSummarizeTooltipText(String summarizeString) {
        this.setSummarizeTooltip(true);
        this.setSummarizeString(summarizeString);
    }

    public boolean isSummarizeTooltip() {
        return this.summarizeTooltip;
    }

    public void setSummarizeTooltip(boolean summarizeTooltip) {
        this.summarizeTooltip = summarizeTooltip;
    }

    public String getSummarizeString() {
        return this.summarizeString;
    }

    public void setSummarizeString(String summarizeString) {
        this.summarizeString = summarizeString;
    }

    public int getBarAlign() {
        return this.barAlign;
    }

    public void setBarAlign(int barAlign) {
        this.barAlign = barAlign;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Color getSecondColor() {
        return this.secondColor;
    }

    public void setSecondColor(Color secondColor) {
        this.secondColor = secondColor;
    }
}

