/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.progress;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.widgets.da.base.ProgressManager;
import org.tizen.dynamicanalyzer.widgets.progress.ProgressHolder;

public class CircleProgress
extends Canvas {
    Color barStartColor = ColorResources.POINT;
    Color barEndColor = ColorResources.POINT;
    private int value = 0;
    private boolean mDown;
    private boolean mHover;
    static CircleProgress INSTANCE;

    private void setMDown(boolean value) {
        boolean changed = false;
        if (this.mDown != value) {
            changed = true;
        }
        this.mDown = value;
        if (changed) {
            Display.getDefault().syncExec(() -> {
                INSTANCE.redraw();
                INSTANCE.update();
            });
        }
    }

    private void setMHover(boolean value) {
        boolean changed = false;
        if (this.mHover != value) {
            changed = true;
        }
        this.mHover = value;
        if (changed) {
            Display.getDefault().syncExec(() -> {
                INSTANCE.redraw();
                INSTANCE.update();
            });
        }
    }

    private CircleProgress(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(this::drawCircle);
        this.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                CircleProgress.this.setMDown(false);
            }

            public void mouseDown(MouseEvent e) {
                CircleProgress.this.setMDown(true);
                if (CircleProgress.this.mHover) {
                    ProgressManager.INSTANCE.setBackgroundOnly(false);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                CircleProgress.this.setMHover(true);
            }

            public void mouseExit(MouseEvent e) {
                CircleProgress.this.setMHover(false);
            }

            public void mouseEnter(MouseEvent e) {
                CircleProgress.this.setMHover(true);
            }
        });
    }

    public static CircleProgress getCircleProgress() {
        return INSTANCE;
    }

    public static synchronized CircleProgress getCircleProgress(Composite parent, int style) {
        if (INSTANCE == null) {
            INSTANCE = new CircleProgress(parent, style);
        }
        return INSTANCE;
    }

    public void setValue(int value) {
        if (value < 0 || value > 100) {
            return;
        }
        this.value = value;
        Display.getDefault().syncExec(() -> {
            INSTANCE.redraw();
            INSTANCE.update();
        });
    }

    private void drawCircle(PaintEvent e) {
        Canvas canvas = (Canvas)e.widget;
        Rectangle rect = canvas.getBounds();
        int textOffset = rect.height + 2;
        if (this.mHover) {
            int shift = this.mDown ? 1 : 0;
            e.gc.drawRoundRectangle(shift, shift, rect.height, rect.height, 4, 4);
        }
        e.gc.setForeground(ProgressHolder.barStartBgColor);
        e.gc.setBackground(ProgressHolder.barEndBgColor);
        e.gc.setLineWidth(4);
        e.gc.drawOval(3, 3, rect.height - 5, rect.height - 5);
        int width = this.value * 360 / 100;
        e.gc.setForeground(this.barStartColor);
        e.gc.setBackground(this.barEndColor);
        e.gc.drawArc(3, 3, rect.height - 5, rect.height - 5, 90, -width);
        if (ProgressHolder.percentageFont != null) {
            e.gc.setFont(ProgressHolder.percentageFont);
        }
        if (ProgressHolder.fontColor != null) {
            e.gc.setForeground(ProgressHolder.fontColor);
        }
        String text = ProgressManager.INSTANCE.getUpperString();
        int chars = (rect.width - textOffset) / e.gc.getFontMetrics().getAverageCharWidth();
        chars = text.lastIndexOf(32, chars);
        text = text.substring(0, chars);
        text = String.valueOf(text) + "...";
        e.gc.drawString(text, textOffset, 1, true);
        String percent = String.valueOf(this.value) + "%";
        e.gc.drawString(percent, textOffset, rect.height / 2 + 1, true);
    }
}

