/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.DATime;
import org.tizen.dynamicanalyzer.project.LibraryObject;
import org.tizen.dynamicanalyzer.protocol.DebugLog;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;

public class ProcessInfoData
extends LogData {
    protected int pid = 0;
    protected String cmdname = "";
    protected int ppid = 0;
    protected long starttime = 0L;
    protected long lowAddr = 0L;
    protected long highAddr = 0L;
    protected String binaryPath = "";
    protected List<LibraryObject> libObjects = new ArrayList<LibraryObject>();

    @Override
    public ProcessInfoData clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    protected boolean parse(DATime startTime) {
        super.parse(startTime);
        this.pid = this.getInt();
        this.cmdname = this.getString();
        this.ppid = this.getInt();
        int second = this.getInt();
        int nanosecond = this.getInt();
        this.lowAddr = this.getLong();
        this.highAddr = this.getLong();
        this.binaryPath = this.getString();
        int dependentLibCount = this.getInt();
        if (DebugLog.isEnabled()) {
            DebugLog.printData1("pid(%d) cmd(%s) ppid(%d) sec(%d) nano(%d) ", this.pid, this.cmdname, this.ppid, second, nanosecond);
            DebugLog.printData0("lowAddr(%x) highAddr(%x) path(%s) libcount(%d)\n", this.lowAddr, this.highAddr, this.binaryPath, dependentLibCount);
        }
        int i = 0;
        while (i < dependentLibCount) {
            long lowestAddr = this.getLong();
            long highestAddr = this.getLong();
            String libPath = this.getString();
            if (DebugLog.isEnabled()) {
                DebugLog.printData2("lowAddr(%x) highAddr(%x) libPath(%s)\n", lowestAddr, highestAddr, libPath);
            }
            LibraryObject libObj = new LibraryObject(Global.getProject().getDeviceStatusInfo().getBinaryInfo(libPath).getID(), lowestAddr, highestAddr);
            this.libObjects.add(libObj);
            ++i;
        }
        DATime capturedTime = new DATime(second, nanosecond);
        DATime subTime = capturedTime.subtract(startTime);
        this.starttime = subTime.getLongTime();
        return true;
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    public String getCmdname() {
        return this.cmdname;
    }

    public int getPpid() {
        return this.ppid;
    }

    public long getStartTime() {
        return this.starttime;
    }

    public long getLowAddr() {
        return this.lowAddr;
    }

    public long getHighAddr() {
        return this.highAddr;
    }

    public String getBinaryPath() {
        return this.binaryPath;
    }

    public List<LibraryObject> getLibObjects() {
        return Collections.unmodifiableList(this.libObjects);
    }
}

