/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class ElmPhotocamProperties
extends HierarchyUIObjectProperties {
    private boolean paused;
    private String file;
    private boolean gestureEnabled;
    private double zoom;
    private String zoomMode;
    private int[] imageSize = new int[2];

    public ElmPhotocamProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.paused = parser.getBoolean();
        this.file = parser.getString();
        this.gestureEnabled = parser.getBoolean();
        this.zoom = parser.getFloat();
        this.zoomMode = this.getZoomModeMessage(parser.getChar());
        this.imageSize[0] = parser.getInt();
        this.imageSize[1] = parser.getInt();
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("paused", Boolean.toString(this.paused)));
        properties.add(new PropertyValue("file", this.file));
        properties.add(new PropertyValue("gestureEnabled", Boolean.toString(this.gestureEnabled)));
        properties.add(new PropertyValue("zoom", Double.toString(this.zoom)));
        properties.add(new PropertyValue("zoomMode", this.zoomMode));
        properties.add(new PropertyValue("imageSize", "[" + this.imageSize[0] + ", " + this.imageSize[1] + "]"));
        return properties;
    }

    private String getZoomModeMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_PHOTOCAM_ZOOM_MODE_MANUAL";
            }
            case 1: {
                return "ELM_PHOTOCAM_ZOOM_MODE_AUTO_FIT";
            }
            case 2: {
                return "ELM_PHOTOCAM_ZOOM_MODE_AUTO_FILL";
            }
            case 3: {
                return "ELM_PHOTOCAM_ZOOM_MODE_AUTO_FIT_IN";
            }
            case 4: {
                return "ELM_PHOTOCAM_ZOOM_MODE_LAST";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }
}

