/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class ElmToolbarProperties
extends HierarchyUIObjectProperties {
    private boolean reorderMode;
    private boolean transverseExpanded;
    private boolean homogeneous;
    private double align;
    private String selectMode;
    private int iconSize;
    private boolean horizontal;
    private int standardPriority;
    private int itemCount;

    public ElmToolbarProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.reorderMode = parser.getBoolean();
        this.transverseExpanded = parser.getBoolean();
        this.homogeneous = parser.getBoolean();
        this.align = parser.getFloat();
        this.selectMode = this.getSelectModeMessage(parser.getChar());
        this.iconSize = parser.getInt();
        this.horizontal = parser.getBoolean();
        this.standardPriority = parser.getInt();
        this.itemCount = parser.getInt();
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("reorderMode", Boolean.toString(this.reorderMode)));
        properties.add(new PropertyValue("transverseExpanded", Boolean.toString(this.transverseExpanded)));
        properties.add(new PropertyValue("homogeneous", Boolean.toString(this.homogeneous)));
        properties.add(new PropertyValue("align", Double.toString(this.align)));
        properties.add(new PropertyValue("selectMode", this.selectMode));
        properties.add(new PropertyValue("iconSize", Integer.toString(this.iconSize)));
        properties.add(new PropertyValue("horizontal", Boolean.toString(this.horizontal)));
        properties.add(new PropertyValue("standardPriority", Integer.toString(this.standardPriority)));
        properties.add(new PropertyValue("itemCount", Integer.toString(this.itemCount)));
        return properties;
    }

    private String getSelectModeMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_OBJECT_SELECT_MODE_DEFAULT";
            }
            case 1: {
                return "ELM_OBJECT_SELECT_MODE_ALWAYS";
            }
            case 2: {
                return "ELM_OBJECT_SELECT_MODE_NONE";
            }
            case 3: {
                return "ELM_OBJECT_SELECT_MODE_DISPLAY_ONLY";
            }
            case 4: {
                return "ELM_OBJECT_SELECT_MODE_MAX";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }
}

