/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy.tree.figure;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.figure.HierarchyTreeFigure;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.figure.HierarchyTreeNodeFigure;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.tool.HierarchyZoomManager;

class HierarchyTreeLayout
extends AbstractLayout {
    private static final int DISTANCE = 48;

    HierarchyTreeLayout() {
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        HierarchyTreeFigure tree = (HierarchyTreeFigure)container;
        Rectangle union = tree.getNode().getBounds().getCopy();
        union.union(tree.getBranch().getBounds());
        return union.getSize();
    }

    public void layout(IFigure container) {
        HierarchyTreeFigure tree = (HierarchyTreeFigure)container;
        IFigure branch = tree.getBranch();
        HierarchyTreeNodeFigure node = tree.getNode();
        Rectangle branchBounds = tree.getBounds();
        Point topLeft = branchBounds.getTopLeft();
        Rectangle nodeLocation = new Rectangle(topLeft, node.getPreferredSize());
        if (!branch.isVisible() || branch.getChildren().isEmpty()) {
            nodeLocation.y += (branchBounds.height - nodeLocation.height) / 2;
            node.setBounds(nodeLocation);
            return;
        }
        Rectangle contentsLocation = new Rectangle(topLeft, branch.getPreferredSize());
        contentsLocation.x += nodeLocation.width + HierarchyZoomManager.INSTANCE.getScaled(48);
        int childrenSpan = contentsLocation.height;
        int leftInset = (childrenSpan - nodeLocation.height) / 2;
        if (leftInset > 0) {
            nodeLocation.y += leftInset;
        } else {
            contentsLocation.y -= leftInset;
        }
        int adjust = branchBounds.height - Rectangle.SINGLETON.setBounds((Rectangle)contentsLocation).union((Rectangle)nodeLocation).height;
        nodeLocation.x += (adjust /= 2);
        contentsLocation.x += adjust;
        node.setBounds(nodeLocation);
        branch.setBounds(contentsLocation);
    }
}

