/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.widgets;

import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.button.IDACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomCombo;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomComboSelectionListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DATextBox;

public class FilterInputRow
extends Composite {
    private DACustomCombo columnNameCombo = null;
    private DATextBox keyWordText = null;
    private DACustomButton removeButton = null;
    private String currentlySelectedColumnName = null;

    public FilterInputRow(Composite parent, DACustomButtonClickEventListener removeListener, Listener comboMouseDownListener, boolean isSelected) {
        super(parent, 2048);
        if (isSelected) {
            this.setBackground(ColorResources.PAGE_CHART_SELECTION_BG);
        } else {
            this.setBackground(ColorResources.FILTER_DIALOG_WHITE_BACKGROUND_COLOR);
        }
        Rectangle parentRect = parent.getBounds();
        Control lastChlid = null;
        Control[] children = parent.getChildren();
        if (children.length - 1 > 0) {
            lastChlid = children[children.length - 2];
        }
        FormData data = new FormData();
        data.top = lastChlid != null ? new FormAttachment(lastChlid, 1) : new FormAttachment(0, 1);
        data.height = 40;
        data.left = new FormAttachment(0, 1);
        data.width = parentRect.width - 5;
        this.setLayoutData(data);
        this.setLayout((Layout)new FormLayout());
        this.createColumnNameCombo(comboMouseDownListener);
        data = new FormData();
        data.top = new FormAttachment(0, 8);
        data.left = new FormAttachment(0, 10);
        data.width = 124;
        data.height = 24;
        this.columnNameCombo.setLayoutData((Object)data);
        this.keyWordText = new DATextBox((Composite)this, 4);
        this.keyWordText.setBackground(ColorResources.WHITE);
        data = new FormData();
        data.top = new FormAttachment(0, 8);
        data.left = new FormAttachment((Control)this.columnNameCombo, 2);
        data.width = 212;
        data.height = 20;
        this.keyWordText.setLayoutData((Object)data);
        this.removeButton = new DACustomButton((Composite)this, ImageResources.FILTER_DIALOG_DELETE_FILTER_NORMAL, ImageResources.FILTER_DIALOG_DELETE_FILTER_PUSH, ImageResources.FILTER_DIALOG_DELETE_FILTER_HOVER, ImageResources.FILTER_DIALOG_DELETE_FILTER_NORMAL);
        if (isSelected) {
            this.removeButton.setBackground(ColorResources.PAGE_CHART_SELECTION_BG);
        } else {
            this.removeButton.setBackground(ColorResources.FILTER_DIALOG_WHITE_BACKGROUND_COLOR);
        }
        data = new FormData();
        data.top = new FormAttachment(0, 12);
        data.right = new FormAttachment(100, -20);
        data.width = 24;
        data.height = 16;
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.addClickListener(removeListener);
    }

    private void createColumnNameCombo(Listener comboMouseDownListener) {
        this.columnNameCombo = new DACustomCombo((Composite)this, 0);
        this.columnNameCombo.setComboGradation(ColorResources.TAB_COMBO_NORMAL_START, ColorResources.TAB_COMBO_NORMAL_END, ColorResources.TAB_COMBO_PUSH_START, ColorResources.TAB_COMBO_PUSH_END, ColorResources.TAB_COMBO_HOVER_START, ColorResources.TAB_COMBO_HOVER_END, ColorResources.FRAME_RATE_COMBO_DISABLE_START, ColorResources.FRAME_RATE_COMBO_DISABLE_END);
        this.columnNameCombo.setOutlineColors(ColorResources.TAB_COMBO_NORMAL_STROKE, ColorResources.TAB_COMBO_PUSH_STROKE, ColorResources.TAB_COMBO_HOVER_STROKE, ColorResources.FRAME_RATE_COMBO_OUTLINE_DISABLE);
        this.columnNameCombo.setComboImages(ImageResources.TAB_COMBO_BUTTON_DOWN, ImageResources.TAB_COMBO_BUTTON_DOWN, ImageResources.TAB_COMBO_BUTTON_DOWN, ImageResources.TAB_COMBO_BUTTON_DOWN);
        this.columnNameCombo.setComboImagePoint(new Point(108, 10));
        this.columnNameCombo.setButtonImages(ImageResources.TAB_COMBO_BUTTON_DOWN, ImageResources.TAB_COMBO_BUTTON_DOWN);
        this.columnNameCombo.setFontPoint(new Point(7, 5));
        this.columnNameCombo.setEnabled(true);
        this.columnNameCombo.setComboFont(FontResources.COMBO);
        this.columnNameCombo.setItemFont(FontResources.DROPDOWN);
        this.columnNameCombo.setFontColors(ColorResources.ADD_CHART_FONT_COLOR, ColorResources.ADD_CHART_FONT_COLOR, ColorResources.ADD_CHART_FONT_COLOR, ColorResources.ADD_CHART_FONT_COLOR);
        this.columnNameCombo.setButtonRenderer((IDACustomButtonRenderer)new DACustomButtonRenderer());
        this.columnNameCombo.addListener(3, comboMouseDownListener);
    }

    public String getKeyWord() {
        return this.keyWordText.getText();
    }

    public void setKeyWordText(String keyWord) {
        this.keyWordText.setText(keyWord);
    }

    public String getCurrentlySelectedColumnName() {
        return this.currentlySelectedColumnName;
    }

    public void setCurrentlySelectedColumnName(String columnName) {
        this.currentlySelectedColumnName = columnName;
    }

    public void setComboText(String columnName) {
        this.columnNameCombo.add(columnName);
        this.columnNameCombo.setText(columnName);
        this.currentlySelectedColumnName = this.columnNameCombo.getText();
    }

    public void addColumnNameComboItems(List<String> columnNames) {
        this.columnNameCombo.initCombo();
        int i = 0;
        while (i < columnNames.size()) {
            this.columnNameCombo.add(columnNames.get(i));
            ++i;
        }
        this.columnNameCombo.setText(columnNames.get(0));
        this.currentlySelectedColumnName = this.columnNameCombo.getText();
    }

    public void addSelectionListener(DACustomComboSelectionListener listener) {
        this.columnNameCombo.addSelectionListener(listener);
    }
}

